# Demo System - Настройка завершения воспроизведения

## Обзор изменений

Демо система теперь поддерживает настраиваемое поведение при завершении воспроизведения сессии.

## Новая функциональность

### 1. Автоматическое создание конфигурации

При первом запуске демо режима автоматически создаётся файл конфигурации:
- **Путь**: `~/.config/penguin-tamer/demo/config_demo.yaml`
- **Создание**: Автоматически копируется из пакета при первом использовании
- **Редактирование**: Пользователь может изменять настройки без модификации файлов пакета

### 2. Настройка `finish_string`

Новый параметр в `config_demo.yaml`:

```yaml
playback:
  # String to type at the end of session (e.g., 'quit', 'exit')
  # If empty, session ends without typing anything
  finish_string: quit
```

**Возможные значения**:
- `quit` (по умолчанию) - печатает "quit" в конце сессии
- `exit` - печатает "exit"
- Любая другая строка - будет напечатана как есть
- Пустая строка `""` - завершается без печати, остаётся на промпте

**Поведение**:
1. Если `finish_string` не пустая:
   - Показывается финальный prompt с placeholder
   - Пауза `final_prompt_pause` секунд (по умолчанию 4 сек)
   - Печатается `finish_string`
   - Пауза 1 секунда
   - Завершение

2. Если `finish_string` пустая:
   - Показывается финальный prompt с placeholder
   - Пауза `final_prompt_pause` секунд
   - Очистка строки
   - Показывается чистый prompt `>>>`
   - Завершение

## Примеры использования

### Пример 1: Стандартное завершение (quit)

```yaml
playback:
  finish_string: quit
  final_prompt_pause: 4.0
```

Результат:
```
>>> Your question... Ctrl+C - exit
    [пауза 4 секунды]
>>> quit
    [пауза 1 секунда]
    [выход]
```

### Пример 2: Завершение без печати

```yaml
playback:
  finish_string: ""
  final_prompt_pause: 2.0
```

Результат:
```
>>> Your question... Ctrl+C - exit
    [пауза 2 секунды]
>>>
    [выход]
```

### Пример 3: Кастомная команда

```yaml
playback:
  finish_string: exit
  final_prompt_pause: 3.0
```

Результат:
```
>>> Your question... Ctrl+C - exit
    [пауза 3 секунды]
>>> exit
    [пауза 1 секунда]
    [выход]
```

## Технические детали

### Изменённые файлы

1. **`manager.py`**:
   - Добавлена функция `_ensure_demo_config()` для автоматического создания конфигурации
   - `DemoSystemManager.__init__` вызывает эту функцию
   - Используется конфиг из пользовательской директории вместо пакета

2. **`player.py`**:
   - Метод `_show_final_prompt()` обновлён для поддержки `finish_string`
   - Добавлен `finish_string` в default config
   - Логика выбора: печатать или не печатать

3. **`config_demo.yaml`**:
   - Добавлена настройка `finish_string` с документацией
   - Обновлён комментарий для `final_prompt_pause`

### Обратная совместимость

- Старые конфигурации без `finish_string` будут работать (используется значение по умолчанию "quit")
- Все существующие настройки сохраняют своё поведение
- Пользователи могут не знать о новой настройке - всё работает как раньше

## Тестирование

Все 74 теста проходят успешно:
```bash
pytest tests/ -v
# 74 passed, 4 warnings
```

Проверена работа:
- Создания конфигурации при первом запуске
- Чтения `finish_string` из конфигурации
- Обработки пустой `finish_string`
- Обработки кастомных значений

## Использование в записях

При создании демо записей для показа:

1. **Полная демонстрация** (с quit):
   ```yaml
   finish_string: quit
   ```

2. **Зацикленная демонстрация** (без выхода):
   ```yaml
   finish_string: ""
   ```

3. **Локализованное завершение**:
   ```yaml
   finish_string: выход
   ```
