"""
Intro screen module for Penguin Tamer configuration menu.
Displays animated ASCII art logo before menu launch.
"""

import time
from rich.console import Console


def show_intro():
    """Показывает ASCII-арт интро перед запуском меню с построчным удалением."""
    console = Console()

    ascii_art = """
 ██████╗ ███████╗███╗   ██╗ ██████╗ ██╗   ██╗██╗███╗   ██╗
 ██╔══██╗██╔════╝████╗  ██║██╔════╝ ██║   ██║██║████╗  ██║
 ██████╔╝█████╗  ██╔██╗ ██║██║  ███╗██║   ██║██║██╔██╗ ██║
 ██╔═══╝ ██╔══╝  ██║╚██╗██║██║   ██║██║   ██║██║██║╚██╗██║
 ██║     ███████╗██║ ╚████║╚██████╔╝╚██████╔╝██║██║ ╚████║
 ╚═╝     ╚══════╝╚═╝  ╚═══╝ ╚═════╝  ╚═════╝ ╚═╝╚═╝  ╚═══╝

 ████████╗ █████╗ ███╗   ███╗███████╗██████╗
 ╚══██╔══╝██╔══██╗████╗ ████║██╔════╝██╔══██╗
    ██║   ███████║██╔████╔██║█████╗  ██████╔╝
    ██║   ██╔══██║██║╚██╔╝██║██╔══╝  ██╔══██╗
    ██║   ██║  ██║██║ ╚═╝ ██║███████╗██║  ██║
    ╚═╝   ╚═╝  ╚═╝╚═╝     ╚═╝╚══════╝╚═╝  ╚═╝
"""

    color = "#e07333"
    lines = ascii_art.splitlines()

    # Плавный построчный вывод (появление)
    for line in lines:
        console.print(line, style=color)
        time.sleep(0.05)  # задержка между строками

    # Пауза перед удалением
    time.sleep(0.5)

    # Дополнительная очистка экрана для полной уверенности
    console.clear()


if __name__ == "__main__":
    # Для тестирования эффекта затухания
    show_intro()
