# flake8: noqa: E501
"""
Help content and documentation texts for the configuration menu.
"""

# Tab help texts - comprehensive documentation for each tab
TAB_HELP = {
    "tab-general": """# ОСНОВНЫЕ НАСТРОЙКИ Penguin Tamer
---
В `Penguin Tamer` предустановлено несколько бесплатных моделей от OpenRouter. Для их использования получите API_KEY в личном кабинете на сайте OpenRouter.
## Получение **API_KEY** от OpenRouter
- В личном кабинете перейдите в раздел "Keys" [https://openrouter.ai/settings/keys](https://openrouter.ai/settings/keys)
- Нажмите "Create Key" и скопируйте созданный `API_KEY`
- В настройках `Penguin Tamer` откройте диалог изменения LLM и вставьте скопированный `API_KEY` в соответствующее поле.
---

`Penguin Tamer` может работать с любой совместимой нейросетью. Для этого нужно указать **Model ID**, **API_URL** и **API_KEY**.

Список совместимых бесплатных моделей на сайте OpenRouter (51 модель) - [https://openrouter.ai/models/?q=free](https://openrouter.ai/models/?q=free)

---

Подключение любой LLM в `Penguin Tamer` состоит из трёх шагов:

# Получение **Model ID**, **API_URL** и **API_KEY** на примере провайдера OpenRouter

Зарегистрируйтесь на **OpenRouter** [openrouter.ai](https://openrouter.ai)

## 1. Поиск **Model ID**
- Перейдите в раздел Models [https://openrouter.ai/models/?q=free](https://openrouter.ai/models/?q=free)
- Выберите любую модель из списка
- В описании модели найдите поле `Model ID`
- Пример: `anthropic/claude-3-sonnet`

## 2. **API_URL**
- Одинаковый URL для всех моделей OpenRouter: `https://openrouter.ai/api/v1`

## 3. Получение **API_KEY**
- В личном кабинете перейдите в раздел "Keys" [https://openrouter.ai/settings/keys](https://openrouter.ai/settings/keys)
- Нажмите "Create Key" и скопируйте созданный `API_KEY`

> 💡 **Совет:** Cохраните полученный `API_KEY` — он не будет доступен в личном кабинете. Это политика безопасности большинства провайдеров LLM""",

    "tab-params": """# ПАРАМЕТРЫ ГЕНЕРАЦИИ

Настройка поведения языковой модели при генерации текста.

---

## Temperature

**Диапазон:** 0.0 - 2.0 | **По умолчанию:** 0.8

Контролирует креативность и случайность ответов:

- **0.0-0.3** — Детерминированные, точные ответы
  *Идеально для:* технических задач, извлечения данных

- **0.4-0.7** — Сбалансированные ответы
  *Идеально для:* общего использования, Q&A

- **0.8-1.5** — Креативные, разнообразные ответы
  *Идеально для:* brainstorming, генерация идей

- **1.6-2.0** — Очень креативные (может быть непредсказуемо)

---

## Max Tokens

**Диапазон:** 1 - ∞ | **По умолчанию:** без ограничений

Ограничивает длину ответа модели:

- **100 токенов** ≈ 75 слов ≈ 1-2 параграфа
- **500 токенов** ≈ 375 слов ≈ 1 страница
- **2000 токенов** ≈ 1500 слов ≈ 3-4 страницы

*Оставьте пустым для неограниченной длины ответа.*

---

## Top P (Nucleus Sampling)

**Диапазон:** 0.0 - 1.0 | **По умолчанию:** 0.95

Альтернативный способ контроля случайности. Модель выбирает из топ-N% наиболее вероятных токенов.

> 💡 **Совет:** Меняйте **либо** `temperature` **либо** `top_p`, но не оба одновременно.

---

## Frequency Penalty

**Диапазон:** -2.0 до 2.0 | **По умолчанию:** 0.0

Уменьшает вероятность повторения одних и тех же токенов:

- **0.3-0.5** — Лёгкое уменьшение повторов *(рекомендуется)*
- **1.0-2.0** — Сильное избегание повторов

---

## Presence Penalty

**Диапазон:** -2.0 до 2.0 | **По умолчанию:** 0.0

Увеличивает вероятность обсуждения новых тем. Наказывает за сам факт упоминания токена
(в отличие от frequency_penalty, который наказывает за частоту).

---

## Seed

**Тип:** целое число или пусто | **По умолчанию:** случайно

Обеспечивает воспроизводимость результатов. Одинаковый seed с теми же параметрами даст идентичный ответ.

*Используйте для:* тестирования, отладки промптов, демонстраций

---

## Рекомендации

Начните с **defaults** и постепенно настраивайте

Меняйте **один параметр за раз** для понимания влияния

Используйте **debug mode** для анализа запросов

---

## Примеры конфигураций

### 🤖 Конфигурация для системного администрирования (по умолчанию)

```yaml
global:
  temperature: 0.8
  max_tokens: null
  top_p: 0.95
  frequency_penalty: 0.0
  presence_penalty: 0.0
  stop: null
  seed: null
```

**Характеристики:** Сбалансированный подход с умеренной креативностью

### 🎯 Точные технические ответы

```yaml
global:
  temperature: 0.2
  max_tokens: 2000
  top_p: 0.9
  frequency_penalty: 0.1
  presence_penalty: 0.0
  stop: null
  seed: null
```

**Применение:** Извлечение информации, техническая документация, команды терминала

### 💡 Креативный brainstorming

```yaml
global:
  temperature: 1.2
  max_tokens: null
  top_p: 0.98
  frequency_penalty: 0.5
  presence_penalty: 0.6
  stop: null
  seed: null
```

**Применение:** Генерация идей, альтернативные решения, нестандартные подходы

### 📝 Краткие ответы

```yaml
global:
  temperature: 0.5
  max_tokens: 500
  top_p: 0.9
  frequency_penalty: 0.2
  presence_penalty: 0.1
  stop: ["\n\n\n"]
  seed: null
```

**Применение:** Быстрые Q&A, короткие объяснения

### 🧪 Тестирование и отладка

```yaml
global:
  temperature: 0.7
  max_tokens: 1000
  top_p: 0.95
  frequency_penalty: 0.0
  presence_penalty: 0.0
  stop: null
  seed: 42  # Фиксированный результат
```

> Подробнее: [LLM_PARAMETERS_GUIDE](https://github.com/Vivatist/penguin-tamer/blob/main/docs/LLM_PARAMETERS_GUIDE.md)""",

    "tab-content": """# ПОЛЬЗОВАТЕЛЬСКИЙ КОНТЕКСТ

Используйте это поле для **системных промптов** и **инструкций**, которые должны
автоматически применяться к каждому вашему запросу к LLM.

Это позволяет:
- Задать роль и стиль общения ассистента
- Определить формат ответов
- Добавить специфический контекст для ваших задач
- Задать язык общения

---

Обратите внимание, что основная информация о вашем рабочем окружении уже есть в распоряжении модели:

- Операционная система
- Архитектура
- Пользователь
- Домашняя папка
- Текущий каталог
- Имя хоста
- Локальный IP-адрес
- Версия Python
- Исполняемый файл Python
- Виртуальное окружение
- Путь к виртуальному окружению
- Системная кодировка
- Кодировка файловой системы
- Системная локаль
- Временная директория
- Количество CPU
- Текущее время
- Shell
---

## Примеры

### Роль ассистента

Ты - опытный программист Python.
Всегда давай подробные объяснения с примерами кода.


### Формат ответов

Отвечай кратко и по делу.
Используй маркированные списки и заголовки.


### Стиль общения

Общайся дружелюбно и неформально,
используй примеры из жизни для объяснения сложных концепций.


### Специализация

Ты специализируешься на веб-разработке
с фокусом на React и TypeScript.

---

## Добавлять результаты выполнения в контекст

Контролирует, добавляются ли результаты выполнения команд в контекст беседы.

- **Включено** (по умолчанию): Выводы и результаты команд отправляются LLM как контекст
- **Выключено**: Записываются только сами команды, но не их результаты

> 💡 **Экономия токенов:** Отключите эту настройку, если команды выдают большие объёмы
> данных (логи, содержимое файлов и т.д.), чтобы снизить потребление токенов и расходы на API.

---

> 💡 **Совет:** Будьте конкретны — чёткие инструкции дают лучшие результаты""",

    "tab-system": """# СИСТЕМНЫЕ НАСТРОЙКИ

Настройки поведения приложения.

> ! **ВНИМАНИЕ:** Сброс настроек приведёт к удалению всех ваших конфигураций включая API_KEY.

## Задержка потока (0.001-0.1 сек)
Пауза между порциями текста при потоковой генерации.
Используется для отладки.


## Частота обновлений (1-60 Гц)
Скорость обновления окна терминала в течение генерации.
Используется для отладки.

---

## Режим отладки

- Информация о запросах к API
- Отображение токенов и времени выполнения
- Детали ошибок и предупреждения

""",

    "tab-appearance": """# НАСТРОЙКИ ИНТЕРФЕЙСА

Внешний вид и визуальное оформление приложения.

---

### Доступные темы

| Тема | Описание |
|------|----------|
| **Классический** | Нейтральная, универсальная |
| **Monokai** | Яркие акценты на тёмном фоне |
| **Dracula** | Мягкие фиолетовые тона |
| **Nord** | Приглушённые синие оттенки |
| **Solarized Dark** | Комфортная тёмная тема для глаз |
| **GitHub Dark** | Знакомая разработчикам тема |
| **Matrix** | Киберпанк в стиле "Матрицы" |
| **Minimal** | Чёрно-белая, без отвлекающих цветов |





""",
}


# Widget help texts - detailed help for specific input fields
WIDGET_HELP = {
    "temp-input": """[bold cyan]ТЕМПЕРАТУРА[/bold cyan]

Контролирует креативность и случайность ответов.

[bold]Диапазон:[/bold] 0.0 - 2.0

[bold]Низкие значения (0.0-0.5):[/bold]
• Более предсказуемые ответы
• Подходит для технических задач
• Факты и точность

[bold]Средние значения (0.6-1.0):[/bold]
• Баланс креативности и точности
• Подходит для большинства задач

[bold]Высокие значения (1.1-2.0):[/bold]
• Очень креативные ответы
• Подходит для творческих задач
• Может быть менее точным""",

    "max-tokens-input": """[bold cyan]МАКСИМУМ ТОКЕНОВ[/bold cyan]

Ограничивает длину генерируемого ответа.

[bold]Значения:[/bold]
• Пусто или 0 = без ограничений
• Число > 0 = максимальное количество токенов

[bold]Примерно:[/bold]
• 100 токенов ≈ 75 слов
• 500 токенов ≈ 375 слов
• 1000 токенов ≈ 750 слов

[bold]Рекомендации:[/bold]
• Короткие ответы: 100-300
• Средние ответы: 500-1000
• Длинные ответы: 1500-3000""",

    "top-p-input": """[bold cyan]TOP P (Nucleus Sampling)[/bold cyan]

Контролирует разнообразие выбора слов.

[bold]Диапазон:[/bold] 0.0 - 1.0

[bold]Как работает:[/bold]
Модель выбирает из топ N% наиболее вероятных токенов.

[bold]Низкие значения (0.1-0.5):[/bold]
• Более консервативный выбор
• Предсказуемые ответы

[bold]Средние значения (0.6-0.9):[/bold]
• Баланс разнообразия
• Рекомендуется для большинства задач

[bold]Высокие значения (0.95-1.0):[/bold]
• Максимальное разнообразие
• Более неожиданные ответы""",

    "freq-penalty-input": """[bold cyan]ШТРАФ ЧАСТОТЫ[/bold cyan]

Снижает повторение одних и тех же слов.

[bold]Диапазон:[/bold] -2.0 до 2.0

[bold]Отрицательные значения:[/bold]
• Поощряет повторения
• Редко используется

[bold]Нулевое значение (0.0):[/bold]
• Без штрафов
• По умолчанию

[bold]Положительные значения:[/bold]
• 0.1-0.5: легкое снижение повторов
• 0.6-1.0: заметное снижение
• 1.1-2.0: сильное снижение (может быть неестественным)""",

    "pres-penalty-input": """[bold cyan]ШТРАФ ПРИСУТСТВИЯ[/bold cyan]

Поощряет обсуждение новых тем.

[bold]Диапазон:[/bold] -2.0 до 2.0

[bold]Отрицательные значения:[/bold]
• Фокус на текущей теме
• Глубокое обсуждение

[bold]Нулевое значение (0.0):[/bold]
• Естественное поведение
• По умолчанию

[bold]Положительные значения:[/bold]
• 0.1-0.5: легкое разнообразие тем
• 0.6-1.0: заметное разнообразие
• 1.1-2.0: максимальное разнообразие (может терять фокус)""",

    "seed-input": """[bold cyan]SEED (Зерно генерации)[/bold cyan]

Обеспечивает воспроизводимость результатов.

[bold]Значения:[/bold]
• Пусто или 0 = случайная генерация
• Любое число = фиксированный seed

[bold]Применение:[/bold]
• Тестирование: один и тот же seed даст одинаковые результаты
• Отладка: воспроизведение проблем
• Эксперименты: сравнение разных параметров

[bold]Примечание:[/bold]
Одинаковый seed с одинаковыми параметрами даст идентичный ответ.""",

    "stream-delay-input": """[bold cyan]ЗАДЕРЖКА СТРИМА[/bold cyan]

Пауза между порциями текста при потоковой генерации.

[bold]Диапазон:[/bold] 0.001 - 0.1 секунд

[bold]Малые значения (0.001-0.01):[/bold]
• Быстрое отображение
• Может мерцать

[bold]Средние значения (0.02-0.05):[/bold]
• Комфортная скорость
• Рекомендуется

[bold]Большие значения (0.06-0.1):[/bold]
• Медленное отображение
• Легче читать в реальном времени""",

    "refresh-rate-input": """[bold cyan]ЧАСТОТА ОБНОВЛЕНИЙ[/bold cyan]

Скорость обновления интерфейса.

[bold]Диапазон:[/bold] 1-60 Гц (обновлений в секунду)

[bold]Низкие значения (1-10):[/bold]
• Меньше нагрузка на систему
• Может быть менее плавным

[bold]Средние значения (10-30):[/bold]
• Оптимальный баланс
• Рекомендуется (10 по умолчанию)

[bold]Высокие значения (30-60):[/bold]
• Очень плавный интерфейс
• Больше нагрузка на CPU""",

    "debug-switch": """[bold cyan]РЕЖИМ ОТЛАДКИ[/bold cyan]

Включает подробное логирование.

[bold]Выключен (OFF):[/bold]
• Обычный режим работы
• Только важные сообщения
• Рекомендуется для повседневного использования

[bold]Включен (ON):[/bold]
• Подробная информация о запросах
• Логирование параметров
• Отображение токенов и времени выполнения
• Полезно для диагностики проблем

[bold]Применение:[/bold]
• Разработка и тестирование
• Поиск проблем с API
• Анализ производительности""",

    "language-select": """[bold cyan]ЯЗЫК ИНТЕРФЕЙСА[/bold cyan]

Выбор языка меню и сообщений.

[bold]Доступные языки:[/bold]
• English (en)
• Русский (ru)

[bold]Что изменится:[/bold]
• Язык меню
• Системные сообщения
• Подсказки и описания

[bold]Примечание:[/bold]
Язык общения с LLM зависит от вашего промпта, а не от этой настройки.""",

    "theme-select": """[bold cyan]ТЕМА ОФОРМЛЕНИЯ ДИАЛОГОВ НЕЙРОСЕТИ[/bold cyan]

Выбор темы для отображения диалогов с нейросетью.

[bold]Доступные темы:[/bold]
• Классический (default) - стандартная тема
• Monokai - тёмная с контрастными акцентами
• Dracula - популярная тёмная тема с фиолетовыми тонами
• Nord - холодные северные тона
• Solarized Dark - научно подобранная палитра, комфортная для глаз
• GitHub Dark - знакомая разработчикам тема в стиле GitHub
• Matrix - зелёный монохром в стиле киберпанка
• Minimal - минималистичная чёрно-белая тема

[bold]Выбор темы влияет на:[/bold]
• Цвета интерфейса
• Контрастность текста
• Общее восприятие

[bold]Рекомендация:[/bold]
Выберите тему, которая комфортна для ваших глаз.""",
}
