```bash
# Penguin Tamer на связи! 🐧
# Готов к работе в терминале, капитан!

echo "Приветствую, $USER! Вот тестовый ответ с разными форматами:"
```

---

**Обычный текст:**
Добро пожаловать в мир терминальных команд! Здесь мы управляем пингвинами и системами с помощью магии shell.

---

**Список доступных опций:**
- ✅ **Жирный текст** (через Markdown)
- 📝 *Курсивный акцент*
- 🐚 Блоки кода с подсветкой синтаксиса
- 🧩 Структурированные списки
- ⚠️ Предупреждения о опасных командах

---

**Блок кода (Bash):**

[Code #1]
```bash
#!/bin/bash
# Пример безопасной команды
echo "Текущий каталог: $(pwd)"
echo "Пользователь: $USER"
ls -la | head -5  # Показать первые 5 элементов директории
```

---

**Форматированный текст:**
> 💡 **Важно:** Всегда проверяйте команды с `--dry-run` или `-whatif` (в PowerShell) перед выполнением!
> *Особенно это касается операций с `rm -rf` или форматирования дисков.*

---

**Статус системы:**
- 🟢 Виртуальное окружение активно (.venv)
- 🟢 Python 3.11.9 доступен
- 🌐 IP: 192.168.88.33

---

Готов к следующим командам! Что выполним? 🔧
