# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OutputsTcpGroupArgs', 'OutputsTcpGroup']

@pulumi.input_type
class OutputsTcpGroupArgs:
    def __init__(__self__, *,
                 servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 acl: Optional[pulumi.Input['OutputsTcpGroupAclArgs']] = None,
                 compressed: Optional[pulumi.Input[bool]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
                 heartbeat_frequency: Optional[pulumi.Input[int]] = None,
                 max_queue_size: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 send_cooked_data: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OutputsTcpGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Comma-separated list of servers to include in the group.
        :param pulumi.Input['OutputsTcpGroupAclArgs'] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] compressed: If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        :param pulumi.Input[bool] disabled: If true, disables the group.
        :param pulumi.Input[int] drop_events_on_queue_full: If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
               <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
               Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
               Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        :param pulumi.Input[int] heartbeat_frequency: How often (in seconds) to send a heartbeat packet to the receiving server.
               Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        :param pulumi.Input[str] max_queue_size: Specify an integer or integer[KB|MB|GB].
               <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
               Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
               For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
               If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
               If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        :param pulumi.Input[str] method: Valid values: (tcpout | syslog). Specifies the type of output processor.
        :param pulumi.Input[str] name: The name of the group of receivers.
        :param pulumi.Input[bool] send_cooked_data: If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
               Set to false if you are sending to a third-party system.
        :param pulumi.Input[str] token: Token value generated by the indexer after configuration.
        """
        pulumi.set(__self__, "servers", servers)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compressed is not None:
            pulumi.set(__self__, "compressed", compressed)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if drop_events_on_queue_full is not None:
            pulumi.set(__self__, "drop_events_on_queue_full", drop_events_on_queue_full)
        if heartbeat_frequency is not None:
            pulumi.set(__self__, "heartbeat_frequency", heartbeat_frequency)
        if max_queue_size is not None:
            pulumi.set(__self__, "max_queue_size", max_queue_size)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if send_cooked_data is not None:
            pulumi.set(__self__, "send_cooked_data", send_cooked_data)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Comma-separated list of servers to include in the group.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['OutputsTcpGroupAclArgs']]:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['OutputsTcpGroupAclArgs']]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def compressed(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        """
        return pulumi.get(self, "compressed")

    @compressed.setter
    def compressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compressed", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, disables the group.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="dropEventsOnQueueFull")
    def drop_events_on_queue_full(self) -> Optional[pulumi.Input[int]]:
        """
        If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
        <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
        Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
        Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        """
        return pulumi.get(self, "drop_events_on_queue_full")

    @drop_events_on_queue_full.setter
    def drop_events_on_queue_full(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "drop_events_on_queue_full", value)

    @property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to send a heartbeat packet to the receiving server.
        Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        """
        return pulumi.get(self, "heartbeat_frequency")

    @heartbeat_frequency.setter
    def heartbeat_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "heartbeat_frequency", value)

    @property
    @pulumi.getter(name="maxQueueSize")
    def max_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Specify an integer or integer[KB|MB|GB].
        <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
        Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
        For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
        If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
        If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        """
        return pulumi.get(self, "max_queue_size")

    @max_queue_size.setter
    def max_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_queue_size", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values: (tcpout | syslog). Specifies the type of output processor.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group of receivers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sendCookedData")
    def send_cooked_data(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
        Set to false if you are sending to a third-party system.
        """
        return pulumi.get(self, "send_cooked_data")

    @send_cooked_data.setter
    def send_cooked_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_cooked_data", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Token value generated by the indexer after configuration.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class _OutputsTcpGroupState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['OutputsTcpGroupAclArgs']] = None,
                 compressed: Optional[pulumi.Input[bool]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
                 heartbeat_frequency: Optional[pulumi.Input[int]] = None,
                 max_queue_size: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 send_cooked_data: Optional[pulumi.Input[bool]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OutputsTcpGroup resources.
        :param pulumi.Input['OutputsTcpGroupAclArgs'] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] compressed: If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        :param pulumi.Input[bool] disabled: If true, disables the group.
        :param pulumi.Input[int] drop_events_on_queue_full: If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
               <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
               Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
               Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        :param pulumi.Input[int] heartbeat_frequency: How often (in seconds) to send a heartbeat packet to the receiving server.
               Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        :param pulumi.Input[str] max_queue_size: Specify an integer or integer[KB|MB|GB].
               <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
               Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
               For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
               If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
               If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        :param pulumi.Input[str] method: Valid values: (tcpout | syslog). Specifies the type of output processor.
        :param pulumi.Input[str] name: The name of the group of receivers.
        :param pulumi.Input[bool] send_cooked_data: If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
               Set to false if you are sending to a third-party system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Comma-separated list of servers to include in the group.
        :param pulumi.Input[str] token: Token value generated by the indexer after configuration.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compressed is not None:
            pulumi.set(__self__, "compressed", compressed)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if drop_events_on_queue_full is not None:
            pulumi.set(__self__, "drop_events_on_queue_full", drop_events_on_queue_full)
        if heartbeat_frequency is not None:
            pulumi.set(__self__, "heartbeat_frequency", heartbeat_frequency)
        if max_queue_size is not None:
            pulumi.set(__self__, "max_queue_size", max_queue_size)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if send_cooked_data is not None:
            pulumi.set(__self__, "send_cooked_data", send_cooked_data)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['OutputsTcpGroupAclArgs']]:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['OutputsTcpGroupAclArgs']]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def compressed(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        """
        return pulumi.get(self, "compressed")

    @compressed.setter
    def compressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compressed", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, disables the group.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="dropEventsOnQueueFull")
    def drop_events_on_queue_full(self) -> Optional[pulumi.Input[int]]:
        """
        If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
        <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
        Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
        Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        """
        return pulumi.get(self, "drop_events_on_queue_full")

    @drop_events_on_queue_full.setter
    def drop_events_on_queue_full(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "drop_events_on_queue_full", value)

    @property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to send a heartbeat packet to the receiving server.
        Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        """
        return pulumi.get(self, "heartbeat_frequency")

    @heartbeat_frequency.setter
    def heartbeat_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "heartbeat_frequency", value)

    @property
    @pulumi.getter(name="maxQueueSize")
    def max_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Specify an integer or integer[KB|MB|GB].
        <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
        Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
        For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
        If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
        If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        """
        return pulumi.get(self, "max_queue_size")

    @max_queue_size.setter
    def max_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_queue_size", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values: (tcpout | syslog). Specifies the type of output processor.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group of receivers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sendCookedData")
    def send_cooked_data(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
        Set to false if you are sending to a third-party system.
        """
        return pulumi.get(self, "send_cooked_data")

    @send_cooked_data.setter
    def send_cooked_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_cooked_data", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Comma-separated list of servers to include in the group.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Token value generated by the indexer after configuration.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class OutputsTcpGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpGroupAclArgs']]] = None,
                 compressed: Optional[pulumi.Input[bool]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
                 heartbeat_frequency: Optional[pulumi.Input[int]] = None,
                 max_queue_size: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 send_cooked_data: Optional[pulumi.Input[bool]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: OutputsTcpGroup

        Access to the configuration of a group of one or more data forwarding destinations.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_group = splunk.OutputsTcpGroup("tcpGroup",
            disabled=False,
            drop_events_on_queue_full=60,
            max_queue_size="100KB",
            send_cooked_data=True,
            servers=[
                "1.1.1.1:1234",
                "2.2.2.2:1234",
            ])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['OutputsTcpGroupAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] compressed: If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        :param pulumi.Input[bool] disabled: If true, disables the group.
        :param pulumi.Input[int] drop_events_on_queue_full: If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
               <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
               Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
               Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        :param pulumi.Input[int] heartbeat_frequency: How often (in seconds) to send a heartbeat packet to the receiving server.
               Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        :param pulumi.Input[str] max_queue_size: Specify an integer or integer[KB|MB|GB].
               <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
               Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
               For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
               If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
               If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        :param pulumi.Input[str] method: Valid values: (tcpout | syslog). Specifies the type of output processor.
        :param pulumi.Input[str] name: The name of the group of receivers.
        :param pulumi.Input[bool] send_cooked_data: If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
               Set to false if you are sending to a third-party system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Comma-separated list of servers to include in the group.
        :param pulumi.Input[str] token: Token value generated by the indexer after configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutputsTcpGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: OutputsTcpGroup

        Access to the configuration of a group of one or more data forwarding destinations.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_group = splunk.OutputsTcpGroup("tcpGroup",
            disabled=False,
            drop_events_on_queue_full=60,
            max_queue_size="100KB",
            send_cooked_data=True,
            servers=[
                "1.1.1.1:1234",
                "2.2.2.2:1234",
            ])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param OutputsTcpGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutputsTcpGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpGroupAclArgs']]] = None,
                 compressed: Optional[pulumi.Input[bool]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
                 heartbeat_frequency: Optional[pulumi.Input[int]] = None,
                 max_queue_size: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 send_cooked_data: Optional[pulumi.Input[bool]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutputsTcpGroupArgs.__new__(OutputsTcpGroupArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["compressed"] = compressed
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["drop_events_on_queue_full"] = drop_events_on_queue_full
            __props__.__dict__["heartbeat_frequency"] = heartbeat_frequency
            __props__.__dict__["max_queue_size"] = max_queue_size
            __props__.__dict__["method"] = method
            __props__.__dict__["name"] = name
            __props__.__dict__["send_cooked_data"] = send_cooked_data
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
            __props__.__dict__["token"] = token
        super(OutputsTcpGroup, __self__).__init__(
            'splunk:index/outputsTcpGroup:OutputsTcpGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpGroupAclArgs']]] = None,
            compressed: Optional[pulumi.Input[bool]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
            heartbeat_frequency: Optional[pulumi.Input[int]] = None,
            max_queue_size: Optional[pulumi.Input[str]] = None,
            method: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            send_cooked_data: Optional[pulumi.Input[bool]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token: Optional[pulumi.Input[str]] = None) -> 'OutputsTcpGroup':
        """
        Get an existing OutputsTcpGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['OutputsTcpGroupAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] compressed: If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        :param pulumi.Input[bool] disabled: If true, disables the group.
        :param pulumi.Input[int] drop_events_on_queue_full: If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
               <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
               Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
               Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        :param pulumi.Input[int] heartbeat_frequency: How often (in seconds) to send a heartbeat packet to the receiving server.
               Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        :param pulumi.Input[str] max_queue_size: Specify an integer or integer[KB|MB|GB].
               <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
               Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
               For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
               If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
               If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        :param pulumi.Input[str] method: Valid values: (tcpout | syslog). Specifies the type of output processor.
        :param pulumi.Input[str] name: The name of the group of receivers.
        :param pulumi.Input[bool] send_cooked_data: If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
               Set to false if you are sending to a third-party system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] servers: Comma-separated list of servers to include in the group.
        :param pulumi.Input[str] token: Token value generated by the indexer after configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutputsTcpGroupState.__new__(_OutputsTcpGroupState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["compressed"] = compressed
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["drop_events_on_queue_full"] = drop_events_on_queue_full
        __props__.__dict__["heartbeat_frequency"] = heartbeat_frequency
        __props__.__dict__["max_queue_size"] = max_queue_size
        __props__.__dict__["method"] = method
        __props__.__dict__["name"] = name
        __props__.__dict__["send_cooked_data"] = send_cooked_data
        __props__.__dict__["servers"] = servers
        __props__.__dict__["token"] = token
        return OutputsTcpGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.OutputsTcpGroupAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def compressed(self) -> pulumi.Output[bool]:
        """
        If true, forwarder sends compressed data. If set to true, the receiver port must also have compression turned on.
        """
        return pulumi.get(self, "compressed")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        If true, disables the group.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="dropEventsOnQueueFull")
    def drop_events_on_queue_full(self) -> pulumi.Output[int]:
        """
        If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
        <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
        Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
        Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        """
        return pulumi.get(self, "drop_events_on_queue_full")

    @property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> pulumi.Output[int]:
        """
        How often (in seconds) to send a heartbeat packet to the receiving server.
        Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        """
        return pulumi.get(self, "heartbeat_frequency")

    @property
    @pulumi.getter(name="maxQueueSize")
    def max_queue_size(self) -> pulumi.Output[str]:
        """
        Specify an integer or integer[KB|MB|GB].
        <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
        Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
        For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
        If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
        If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        """
        return pulumi.get(self, "max_queue_size")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[str]:
        """
        Valid values: (tcpout | syslog). Specifies the type of output processor.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the group of receivers.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sendCookedData")
    def send_cooked_data(self) -> pulumi.Output[bool]:
        """
        If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
        Set to false if you are sending to a third-party system.
        """
        return pulumi.get(self, "send_cooked_data")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence[str]]:
        """
        Comma-separated list of servers to include in the group.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Token value generated by the indexer after configuration.
        """
        return pulumi.get(self, "token")

