# Working with PyDala Datasets using fsspec-utils

This example demonstrates how to work with PyDala datasets using fsspec-utils and StorageOptions.

## Overview

The example shows:
1. Using StorageOptions with PyDala datasets
2. Creating and writing data to Delta tables
3. Reading data back from Delta tables
4. Performing update and append operations on Delta tables

## Prerequisites

- Python 3.8+
- fsspec-utils installed
- deltalake installed
- pyarrow installed
- polars installed

## Running the Example

Run the example script:

```bash
python pydala_dataset_example.py
```

Or run the Jupyter notebook:

```bash
jupyter notebook pydala_dataset_example.ipynb
```

Or run the Marimo notebook:

```bash
marimo run pydala_dataset_example_mamo.py
```

## Files in This Example

- `pydala_dataset_example.py`: Python script demonstrating the functionality
- `pydala_dataset_example.ipynb`: Jupyter notebook version of the example
- `pydala_dataset_example_mamo.py`: Marimo notebook version of the example
- `README.md`: This file