---
sidebar_position: 1
---

# Welcome to mem8

**AI Memory Management for Team Collaboration**

mem8 is a CLI tool designed to enhance your Claude Code development workflow with structured memory management, customizable templates, and team collaboration features.

## What is mem8?

mem8 helps you:
- 📝 **Organize thoughts** - Structure research, plans, and decisions in markdown
- 🤖 **Customize Claude Code** - Manage agents, commands, and workflows
- 🎨 **Use templates** - Start projects with standardized configurations
- 🌐 **Share knowledge** - Collaborate with teams through shared thoughts
- 🔍 **Search everything** - Find information across all your docs

## Quick Example

```bash
# Install mem8
uv tool install mem8

# Initialize with official templates
mem8 init --template-source killerapp/mem8-templates

# Or use your team's custom templates
mem8 init --template-source yourorg/team-templates

# Search your thoughts
mem8 search "authentication"

# Check workspace status
mem8 status
```

## Next Steps

<div class="row">
  <div class="col col--6">
    <h3>📥 Installation</h3>
    <p>Get mem8 installed and running on your system.</p>
    <a href="./installation">Install mem8 →</a>
  </div>
  <div class="col col--6">
    <h3>💡 Concepts</h3>
    <p>Understand mem8's core concepts and architecture.</p>
    <a href="./concepts">Learn concepts →</a>
  </div>
</div>

<div class="row">
  <div class="col col--6">
    <h3>📖 User Guide</h3>
    <p>Learn how to use mem8 in your daily workflow.</p>
    <a href="./user-guide/getting-started">Read the guide →</a>
  </div>
  <div class="col col--6">
    <h3>🌐 External Templates</h3>
    <p>Use and create custom templates from any source.</p>
    <a href="./external-templates">Explore templates →</a>
  </div>
</div>

## Features at a Glance

### 💻 CLI-First Design
Powerful command-line interface for all operations. Optional web dashboard for visualization.

### 📁 Structured Thoughts
Organize research, plans, PRs, and decisions in a searchable markdown repository.

### 🎯 Claude Code Integration
Deep integration with Claude Code's agents, commands, and custom workflows.

### 🌐 External Templates
Use templates from GitHub, local paths, or create your own. Fork and customize as needed.

### 👥 Team Collaboration
Share thoughts repositories across teams with git-based sync.

### 🔍 Full-Text Search
Find information quickly across all your thoughts and documentation.

## Who is mem8 for?

- **Solo Developers** - Organize your research and decisions
- **Development Teams** - Share knowledge and standardize workflows
- **Claude Code Users** - Enhance your AI-assisted development
- **Organizations** - Create custom templates and workflows

## Get Support

- 📖 [Documentation](https://github.com/killerapp/mem8)
- 🐛 [Report Issues](https://github.com/killerapp/mem8/issues)
- 💬 [Discussions](https://github.com/killerapp/mem8/discussions)
- 🔧 [Template Repository](https://github.com/killerapp/mem8-templates)
