# Why Janito Uses a Built-in Agentic Framework for Code

## Overview

Janito is designed with a built-in agentic framework tailored specifically for code generation, analysis, and editing. This approach is fundamentally different from most general-purpose agentic frameworks, which are typically optimized for structured data extraction and workflow automation.

## General-purpose Agentic Frameworks

- **Primary Focus:**
  - Extracting structured data from unstructured text (e.g., forms, tables, summaries).
  - Automating business processes, information retrieval, or conversational flows.
- **Strengths:**
  - Well-suited for tasks where the output is a set of fields, entities, or facts.
  - Often rely on templates, schemas, or predefined extraction rules.
- **Limitations for Code:**
  - Lack deep understanding of code semantics, dependencies, and context.
  - Not designed for precise, context-aware code editing or refactoring.
  - Struggle with the fragility and interconnectedness of code (see [Challenges of Code Generation and Editing for LLMs](code-generation-challenges.md)).

## Janito’s Built-in Agentic Framework

- **Primary Focus:**
  - Code search, analysis, editing, and refactoring.
  - Maintaining traceability and explicit error handling.
  - Supporting developer workflows and codebase evolution.
- **Key Features:**
  - Step-by-step code search and inference, with user-visible progress (see [Code Generation Observability](code-generation-observability.md)).
  - Validation and testing of code changes.
  - Awareness of code structure, dependencies, and side effects.
  - Designed for iterative, collaborative development.

## Why This Matters

- **Reliability:** Code changes require precision and context-awareness—mistakes can break systems.
- **Traceability:** Developers need to understand and audit every change, not just the final output.
- **Developer Experience:** Janito’s workflow is optimized for real-world coding, not just data extraction.

## Conclusion

Janito’s tailored agentic framework is purpose-built for the unique challenges of code generation and editing. It provides the transparency, precision, and control that developers need—going far beyond what general-purpose agentic frameworks can offer for code-centric tasks.

---
_generated by janito.dev_
