# CTO, CDO, CIO
brand_cto_sample = """ 
#Message for Brand CTO/CIO/CDO/Head of IT

Subject: Let’s Connect at Shoptalk 2025 – Solving Supply Chain Challenges 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the innovative work you’re leading at <Client>. Your journey from [X Company] to [Y Company] and now driving technology at <Client> is truly inspiring. 

I understand that <Client> has faced supply chain challenges, particularly during high-demand periods. At OnePint.ai, we specialize in solving these issues with our AI-driven inventory management platform—helping brands reduce stockouts, optimize inventory, and improve operational efficiency. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can support <Client>’s supply chain goals. Our platform delivers: 

✅ One Truth – A unified source of real-time inventory and availability data. 
✅ Control Center – Autonomous AI agents for smart, real-time decision-making. 
✅ Pint Planning – Advanced tools for forecasting, allocation, and replenishment. 

Our customers have achieved up to 85% stockout reduction and a 15% sales lift. As a special Shoptalk offer, we’re providing: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 

"""

brand_meeting_response = """ 
#Response for Brand CTO/CIO/CDO/Head of IT

Sounds good. What time and date works best for a [Platform] meeting?

Looking forward to chatting with you.

"""

brand_meeting_second_response = """ 
#Response for Brand CTO/CIO/CDO/Head of IT

Perfect. Will see you then.

"""

brand_shoptalk_response = """ 
#Response for Brand CTO/CIO/CDO/Head of IT

Wonderful, looking forward to chatting with you there.

"""

brand_none_response = """ 
#Response for Brand CTO/CIO/CDO/Head of IT

No worries. If you change your mind, we are always there for you to connect.

"""

brand_cfo_sample = """ 
#Message for Brand CFO (Highlight cost savings and cash flow, ROI) 
Subject: Reducing Inventory Costs & Optimizing Cash Flow – Let’s Connect at Shoptalk 2025 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the financial leadership you’re driving at <Client>. Your journey from [X Company] to [Y Company] and now overseeing finance at <Client> is truly inspiring. 

I understand that managing inventory costs, cash flow, and supply chain disruptions can be complex—especially during periods of high demand and external shocks. At OnePint.ai, we specialize in AI-driven inventory optimization, helping brands reduce working capital requirements while ensuring product availability and customer satisfaction. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can help <Client> achieve financial efficiency through smarter inventory decisions. Our platform delivers: 

✅ Lower Inventory Costs – Reduce excess stock while preventing stockouts. 
✅ Higher Revenue & Margins – Up to 15% sales uplift and optimized fulfillment. 
✅ Improved Cash Flow – Free up working capital tied in inventory. 

Our customers have seen up to an 85% reduction in stockouts and significant cost savings. As a special Shoptalk offer, we’re providing: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 

"""

# chief supply chain officer
brand_csco_sample = """
#Brand (CSCO, Head of supply chain – highlight resilience, efficiency, and service levels and operational impact) 

Subject: Solving Supply Chain Challenges – Let’s Connect at Shoptalk 2025 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the leadership you’re bringing to <Client> supply chain operations. Managing fulfillment, inventory, and supplier networks in today’s dynamic environment is no small feat, and I’d love to discuss how we can help. 

At OnePint.ai, we specialize in AI-driven inventory and supply chain optimization, ensuring brands such as <Client> can reduce disruptions, lower costs, and improve service levels—even in volatile conditions. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can support <Client> supply chain strategy. Our platform delivers: 

✅ Stronger Supply Chain Resilience – Reduce stockouts by up to 85% while minimizing excess inventory. 
✅ Smarter Demand & Supply Alignment – AI-driven forecasting, allocation, and replenishment. 
✅ Cost Efficiency & Faster Fulfillment – Optimize working capital and streamline inventory across locations. 

Many of our customers have cut supply chain costs while increasing availability and fulfillment speed. As a special Shoptalk offer, we’re providing: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts!

"""


retailer_csco_example = """
#Retailer(CSCO, Head of supply chain – highlight resilience, efficiency, and service levels and operational impact) 
Subject: Optimizing Inventory & Supply Chain Resilience – Let’s Connect at Shoptalk 2025 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the leadership you’re bringing to <Client>’s supply chain operations. Managing inventory, supplier disruptions, and demand fluctuations in today’s dynamic retail environment is no small feat, and I’d love to discuss how we can help. 

At OnePint.ai, we specialize in AI-driven inventory and supply chain optimization, ensuring retailers like <Client> can reduce stockouts, optimize inventory levels, and improve fulfillment efficiency—even during volatile demand cycles. 

As we prepare for Shoptalk 2025, I’d love to connect and explore how we can support <Client>’s supply chain strategy. Our platform delivers: 

✅ Higher Availability & Fewer Stockouts – Reduce lost sales while minimizing excess inventory. 
✅ Smarter Demand & Supply Planning – AI-powered forecasting, allocation, and replenishment. 
✅ Optimized Inventory & Cash Flow – Improve margins by balancing inventory investment and working capital. 

Our retail customers have seen up to an 85% reduction in stockouts and a 15% increase in sales through better demand-supply alignment and real-time inventory insights. As a Shoptalk exclusive, we’re offering: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 
"""


grocer_csco_example = """
#Grocer(CSCO, Head of supply chain – highlight resilience, efficiency, and service levels and operational impact) 

Subject: Optimizing Freshness & Reducing Waste – Let’s Connect at Shoptalk 2025 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the leadership you’re bringing to <Client>’s supply chain operations. Managing inventory, supplier relationships, and demand variability in the grocery sector is no small feat, and I’d love to discuss how we can help. 

At OnePint.ai, we specialize in AI-driven inventory and supply chain optimization, ensuring grocers like <Client> can reduce shrink, improve availability, and optimize costs—even in unpredictable market conditions. 

As we prepare for Shoptalk 2025, I’d love to connect and explore how we can support <Client>’s supply chain strategy. Our platform delivers: 

✅ Fresher Products & Lower Shrink – Reduce overstocking and spoilage while ensuring availability. 
✅ Smarter Demand & Supply Alignment – AI-driven forecasting, supplier coordination, and replenishment. 
✅ Optimized Inventory & Cash Flow – Minimize excess stock while improving service levels. 

Our grocery customers have seen up to a 30% reduction in shrink and a 10% increase in sales through better demand planning and real-time supply chain insights. As a Shoptalk exclusive, we’re offering: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 
"""


grocer_cfo_example = """
#Message for Grocer CFO (Highlight cost savings and cash flow, ROI) 
Subject: Reducing Inventory Costs & Optimizing Margins – Let’s Connect at Shoptalk 2025 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the financial leadership you’re driving at <Client>. Your journey from [X Company] to [Y Company] and now overseeing finance at <Client> is truly inspiring. 

I understand that managing inventory costs, cash flow, and shrink while ensuring product availability is a delicate balance—especially in grocery, where freshness and margins are critical. At OnePint.ai, we specialize in AI-driven inventory optimization, helping grocers like <Client> free up working capital, reduce waste, and enhance profitability. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can help <Client> achieve financial efficiency through smarter inventory decisions. Our platform delivers: 

✅ Lower Inventory Costs & Shrink – Reduce excess stock and spoilage while ensuring availability. 
✅ Higher Revenue & Margins – Prevent stockouts and optimize fulfillment to drive up to a 15% sales uplift. 
✅ Improved Cash Flow – Free up working capital by optimizing inventory across locations. 

Our grocery customers have seen up to a 30% reduction in shrink and significant cost savings through better demand planning and real-time supply chain insights. As a Shoptalk exclusive, we’re offering: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 

"""

grocer_cfo_example_two = """
#Message for Grocer CFO (Highlight cost savings and cash flow, ROI) 
Subject: Optimizing Inventory Costs & Cash Flow – Let’s Connect at Shoptalk 2025 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the financial leadership you’re driving at <Client>. Your journey from [X Company] to [Y Company] and now overseeing finance at <Client> is truly inspiring. 

I understand that balancing inventory investment, cash flow, and profitability while ensuring product availability is a critical challenge—especially in today’s dynamic retail environment. At OnePint.ai, we specialize in AI-driven inventory optimization, helping retailers like <Client> reduce working capital requirements, minimize stockouts, and improve margins. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can help <Client> achieve greater financial efficiency through smarter inventory decisions. Our platform delivers: 

✅ Lower Inventory Costs – Reduce excess stock while preventing lost sales. 
✅ Higher Revenue & Margins – AI-driven demand forecasting and fulfillment optimization drive up to a 15% sales uplift. 
✅ Improved Cash Flow – Free up working capital tied up in inventory. 

Our retail customers have seen up to an 85% reduction in stockouts and significant cost savings through better demand planning and real-time inventory insights. As a Shoptalk exclusive, we’re offering: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 

"""

grocer_cto_example = """
#Message for Grocer CTO/CIO/CDO/Head of IT
Subject: Let’s Connect at Shoptalk 2025 – Solving Supply Chain Challenges with AI 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the innovative technology initiatives you’re leading at <Client>. Your journey from [X Company] to [Y Company] and now driving technology at <Client> is truly inspiring. 

I understand that <Client> has faced significant supply chain challenges, especially during high-demand periods and disruptions like COVID-19. At OnePint.ai, we specialize in addressing these issues with our AI-driven inventory management platform, enabling brands to reduce stockouts, optimize inventory, and enhance operational efficiency through smarter technology solutions. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can support <Client>’s supply chain technology strategy. Our platform delivers: 

✅ One Truth – A unified source of real-time inventory and availability data, ensuring transparency and accuracy. 
✅ Control Center – Autonomous AI agents that make smart, real-time decisions, enhancing speed and accuracy across the supply chain. 
✅ Pint Planning – Advanced tools for forecasting, allocation, and replenishment, empowering teams to plan with precision. 

Our customers have achieved up to 85% stockout reduction and 15% sales lift through better demand-supply alignment and smarter inventory management. As a Shoptalk exclusive, we’re offering: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 
"""

retail_cto_example = """
#Message for Retail CTO/CIO/CDO/Head of IT 
Subject: Let’s Connect at Shoptalk 2025 – Solving Retail Supply Chain Challenges with AI 

Hi [XYZ], 

I hope you're doing well. I recently came across your impressive background and the innovative technology initiatives you’re leading at <Client>. Your journey from [X Company] to [Y Company] and now overseeing technology at <Client> is truly inspiring. 

I understand that <Client> has faced supply chain challenges, especially with the complexities of retail demand fluctuations and disruptions. At OnePint.ai, we specialize in addressing these challenges with our AI-driven inventory management platform, helping retailers reduce stockouts, optimize inventory levels, and enhance operational efficiency with data-powered insights. 

As we gear up for Shoptalk 2025, I’d love to connect and explore how we can support <Client>’s technology strategy. Our platform delivers: 

✅ One Truth – A unified source of real-time inventory and availability data, ensuring data accuracy and transparency across all channels. 
✅ Control Center – Autonomous AI agents that make smart, real-time decisions, optimizing supply chain operations at scale. 
✅ Pint Planning – Advanced tools for forecasting, allocation, and replenishment, streamlining planning and execution for better demand alignment. 

Our customers have achieved up to 85% stockout reduction and 15% sales uplift through smarter, technology-driven inventory management. As a Shoptalk exclusive, we’re offering: 
🔹 1-month free trial of all products. 
🔹 3-month paid POC at minimal fees, refundable upon conversion. 

If you and your team are attending ShopTalk, would you be available for a quick 30‑minute chat at booth #949? Alternatively, we can arrange a virtual meeting via Zoom or Teams at your convenience.Looking forward to your thoughts! 
Looking forward to your thoughts! 
"""

dallas_sample_first_email = """
Hi {{ contact.firstname }}, 
I’m Devadas Pattathil, CEO of OnePint.ai. We’re reimagining inventory management with AI—helping retailers boost forecast accuracy by 30–50%, reduce out-of-stocks by up to 85%, and cut supply chain costs by 20–30%. 
 
We’ve built our solutions in collaboration with leading brands like BJ’s, Signet Jewelers, HBC, and Sainsbury’s. I’ve attached our brochure for a quick overview. 
 
I’ll be in Dallas on May 5th and 6th with our Chief Business Officer, Anshuman Jaiswal, and we’d love to meet and explore how OnePint.ai can support your inventory planning and execution goals. 
Would you be available to connect on either of those days? We’re happy to work around your schedule. 
 
Looking forward to the opportunity to chat. 
"""
dallas_sample_second_email = """
I hope you’re doing well.
 
I wanted to take a moment to introduce myself—I'm the CEO of OnePint.ai. I bring over 25 years of experience in supply chain technology, including 8+ years leading product, engineering, and data science teams at Walmart’s supply chain organization.
 
I’ll be in Dallas on May 5th and 6th and would love to connect if you're available during that time. At OnePint.ai, we’re reimagining inventory management using AI—helping retailers improve forecast accuracy by 30–50%, reduce out-of-stocks by up to 85%, and cut supply chain costs by 20–30%.
 
If modernizing your inventory operations is on the roadmap, I’d love to share how OnePint can help.
Let me know if you’re open to a quick meeting or even a casual chat—we’re happy to work around your schedule.
 
Looking forward to hearing from you.

"""


general_planning_email = """
I’m Devadas Pattathil, CEO of OnePint.ai. With over 25 years in supply chain technology—including 8+ years leading product, engineering, and data science at Walmart—I’ve seen firsthand how inaccurate forecasting and disconnected planning tools create costly inefficiencies.
 
That’s why we built **Pint Planning**, our AI-powered inventory planning platform that helps retailers:
- Improve forecast accuracy by 30–50%
- Reduce out-of-stocks by up to 85%
- Lower inventory holding and supply chain costs by 20–30%
 
We’ve partnered with retailers like BJ’s, Signet Jewelers, and Sainsbury’s to make planning smarter, faster, and more data-driven.
 
**Pint Planning** is part of our broader platform, which includes:
- **OneTruth** – Modern, centralized visibility for smarter inventory & delivery promises  
- **Pint Control Center** – Real-time monitoring and autonomous decisioning powered by AI agents
 
If modernizing your planning and execution systems is on your roadmap, I’d love to share how OnePint.ai can help.
 
Would you be open to a quick chat? I’d be happy to work around your schedule.

"""


# emails for grocery
# grocer_cfo_example, grocer_cfo_example_two, grocer_csco_example, grocer_cto_example
# retail_cto_example, retailer_csco_example
# brand_cfo_sample, brand_cto_sample, brand_csco_sample


def get_title(title:str):
    title = title.lower()
    # Roles focused on technology, IT, and digital infrastructure
    cto = [
        "director of infrastructure information technology",
        "vp of it",
        "chief technology officer",
        "chief technology officer and cdo",
    "director of analytics",
    "engineering manager - erp",
    "cto / vp ecommerce",
    "director of product management",
    "svp, program and product management",
    "cto",
    "director of web and business intelligence engineering",
    "svp, chief digital development and unified commerce officer",
    "director of web and business intelligence engineering",
    "svp, chief digital development and unified commerce officer",
        "sr. director of technology",
        "sr vp e-commerce",
        "head of ecommerce",
        "sr.director, loyalty and martech",
        "director, product management martech",
        "gvp, digital product & ux",
        "principal solutions architect",
        "product manager",  # first occurrence
        "marketing technology platform owner",
        "director, product manager",
        "sr director, mobile engineering",
        "group product manager",
        "product manager",
        "sr. manager, digital commerce operations",
        "digital omnichannel manager",
        "vice president, digital & customer experience",
        "director - digital insights & analytics",
        "sr. director, ecommerce",
        "director digital ecommerce",
        "director, omnichannel product management",
        "acquisition marketing director",
    "ecommerce analytics manager",
    "ecommerce vp",
    "manager it (product owner shopify)",
    "regional ecommerce and innovation manager",
    "svp. it - business apps, data, dtc",
    "vp, digital & ecommerce",
    "senior product manager, user experience",
    "chief digital officer",
    "enterprise architect",
    "lead ai implementation manor.ch",
    "vp, ecommerce & crm",
    "product manager - omnichannel",
    "director digital marketing",
    "executive director, digital marketing",
    "head of performance marketing",
        "head of technology",
        "head of digital & ecommerce",
        "global director of e-commerce",
        "director- ecommerce",
        "director of ecommerce & merchandising",
        "director of ecommerce and business development",
        "director of e-commerce merchandising",
        "director, ecommerce",
        "vp of ecommerce",
        "vp, digital",
        "vice president of marketing & ecommerce",
        "vp of marketing"
    ]


    # Roles focused on finance, accounting, and overall financial strategy
    cfo = [
        "senior director of finance",
        "owner",
        "chief financial officer",
        "director of financial planning, pricing strategy and inventory management (ecommerce)",
        "vice president of finance",
        "director of inventory and cost accounting",
        "cfo",
        "cfo",
        "senior vice president of revenue",
        "cfo & coo",
        "vice president - strategy, research and insights",
        "ceo/co-founder",
        "svp, customer & revenue growth",
        "founder / ceo",
        "president",
        "vp sales & marketing",
        "vice president of sales",
        "executive director",
        "ceo curaden usa",
        "sr. director, retention",
        "evp & chief commercial officer",
        "vice president - financial planning and analysis",
        "expereince channel marketing associate",
        "director of marketing procurement",
        "chief marketing officer",
        "vp merchandising",
        "director of sales planning",
        "vp global marketing",
        "sr. director, marketing",
        "sr. manager, integrated marketing",
        "vp growth marketing",
        "cro",  # Chief Revenue Officer (finance-related)
        "chief growth officer",  # Growth and finance strategy
        "head of sales, north america",
        "vp of sales",
        "senior analyst, strategy & operations",
        "senior buyer & brand partnerships"
    ]

    # Roles focused on supply chain, planning, inventory, and retail operations
    csco = [
        "interim demand planner",
        "senior director - inventory management",
        "director of wholesale planning",
        "inventory planning manager",
        "inventory planning manager",  # duplicate if you want to retain both occurrences
        "vp, owned retail",
        "vice president of e-commerce & digital",
        "senior director of stores and retail operations-north america",
        "senior manager, ecom operations",
        "director of planning & allocation",
        "inventory analyst",
        "senior vice president operations, supply chain and emerging markets",
        "vice president of planning",
        "director of distribution and supply chain",
        "analytics & inventory manager",
        "inventory analyst",
        "svp global supply chain",
        "supply chain",
        "director of supply chain",
        "senior director, e-commerce",
        "director of ecommerce",
        "director of operations",
        "head of dtc",
        "ceo",
        "vp, growth",
        "director of dtc, martech, and digital compliance",
        "head of digital, loyalty & retention",
        "co-ceo",
        "founder and ceo",
        "chief operating officer",
        "general manager",
        "ecommerce & omnichannel dtc regional director americas",
        "director of operations",
        "north america country director",
        "director of pmo",
        "director of systems of operations",
        "chief merchandising officer",

        "head of recruiting, training and development",
        "coo",
        "head of retail",
        "director of retail operations",
        "sr. director, retail vm",
        "supply chain operations",
        "co-founder",
        "co-founder & co-ceo",

        "director of brand marketing / social media, favorite daughter",
        "sr director of ecommerce merchandising",
        "sr. manager, us/ca consumer experience, omnichannel & innovation",
        "senior director of operations",
        "executive director, omnichannel",
        "director of qa",
        "vp of operations",
        "dmm of men's shoes",
        "head of business development",
        "senior project manager",
        "director of retail stores and events",
        "director of site merchandising",
        "director, product stores",
        "director/dmm",
        "executive vice president of operations",
        "head of operations",
        "managing director",
        "sr. director digital operations",
        "vp of omni operations",
        "vp, head of operations"
    ]

    if title in cto:
        return "cto"
    elif title in cfo:
        return "cfo"
    elif title in csco:
        return "csco"


def get_sample_emails(title: str, category: str, business: str):
    """
    industry can be grocer, retail, brand; title can be ceo, cfo, cto, cso.
    Return list of sample emails for the given title and industry.
    """
    generic_emails = True
    if True:
        return [general_planning_email]
    dallas_email=True
    if dallas_email:
        return [dallas_sample_first_email, dallas_sample_second_email]
    business = business.lower()
    category = category.lower()
    title = title.lower()
    email_title = get_title(title)
    is_d2c = business in ['d2c', 'direct to consumer']
    if is_d2c:
        if email_title == 'cfo' :
            return [brand_cfo_sample]
        elif email_title == 'csco':
            return [brand_csco_sample]
        elif email_title =='cto':
            return [brand_cto_sample]
    # if not d2c, then it is retailer
    if "grocer" in category:
        if email_title == 'cfo' :
            return [grocer_cfo_example, grocer_cfo_example_two]
        elif email_title == 'csco':
            primary = [grocer_csco_example]
            return primary
        elif email_title =='cto':
            return [grocer_cto_example]
    if email_title =='cto':
        return [retail_cto_example]
    elif email_title == 'csco':
        return [retailer_csco_example]
    return [retail_cto_example, retailer_csco_example]


def process_titles(file_path: str):
    import os
    import csv
    file_path = os.path.join(os.path.dirname(__file__), file_path)
    with open(file_path, mode="r", encoding="latin-1") as file:
        csv_reader = csv.reader(file)
        for row in csv_reader:
            email_title = get_title(row[4])
            if not email_title:
                print(row[4])


#process_titles("Shoptalk Outreaches-17Mar-Pending.csv")