#|
#|  Copyright The Telepact Authors
#|
#|  Licensed under the Apache License, Version 2.0 (the "License");
#|  you may not use this file except in compliance with the License.
#|  You may obtain a copy of the License at
#|
#|  https://www.apache.org/licenses/LICENSE-2.0
#|
#|  Unless required by applicable law or agreed to in writing, software
#|  distributed under the License is distributed on an "AS IS" BASIS,
#|  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#|  See the License for the specific language governing permissions and
#|  limitations under the License.
#|

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...internal.mock.MockInvocation import MockInvocation


def verify_no_more_interactions(invocations: list['MockInvocation']) -> dict[str, object]:
    invocations_not_verified = [i for i in invocations if not i.verified]

    if invocations_not_verified:
        unverified_calls_pseudo_json = []
        for invocation in invocations_not_verified:
            unverified_calls_pseudo_json.append(
                {invocation.function_name: invocation.function_argument})
        return {
            "ErrorVerificationFailure": {
                "additionalUnverifiedCalls": unverified_calls_pseudo_json
            }
        }

    return {"Ok_": {}}
