# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_lab import ClientFacingLab
from .client_facing_marker import ClientFacingMarker
from .lab_test_collection_method import LabTestCollectionMethod
from .lab_test_sample_type import LabTestSampleType
from .lab_test_status import LabTestStatus


class ClientFacingLabTest(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    
    """

    slug: str = pydantic.Field()
    """
    
    """

    name: str = pydantic.Field()
    """
    
    """

    sample_type: LabTestSampleType = pydantic.Field()
    """
    
    """

    method: LabTestCollectionMethod = pydantic.Field()
    """
    
    """

    price: float = pydantic.Field()
    """
    
    """

    is_active: bool = pydantic.Field()
    """
    Deprecated. Use status instead.
    """

    status: LabTestStatus = pydantic.Field()
    """
    
    """

    fasting: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Defines whether a lab test requires fasting.
    """

    lab: typing.Optional[ClientFacingLab] = pydantic.Field(default=None)
    """
    
    """

    markers: typing.Optional[typing.List[ClientFacingMarker]] = pydantic.Field(default=None)
    """
    
    """

    is_delegated: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Denotes whether a lab test requires using non-Vital physician networks. If it does then it's delegated - no otherwise.
    """

    auto_generated: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the lab test was auto-generated by Vital
    """

    has_collection_instructions: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the lab test has collection instructions.
    """

    common_tat_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    The common turnaround time in days for the lab test. This is the expected time for the lab to process the test and return results.
    """

    worst_case_tat_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    The worst-case turnaround time in days for the lab test. This is the maximum time the lab may take to process the test and return results.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
