# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_sleep_cycle_source_provider import ClientFacingSleepCycleSourceProvider
from .client_facing_sleep_cycle_source_type import ClientFacingSleepCycleSourceType
from .client_facing_source import ClientFacingSource
from .vital_sleep_stage import VitalSleepStage


class ClientFacingSleepCycle(UniversalBaseModel):
    id: str
    sleep_id: str
    session_start: dt.datetime
    session_end: dt.datetime
    stage_start_offset_second: typing.List[int]
    stage_end_offset_second: typing.List[int]
    stage_type: typing.List[VitalSleepStage] = pydantic.Field()
    """
    
    Sleep stage classification:
    `-1`: Unknown or unclassified sleep stage;
    `1`: Deep sleep;
    `2`: Light/non-REM sleep;
    `3`: Rapid Eye Movement sleep;
    `4`: Awake period;
    `5`: Manually classified stage.
    """

    time_zone: typing.Optional[str] = None
    source_provider: ClientFacingSleepCycleSourceProvider
    source_type: ClientFacingSleepCycleSourceType = pydantic.Field()
    """
    ℹ️ This enum is non-exhaustive.
    """

    source_app_id: typing.Optional[str] = None
    source_device_id: typing.Optional[str] = None
    created_at: dt.datetime
    updated_at: dt.datetime
    user_id: str
    source: ClientFacingSource

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
