# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class LabTestSampleType(str, enum.Enum):
    """
    The type of sample used to perform a lab test. ℹ️ This enum is non-exhaustive.
    """

    DRIED_BLOOD_SPOT = "dried_blood_spot"
    ARM_COLLECTOR = "arm_collector"
    SERUM = "serum"
    SALIVA = "saliva"
    URINE = "urine"
    _UNKNOWN = "__LABTESTSAMPLETYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "LabTestSampleType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        dried_blood_spot: typing.Callable[[], T_Result],
        arm_collector: typing.Callable[[], T_Result],
        serum: typing.Callable[[], T_Result],
        saliva: typing.Callable[[], T_Result],
        urine: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is LabTestSampleType.DRIED_BLOOD_SPOT:
            return dried_blood_spot()
        if self is LabTestSampleType.ARM_COLLECTOR:
            return arm_collector()
        if self is LabTestSampleType.SERUM:
            return serum()
        if self is LabTestSampleType.SALIVA:
            return saliva()
        if self is LabTestSampleType.URINE:
            return urine()
        return _unknown_member(self._value_)
