# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.4
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from authentik_client.models.log_event import LogEvent
from authentik_client.models.state_enum import StateEnum
from authentik_client.models.task_aggregated_status_enum import TaskAggregatedStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class Task(BaseModel):
    """
    Task
    """ # noqa: E501
    message_id: Optional[StrictStr] = None
    queue_name: Optional[StrictStr] = Field(default=None, description="Queue name")
    actor_name: StrictStr = Field(description="Dramatiq actor name")
    state: Optional[StateEnum] = Field(default=None, description="Task status")
    mtime: Optional[datetime] = Field(default=None, description="Task last modified time")
    rel_obj_app_label: StrictStr
    rel_obj_model: StrictStr
    rel_obj_id: Optional[StrictStr] = None
    uid: StrictStr
    messages: List[LogEvent]
    previous_messages: List[LogEvent]
    aggregated_status: TaskAggregatedStatusEnum
    description: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["message_id", "queue_name", "actor_name", "state", "mtime", "rel_obj_app_label", "rel_obj_model", "rel_obj_id", "uid", "messages", "previous_messages", "aggregated_status", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Task from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "rel_obj_app_label",
            "rel_obj_model",
            "uid",
            "description",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item_messages in self.messages:
                if _item_messages:
                    _items.append(_item_messages.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in previous_messages (list)
        _items = []
        if self.previous_messages:
            for _item_previous_messages in self.previous_messages:
                if _item_previous_messages:
                    _items.append(_item_previous_messages.to_dict())
            _dict['previous_messages'] = _items
        # set to None if rel_obj_id (nullable) is None
        # and model_fields_set contains the field
        if self.rel_obj_id is None and "rel_obj_id" in self.model_fields_set:
            _dict['rel_obj_id'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Task from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message_id": obj.get("message_id"),
            "queue_name": obj.get("queue_name"),
            "actor_name": obj.get("actor_name"),
            "state": obj.get("state"),
            "mtime": obj.get("mtime"),
            "rel_obj_app_label": obj.get("rel_obj_app_label"),
            "rel_obj_model": obj.get("rel_obj_model"),
            "rel_obj_id": obj.get("rel_obj_id"),
            "uid": obj.get("uid"),
            "messages": [LogEvent.from_dict(_item) for _item in obj["messages"]] if obj.get("messages") is not None else None,
            "previous_messages": [LogEvent.from_dict(_item) for _item in obj["previous_messages"]] if obj.get("previous_messages") is not None else None,
            "aggregated_status": obj.get("aggregated_status"),
            "description": obj.get("description")
        })
        return _obj


