# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: api/auth/auth.proto
# plugin: python-betterproto
# This file has been @generated
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpc


if TYPE_CHECKING:
    import grpc


class Permission(betterproto.Enum):
    """
    Permission represents the ability to perform a given operation on a
    Resource
    """

    PERMISSION_UNKNOWN = 0
    CLUSTER_MODIFY_BINDINGS = 100
    CLUSTER_GET_BINDINGS = 101
    CLUSTER_GET_PACHD_LOGS = 148
    CLUSTER_GET_LOKI_LOGS = 150
    CLUSTER_AUTH_ACTIVATE = 102
    CLUSTER_AUTH_DEACTIVATE = 103
    CLUSTER_AUTH_GET_CONFIG = 104
    CLUSTER_AUTH_SET_CONFIG = 105
    CLUSTER_AUTH_GET_ROBOT_TOKEN = 139
    CLUSTER_AUTH_MODIFY_GROUP_MEMBERS = 109
    CLUSTER_AUTH_GET_GROUPS = 110
    CLUSTER_AUTH_GET_GROUP_USERS = 111
    CLUSTER_AUTH_EXTRACT_TOKENS = 112
    CLUSTER_AUTH_RESTORE_TOKEN = 113
    CLUSTER_AUTH_GET_PERMISSIONS_FOR_PRINCIPAL = 141
    CLUSTER_AUTH_DELETE_EXPIRED_TOKENS = 140
    CLUSTER_AUTH_REVOKE_USER_TOKENS = 142
    CLUSTER_AUTH_ROTATE_ROOT_TOKEN = 147
    CLUSTER_ENTERPRISE_ACTIVATE = 114
    CLUSTER_ENTERPRISE_HEARTBEAT = 115
    CLUSTER_ENTERPRISE_GET_CODE = 116
    CLUSTER_ENTERPRISE_DEACTIVATE = 117
    CLUSTER_ENTERPRISE_PAUSE = 149
    CLUSTER_IDENTITY_SET_CONFIG = 118
    CLUSTER_IDENTITY_GET_CONFIG = 119
    CLUSTER_IDENTITY_CREATE_IDP = 120
    CLUSTER_IDENTITY_UPDATE_IDP = 121
    CLUSTER_IDENTITY_LIST_IDPS = 122
    CLUSTER_IDENTITY_GET_IDP = 123
    CLUSTER_IDENTITY_DELETE_IDP = 124
    CLUSTER_IDENTITY_CREATE_OIDC_CLIENT = 125
    CLUSTER_IDENTITY_UPDATE_OIDC_CLIENT = 126
    CLUSTER_IDENTITY_LIST_OIDC_CLIENTS = 127
    CLUSTER_IDENTITY_GET_OIDC_CLIENT = 128
    CLUSTER_IDENTITY_DELETE_OIDC_CLIENT = 129
    CLUSTER_DEBUG_DUMP = 131
    CLUSTER_LICENSE_ACTIVATE = 132
    CLUSTER_LICENSE_GET_CODE = 133
    CLUSTER_LICENSE_ADD_CLUSTER = 134
    CLUSTER_LICENSE_UPDATE_CLUSTER = 135
    CLUSTER_LICENSE_DELETE_CLUSTER = 136
    CLUSTER_LICENSE_LIST_CLUSTERS = 137
    CLUSTER_CREATE_SECRET = 143
    """TODO(actgardner): Make k8s secrets into nouns and add an Update RPC"""

    CLUSTER_LIST_SECRETS = 144
    SECRET_DELETE = 145
    SECRET_INSPECT = 146
    CLUSTER_DELETE_ALL = 138
    REPO_READ = 200
    REPO_WRITE = 201
    REPO_MODIFY_BINDINGS = 202
    REPO_DELETE = 203
    REPO_INSPECT_COMMIT = 204
    REPO_LIST_COMMIT = 205
    REPO_DELETE_COMMIT = 206
    REPO_CREATE_BRANCH = 207
    REPO_LIST_BRANCH = 208
    REPO_DELETE_BRANCH = 209
    REPO_INSPECT_FILE = 210
    REPO_LIST_FILE = 211
    REPO_ADD_PIPELINE_READER = 212
    REPO_REMOVE_PIPELINE_READER = 213
    REPO_ADD_PIPELINE_WRITER = 214
    PIPELINE_LIST_JOB = 301
    CLUSTER_SET_DEFAULTS = 302
    """CLUSTER_SET_DEFAULTS is part of PPS."""

    PROJECT_SET_DEFAULTS = 303
    """PROJECT_SET_DEFAULTS is part of PPS."""

    PROJECT_CREATE = 400
    PROJECT_DELETE = 401
    PROJECT_LIST_REPO = 402
    PROJECT_CREATE_REPO = 403
    PROJECT_MODIFY_BINDINGS = 404


class ResourceType(betterproto.Enum):
    """ResourceType represents the type of a Resource"""

    RESOURCE_TYPE_UNKNOWN = 0
    CLUSTER = 1
    REPO = 2
    SPEC_REPO = 3
    PROJECT = 4


@dataclass(eq=False, repr=False)
class ActivateRequest(betterproto.Message):
    """
    ActivateRequest enables authentication on the cluster. It issues an auth
    token with no expiration for the irrevocable admin user `pach:root`.
    """

    root_token: str = betterproto.string_field(1)
    """
    If set, this token is used as the root user login token. Otherwise the root
    token is randomly generated and returned in the response.
    """


@dataclass(eq=False, repr=False)
class ActivateResponse(betterproto.Message):
    pach_token: str = betterproto.string_field(1)
    """
    pach_token authenticates the caller with Pachyderm (if you want to perform
    Pachyderm operations after auth has been activated as themselves, you must
    present this token along with your regular request)
    """


@dataclass(eq=False, repr=False)
class DeactivateRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeactivateResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RotateRootTokenRequest(betterproto.Message):
    root_token: str = betterproto.string_field(1)
    """
    root_token is used as the new root token value. If it's unset, then a token
    will be auto-generated.
    """


@dataclass(eq=False, repr=False)
class RotateRootTokenResponse(betterproto.Message):
    root_token: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class OidcConfig(betterproto.Message):
    """Configure Pachyderm's auth system with an OIDC provider"""

    issuer: str = betterproto.string_field(1)
    client_id: str = betterproto.string_field(2)
    client_secret: str = betterproto.string_field(3)
    redirect_uri: str = betterproto.string_field(4)
    scopes: List[str] = betterproto.string_field(5)
    require_email_verified: bool = betterproto.bool_field(6)
    localhost_issuer: bool = betterproto.bool_field(7)
    """
    localhost_issuer ignores the contents of the issuer claim and makes all
    OIDC requests to the embedded OIDC provider. This is necessary to support
    some network configurations like Minikube.
    """

    user_accessible_issuer_host: str = betterproto.string_field(8)
    """
    user_accessible_issuer_host can be set to override the host used in the
    OAuth2 authorization URL in case the OIDC issuer isn't accessible outside
    the cluster. This requires a fully formed URL with scheme of either http or
    https. This is necessary to support some configurations like Minikube.
    """


@dataclass(eq=False, repr=False)
class GetConfigurationRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetConfigurationResponse(betterproto.Message):
    configuration: "OidcConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SetConfigurationRequest(betterproto.Message):
    configuration: "OidcConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SetConfigurationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class TokenInfo(betterproto.Message):
    """
    TokenInfo is the 'value' of an auth token 'key' in the 'tokens' collection
    """

    subject: str = betterproto.string_field(1)
    """
    Subject (i.e. Pachyderm account) that a given token authorizes. See the
    note at the top of the doc for an explanation of subject structure.
    """

    expiration: datetime = betterproto.message_field(2)
    hashed_token: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class AuthenticateRequest(betterproto.Message):
    oidc_state: str = betterproto.string_field(1)
    """
    This is the session state that Pachyderm creates in order to keep track of
    information related to the current OIDC session.
    """

    id_token: str = betterproto.string_field(2)
    """This is an ID Token issued by the OIDC provider."""


@dataclass(eq=False, repr=False)
class AuthenticateResponse(betterproto.Message):
    pach_token: str = betterproto.string_field(1)
    """
    pach_token authenticates the caller with Pachyderm (if you want to perform
    Pachyderm operations after auth has been activated as themselves, you must
    present this token along with your regular request)
    """


@dataclass(eq=False, repr=False)
class WhoAmIRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class WhoAmIResponse(betterproto.Message):
    username: str = betterproto.string_field(1)
    expiration: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetRolesForPermissionRequest(betterproto.Message):
    permission: "Permission" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetRolesForPermissionResponse(betterproto.Message):
    roles: List["Role"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Roles(betterproto.Message):
    """Roles represents the set of roles a principal has"""

    roles: Dict[str, bool] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_BOOL
    )


@dataclass(eq=False, repr=False)
class RoleBinding(betterproto.Message):
    """
    RoleBinding represents the set of roles principals have on a given Resource
    """

    entries: Dict[str, "Roles"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    principal -> roles. All principal names include the structured prefix
    indicating their type.
    """


@dataclass(eq=False, repr=False)
class Resource(betterproto.Message):
    """
    Resource represents any resource that has role-bindings in the system
    """

    type: "ResourceType" = betterproto.enum_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Users(betterproto.Message):
    usernames: Dict[str, bool] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_BOOL
    )


@dataclass(eq=False, repr=False)
class Groups(betterproto.Message):
    groups: Dict[str, bool] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_BOOL
    )


@dataclass(eq=False, repr=False)
class Role(betterproto.Message):
    name: str = betterproto.string_field(1)
    permissions: List["Permission"] = betterproto.enum_field(2)
    can_be_bound_to: List["ResourceType"] = betterproto.enum_field(3)
    """
    Resources this role can be bound to.  For example, you can't apply
    clusterAdmin to a repo, so REPO would not be listed here.
    """

    returned_for: List["ResourceType"] = betterproto.enum_field(4)
    """
    Resources this role is returned for.  For example, a principal might have
    clusterAdmin permissions on the cluster, and this is what allows them to
    write to a repo.  So, clusterAdmin is returned for the repo, even though it
    cannot be bound to a repo.
    """


@dataclass(eq=False, repr=False)
class AuthorizeRequest(betterproto.Message):
    resource: "Resource" = betterproto.message_field(1)
    permissions: List["Permission"] = betterproto.enum_field(2)
    """permissions are the operations the caller is attempting to perform"""


@dataclass(eq=False, repr=False)
class AuthorizeResponse(betterproto.Message):
    authorized: bool = betterproto.bool_field(1)
    """authorized is true if the caller has the require permissions"""

    satisfied: List["Permission"] = betterproto.enum_field(2)
    """satisfied is the set of permission that the principal has"""

    missing: List["Permission"] = betterproto.enum_field(3)
    """missing is the set of permissions that the principal lacks"""

    principal: str = betterproto.string_field(4)
    """principal is the principal the request was evaluated for"""


@dataclass(eq=False, repr=False)
class GetPermissionsRequest(betterproto.Message):
    """
    GetPermissions evaluates the current user's permissions on a resource
    """

    resource: "Resource" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetPermissionsForPrincipalRequest(betterproto.Message):
    """
    GetPermissionsForPrincipal evaluates an arbitrary principal's permissions
    on a resource
    """

    resource: "Resource" = betterproto.message_field(1)
    principal: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetPermissionsResponse(betterproto.Message):
    permissions: List["Permission"] = betterproto.enum_field(1)
    """permissions is the set of permissions the principal has"""

    roles: List[str] = betterproto.string_field(2)
    """roles is the set of roles the principal has"""


@dataclass(eq=False, repr=False)
class ModifyRoleBindingRequest(betterproto.Message):
    resource: "Resource" = betterproto.message_field(1)
    """resource is the resource to modify the role bindings on"""

    principal: str = betterproto.string_field(2)
    """principal is the principal to modify the roles binding for"""

    roles: List[str] = betterproto.string_field(3)
    """
    roles is the set of roles for principal - an empty list removes all role
    bindings
    """


@dataclass(eq=False, repr=False)
class ModifyRoleBindingResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetRoleBindingRequest(betterproto.Message):
    resource: "Resource" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetRoleBindingResponse(betterproto.Message):
    binding: "RoleBinding" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SessionInfo(betterproto.Message):
    """
    SessionInfo stores information associated with one OIDC authentication
    session (i.e. a single instance of a single user logging in). Sessions are
    short-lived and stored in the 'oidc-authns' collection, keyed by the OIDC
    'state' token (30-character CSPRNG-generated string). 'GetOIDCLogin'
    generates and inserts entries, then /authorization-code/callback retrieves
    an access token from the ID provider and uses it to retrive the caller's
    email and store it in 'email', and finally Authorize() returns a Pachyderm
    token identified with that email address as a subject in Pachyderm.
    """

    nonce: str = betterproto.string_field(1)
    """
    nonce is used by /authorization-code/callback to validate session
    continuity with the IdP after a user has arrived there from GetOIDCLogin().
    This is a 30-character CSPRNG-generated string.
    """

    email: str = betterproto.string_field(2)
    """
    email contains the email adddress associated with a user in their OIDC ID
    provider. Currently users are identified with their email address rather
    than their OIDC subject identifier to make switching between OIDC ID
    providers easier for users, and to make user identities more easily
    comprehensible in Pachyderm. The OIDC spec doesn't require that users'
    emails be present or unique, but we think this will be preferable in
    practice.
    """

    conversion_err: bool = betterproto.bool_field(3)
    """
    conversion_err indicates whether an error was encountered while exchanging
    an auth code for an access token, or while obtaining a user's email (in
    /authorization-code/callback). Storing the error state here allows any
    sibling calls to Authenticate() (i.e. using the same OIDC state token) to
    notify their caller that an error has occurred. We avoid passing the caller
    any details of the error (which are logged by Pachyderm) to avoid giving
    information to a user who has network access to Pachyderm but not an
    account in the OIDC provider.
    """


@dataclass(eq=False, repr=False)
class GetOidcLoginRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetOidcLoginResponse(betterproto.Message):
    login_url: str = betterproto.string_field(1)
    """The login URL generated for the OIDC object"""

    state: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetRobotTokenRequest(betterproto.Message):
    robot: str = betterproto.string_field(1)
    """
    The returned token will allow the caller to access resources as this robot
    user
    """

    ttl: int = betterproto.int64_field(2)
    """
    ttl indicates the requested (approximate) remaining lifetime of this token,
    in seconds
    """


@dataclass(eq=False, repr=False)
class GetRobotTokenResponse(betterproto.Message):
    token: str = betterproto.string_field(1)
    """A new auth token for the requested robot"""


@dataclass(eq=False, repr=False)
class RevokeAuthTokenRequest(betterproto.Message):
    token: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RevokeAuthTokenResponse(betterproto.Message):
    number: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class SetGroupsForUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    groups: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SetGroupsForUserResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ModifyMembersRequest(betterproto.Message):
    group: str = betterproto.string_field(1)
    add: List[str] = betterproto.string_field(2)
    remove: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ModifyMembersResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetGroupsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetGroupsForPrincipalRequest(betterproto.Message):
    principal: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetGroupsResponse(betterproto.Message):
    groups: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetUsersRequest(betterproto.Message):
    group: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetUsersResponse(betterproto.Message):
    usernames: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ExtractAuthTokensRequest(betterproto.Message):
    """
    ExtractAuthTokens returns all the hashed robot tokens that have been
    issued. User tokens are not extracted as they can be recreated by logging
    in.
    """

    pass


@dataclass(eq=False, repr=False)
class ExtractAuthTokensResponse(betterproto.Message):
    tokens: List["TokenInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RestoreAuthTokenRequest(betterproto.Message):
    """
    RestoreAuthToken inserts a hashed token that has previously been extracted.
    """

    token: "TokenInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RestoreAuthTokenResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RevokeAuthTokensForUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RevokeAuthTokensForUserResponse(betterproto.Message):
    number: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class DeleteExpiredAuthTokensRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteExpiredAuthTokensResponse(betterproto.Message):
    pass


class ApiStub:

    def __init__(self, channel: "grpc.Channel"):
        self.__rpc_activate = channel.unary_unary(
            "/auth_v2.API/Activate",
            request_serializer=ActivateRequest.SerializeToString,
            response_deserializer=ActivateResponse.FromString,
        )
        self.__rpc_deactivate = channel.unary_unary(
            "/auth_v2.API/Deactivate",
            request_serializer=DeactivateRequest.SerializeToString,
            response_deserializer=DeactivateResponse.FromString,
        )
        self.__rpc_get_configuration = channel.unary_unary(
            "/auth_v2.API/GetConfiguration",
            request_serializer=GetConfigurationRequest.SerializeToString,
            response_deserializer=GetConfigurationResponse.FromString,
        )
        self.__rpc_set_configuration = channel.unary_unary(
            "/auth_v2.API/SetConfiguration",
            request_serializer=SetConfigurationRequest.SerializeToString,
            response_deserializer=SetConfigurationResponse.FromString,
        )
        self.__rpc_authenticate = channel.unary_unary(
            "/auth_v2.API/Authenticate",
            request_serializer=AuthenticateRequest.SerializeToString,
            response_deserializer=AuthenticateResponse.FromString,
        )
        self.__rpc_authorize = channel.unary_unary(
            "/auth_v2.API/Authorize",
            request_serializer=AuthorizeRequest.SerializeToString,
            response_deserializer=AuthorizeResponse.FromString,
        )
        self.__rpc_get_permissions = channel.unary_unary(
            "/auth_v2.API/GetPermissions",
            request_serializer=GetPermissionsRequest.SerializeToString,
            response_deserializer=GetPermissionsResponse.FromString,
        )
        self.__rpc_get_permissions_for_principal = channel.unary_unary(
            "/auth_v2.API/GetPermissionsForPrincipal",
            request_serializer=GetPermissionsForPrincipalRequest.SerializeToString,
            response_deserializer=GetPermissionsResponse.FromString,
        )
        self.__rpc_who_am_i = channel.unary_unary(
            "/auth_v2.API/WhoAmI",
            request_serializer=WhoAmIRequest.SerializeToString,
            response_deserializer=WhoAmIResponse.FromString,
        )
        self.__rpc_get_roles_for_permission = channel.unary_unary(
            "/auth_v2.API/GetRolesForPermission",
            request_serializer=GetRolesForPermissionRequest.SerializeToString,
            response_deserializer=GetRolesForPermissionResponse.FromString,
        )
        self.__rpc_modify_role_binding = channel.unary_unary(
            "/auth_v2.API/ModifyRoleBinding",
            request_serializer=ModifyRoleBindingRequest.SerializeToString,
            response_deserializer=ModifyRoleBindingResponse.FromString,
        )
        self.__rpc_get_role_binding = channel.unary_unary(
            "/auth_v2.API/GetRoleBinding",
            request_serializer=GetRoleBindingRequest.SerializeToString,
            response_deserializer=GetRoleBindingResponse.FromString,
        )
        self.__rpc_get_oidc_login = channel.unary_unary(
            "/auth_v2.API/GetOIDCLogin",
            request_serializer=GetOidcLoginRequest.SerializeToString,
            response_deserializer=GetOidcLoginResponse.FromString,
        )
        self.__rpc_get_robot_token = channel.unary_unary(
            "/auth_v2.API/GetRobotToken",
            request_serializer=GetRobotTokenRequest.SerializeToString,
            response_deserializer=GetRobotTokenResponse.FromString,
        )
        self.__rpc_revoke_auth_token = channel.unary_unary(
            "/auth_v2.API/RevokeAuthToken",
            request_serializer=RevokeAuthTokenRequest.SerializeToString,
            response_deserializer=RevokeAuthTokenResponse.FromString,
        )
        self.__rpc_revoke_auth_tokens_for_user = channel.unary_unary(
            "/auth_v2.API/RevokeAuthTokensForUser",
            request_serializer=RevokeAuthTokensForUserRequest.SerializeToString,
            response_deserializer=RevokeAuthTokensForUserResponse.FromString,
        )
        self.__rpc_set_groups_for_user = channel.unary_unary(
            "/auth_v2.API/SetGroupsForUser",
            request_serializer=SetGroupsForUserRequest.SerializeToString,
            response_deserializer=SetGroupsForUserResponse.FromString,
        )
        self.__rpc_modify_members = channel.unary_unary(
            "/auth_v2.API/ModifyMembers",
            request_serializer=ModifyMembersRequest.SerializeToString,
            response_deserializer=ModifyMembersResponse.FromString,
        )
        self.__rpc_get_groups = channel.unary_unary(
            "/auth_v2.API/GetGroups",
            request_serializer=GetGroupsRequest.SerializeToString,
            response_deserializer=GetGroupsResponse.FromString,
        )
        self.__rpc_get_groups_for_principal = channel.unary_unary(
            "/auth_v2.API/GetGroupsForPrincipal",
            request_serializer=GetGroupsForPrincipalRequest.SerializeToString,
            response_deserializer=GetGroupsResponse.FromString,
        )
        self.__rpc_get_users = channel.unary_unary(
            "/auth_v2.API/GetUsers",
            request_serializer=GetUsersRequest.SerializeToString,
            response_deserializer=GetUsersResponse.FromString,
        )
        self.__rpc_extract_auth_tokens = channel.unary_unary(
            "/auth_v2.API/ExtractAuthTokens",
            request_serializer=ExtractAuthTokensRequest.SerializeToString,
            response_deserializer=ExtractAuthTokensResponse.FromString,
        )
        self.__rpc_restore_auth_token = channel.unary_unary(
            "/auth_v2.API/RestoreAuthToken",
            request_serializer=RestoreAuthTokenRequest.SerializeToString,
            response_deserializer=RestoreAuthTokenResponse.FromString,
        )
        self.__rpc_delete_expired_auth_tokens = channel.unary_unary(
            "/auth_v2.API/DeleteExpiredAuthTokens",
            request_serializer=DeleteExpiredAuthTokensRequest.SerializeToString,
            response_deserializer=DeleteExpiredAuthTokensResponse.FromString,
        )
        self.__rpc_rotate_root_token = channel.unary_unary(
            "/auth_v2.API/RotateRootToken",
            request_serializer=RotateRootTokenRequest.SerializeToString,
            response_deserializer=RotateRootTokenResponse.FromString,
        )

    def activate(self, *, root_token: str = "") -> "ActivateResponse":

        request = ActivateRequest()
        request.root_token = root_token

        return self.__rpc_activate(request)

    def deactivate(self) -> "DeactivateResponse":

        request = DeactivateRequest()

        return self.__rpc_deactivate(request)

    def get_configuration(self) -> "GetConfigurationResponse":

        request = GetConfigurationRequest()

        return self.__rpc_get_configuration(request)

    def set_configuration(
        self, *, configuration: "OidcConfig" = None
    ) -> "SetConfigurationResponse":

        request = SetConfigurationRequest()
        if configuration is not None:
            request.configuration = configuration

        return self.__rpc_set_configuration(request)

    def authenticate(
        self, *, oidc_state: str = "", id_token: str = ""
    ) -> "AuthenticateResponse":

        request = AuthenticateRequest()
        request.oidc_state = oidc_state
        request.id_token = id_token

        return self.__rpc_authenticate(request)

    def authorize(
        self,
        *,
        resource: "Resource" = None,
        permissions: Optional[List["Permission"]] = None
    ) -> "AuthorizeResponse":
        permissions = permissions or []

        request = AuthorizeRequest()
        if resource is not None:
            request.resource = resource
        request.permissions = permissions

        return self.__rpc_authorize(request)

    def get_permissions(
        self, *, resource: "Resource" = None
    ) -> "GetPermissionsResponse":

        request = GetPermissionsRequest()
        if resource is not None:
            request.resource = resource

        return self.__rpc_get_permissions(request)

    def get_permissions_for_principal(
        self, *, resource: "Resource" = None, principal: str = ""
    ) -> "GetPermissionsResponse":

        request = GetPermissionsForPrincipalRequest()
        if resource is not None:
            request.resource = resource
        request.principal = principal

        return self.__rpc_get_permissions_for_principal(request)

    def who_am_i(self) -> "WhoAmIResponse":

        request = WhoAmIRequest()

        return self.__rpc_who_am_i(request)

    def get_roles_for_permission(
        self, *, permission: "Permission" = None
    ) -> "GetRolesForPermissionResponse":

        request = GetRolesForPermissionRequest()
        request.permission = permission

        return self.__rpc_get_roles_for_permission(request)

    def modify_role_binding(
        self,
        *,
        resource: "Resource" = None,
        principal: str = "",
        roles: Optional[List[str]] = None
    ) -> "ModifyRoleBindingResponse":
        roles = roles or []

        request = ModifyRoleBindingRequest()
        if resource is not None:
            request.resource = resource
        request.principal = principal
        request.roles = roles

        return self.__rpc_modify_role_binding(request)

    def get_role_binding(
        self, *, resource: "Resource" = None
    ) -> "GetRoleBindingResponse":

        request = GetRoleBindingRequest()
        if resource is not None:
            request.resource = resource

        return self.__rpc_get_role_binding(request)

    def get_oidc_login(self) -> "GetOidcLoginResponse":

        request = GetOidcLoginRequest()

        return self.__rpc_get_oidc_login(request)

    def get_robot_token(
        self, *, robot: str = "", ttl: int = 0
    ) -> "GetRobotTokenResponse":

        request = GetRobotTokenRequest()
        request.robot = robot
        request.ttl = ttl

        return self.__rpc_get_robot_token(request)

    def revoke_auth_token(self, *, token: str = "") -> "RevokeAuthTokenResponse":

        request = RevokeAuthTokenRequest()
        request.token = token

        return self.__rpc_revoke_auth_token(request)

    def revoke_auth_tokens_for_user(
        self, *, username: str = ""
    ) -> "RevokeAuthTokensForUserResponse":

        request = RevokeAuthTokensForUserRequest()
        request.username = username

        return self.__rpc_revoke_auth_tokens_for_user(request)

    def set_groups_for_user(
        self, *, username: str = "", groups: Optional[List[str]] = None
    ) -> "SetGroupsForUserResponse":
        groups = groups or []

        request = SetGroupsForUserRequest()
        request.username = username
        request.groups = groups

        return self.__rpc_set_groups_for_user(request)

    def modify_members(
        self,
        *,
        group: str = "",
        add: Optional[List[str]] = None,
        remove: Optional[List[str]] = None
    ) -> "ModifyMembersResponse":
        add = add or []
        remove = remove or []

        request = ModifyMembersRequest()
        request.group = group
        request.add = add
        request.remove = remove

        return self.__rpc_modify_members(request)

    def get_groups(self) -> "GetGroupsResponse":

        request = GetGroupsRequest()

        return self.__rpc_get_groups(request)

    def get_groups_for_principal(self, *, principal: str = "") -> "GetGroupsResponse":

        request = GetGroupsForPrincipalRequest()
        request.principal = principal

        return self.__rpc_get_groups_for_principal(request)

    def get_users(self, *, group: str = "") -> "GetUsersResponse":

        request = GetUsersRequest()
        request.group = group

        return self.__rpc_get_users(request)

    def extract_auth_tokens(self) -> "ExtractAuthTokensResponse":

        request = ExtractAuthTokensRequest()

        return self.__rpc_extract_auth_tokens(request)

    def restore_auth_token(
        self, *, token: "TokenInfo" = None
    ) -> "RestoreAuthTokenResponse":

        request = RestoreAuthTokenRequest()
        if token is not None:
            request.token = token

        return self.__rpc_restore_auth_token(request)

    def delete_expired_auth_tokens(self) -> "DeleteExpiredAuthTokensResponse":

        request = DeleteExpiredAuthTokensRequest()

        return self.__rpc_delete_expired_auth_tokens(request)

    def rotate_root_token(self, *, root_token: str = "") -> "RotateRootTokenResponse":

        request = RotateRootTokenRequest()
        request.root_token = root_token

        return self.__rpc_rotate_root_token(request)


class ApiBase:

    def activate(
        self, root_token: str, context: "grpc.ServicerContext"
    ) -> "ActivateResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def deactivate(self, context: "grpc.ServicerContext") -> "DeactivateResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_configuration(
        self, context: "grpc.ServicerContext"
    ) -> "GetConfigurationResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def set_configuration(
        self, configuration: "OidcConfig", context: "grpc.ServicerContext"
    ) -> "SetConfigurationResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def authenticate(
        self, oidc_state: str, id_token: str, context: "grpc.ServicerContext"
    ) -> "AuthenticateResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def authorize(
        self,
        resource: "Resource",
        permissions: Optional[List["Permission"]],
        context: "grpc.ServicerContext",
    ) -> "AuthorizeResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_permissions(
        self, resource: "Resource", context: "grpc.ServicerContext"
    ) -> "GetPermissionsResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_permissions_for_principal(
        self, resource: "Resource", principal: str, context: "grpc.ServicerContext"
    ) -> "GetPermissionsResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def who_am_i(self, context: "grpc.ServicerContext") -> "WhoAmIResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_roles_for_permission(
        self, permission: "Permission", context: "grpc.ServicerContext"
    ) -> "GetRolesForPermissionResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def modify_role_binding(
        self,
        resource: "Resource",
        principal: str,
        roles: Optional[List[str]],
        context: "grpc.ServicerContext",
    ) -> "ModifyRoleBindingResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_role_binding(
        self, resource: "Resource", context: "grpc.ServicerContext"
    ) -> "GetRoleBindingResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_oidc_login(self, context: "grpc.ServicerContext") -> "GetOidcLoginResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_robot_token(
        self, robot: str, ttl: int, context: "grpc.ServicerContext"
    ) -> "GetRobotTokenResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def revoke_auth_token(
        self, token: str, context: "grpc.ServicerContext"
    ) -> "RevokeAuthTokenResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def revoke_auth_tokens_for_user(
        self, username: str, context: "grpc.ServicerContext"
    ) -> "RevokeAuthTokensForUserResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def set_groups_for_user(
        self,
        username: str,
        groups: Optional[List[str]],
        context: "grpc.ServicerContext",
    ) -> "SetGroupsForUserResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def modify_members(
        self,
        group: str,
        add: Optional[List[str]],
        remove: Optional[List[str]],
        context: "grpc.ServicerContext",
    ) -> "ModifyMembersResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_groups(self, context: "grpc.ServicerContext") -> "GetGroupsResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_groups_for_principal(
        self, principal: str, context: "grpc.ServicerContext"
    ) -> "GetGroupsResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_users(
        self, group: str, context: "grpc.ServicerContext"
    ) -> "GetUsersResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def extract_auth_tokens(
        self, context: "grpc.ServicerContext"
    ) -> "ExtractAuthTokensResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def restore_auth_token(
        self, token: "TokenInfo", context: "grpc.ServicerContext"
    ) -> "RestoreAuthTokenResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_expired_auth_tokens(
        self, context: "grpc.ServicerContext"
    ) -> "DeleteExpiredAuthTokensResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def rotate_root_token(
        self, root_token: str, context: "grpc.ServicerContext"
    ) -> "RotateRootTokenResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    __proto_path__ = "auth_v2.API"

    @property
    def __rpc_methods__(self):
        return {
            "Activate": grpc.unary_unary_rpc_method_handler(
                self.activate,
                request_deserializer=ActivateRequest.FromString,
                response_serializer=ActivateRequest.SerializeToString,
            ),
            "Deactivate": grpc.unary_unary_rpc_method_handler(
                self.deactivate,
                request_deserializer=DeactivateRequest.FromString,
                response_serializer=DeactivateRequest.SerializeToString,
            ),
            "GetConfiguration": grpc.unary_unary_rpc_method_handler(
                self.get_configuration,
                request_deserializer=GetConfigurationRequest.FromString,
                response_serializer=GetConfigurationRequest.SerializeToString,
            ),
            "SetConfiguration": grpc.unary_unary_rpc_method_handler(
                self.set_configuration,
                request_deserializer=SetConfigurationRequest.FromString,
                response_serializer=SetConfigurationRequest.SerializeToString,
            ),
            "Authenticate": grpc.unary_unary_rpc_method_handler(
                self.authenticate,
                request_deserializer=AuthenticateRequest.FromString,
                response_serializer=AuthenticateRequest.SerializeToString,
            ),
            "Authorize": grpc.unary_unary_rpc_method_handler(
                self.authorize,
                request_deserializer=AuthorizeRequest.FromString,
                response_serializer=AuthorizeRequest.SerializeToString,
            ),
            "GetPermissions": grpc.unary_unary_rpc_method_handler(
                self.get_permissions,
                request_deserializer=GetPermissionsRequest.FromString,
                response_serializer=GetPermissionsRequest.SerializeToString,
            ),
            "GetPermissionsForPrincipal": grpc.unary_unary_rpc_method_handler(
                self.get_permissions_for_principal,
                request_deserializer=GetPermissionsForPrincipalRequest.FromString,
                response_serializer=GetPermissionsForPrincipalRequest.SerializeToString,
            ),
            "WhoAmI": grpc.unary_unary_rpc_method_handler(
                self.who_am_i,
                request_deserializer=WhoAmIRequest.FromString,
                response_serializer=WhoAmIRequest.SerializeToString,
            ),
            "GetRolesForPermission": grpc.unary_unary_rpc_method_handler(
                self.get_roles_for_permission,
                request_deserializer=GetRolesForPermissionRequest.FromString,
                response_serializer=GetRolesForPermissionRequest.SerializeToString,
            ),
            "ModifyRoleBinding": grpc.unary_unary_rpc_method_handler(
                self.modify_role_binding,
                request_deserializer=ModifyRoleBindingRequest.FromString,
                response_serializer=ModifyRoleBindingRequest.SerializeToString,
            ),
            "GetRoleBinding": grpc.unary_unary_rpc_method_handler(
                self.get_role_binding,
                request_deserializer=GetRoleBindingRequest.FromString,
                response_serializer=GetRoleBindingRequest.SerializeToString,
            ),
            "GetOIDCLogin": grpc.unary_unary_rpc_method_handler(
                self.get_oidc_login,
                request_deserializer=GetOidcLoginRequest.FromString,
                response_serializer=GetOidcLoginRequest.SerializeToString,
            ),
            "GetRobotToken": grpc.unary_unary_rpc_method_handler(
                self.get_robot_token,
                request_deserializer=GetRobotTokenRequest.FromString,
                response_serializer=GetRobotTokenRequest.SerializeToString,
            ),
            "RevokeAuthToken": grpc.unary_unary_rpc_method_handler(
                self.revoke_auth_token,
                request_deserializer=RevokeAuthTokenRequest.FromString,
                response_serializer=RevokeAuthTokenRequest.SerializeToString,
            ),
            "RevokeAuthTokensForUser": grpc.unary_unary_rpc_method_handler(
                self.revoke_auth_tokens_for_user,
                request_deserializer=RevokeAuthTokensForUserRequest.FromString,
                response_serializer=RevokeAuthTokensForUserRequest.SerializeToString,
            ),
            "SetGroupsForUser": grpc.unary_unary_rpc_method_handler(
                self.set_groups_for_user,
                request_deserializer=SetGroupsForUserRequest.FromString,
                response_serializer=SetGroupsForUserRequest.SerializeToString,
            ),
            "ModifyMembers": grpc.unary_unary_rpc_method_handler(
                self.modify_members,
                request_deserializer=ModifyMembersRequest.FromString,
                response_serializer=ModifyMembersRequest.SerializeToString,
            ),
            "GetGroups": grpc.unary_unary_rpc_method_handler(
                self.get_groups,
                request_deserializer=GetGroupsRequest.FromString,
                response_serializer=GetGroupsRequest.SerializeToString,
            ),
            "GetGroupsForPrincipal": grpc.unary_unary_rpc_method_handler(
                self.get_groups_for_principal,
                request_deserializer=GetGroupsForPrincipalRequest.FromString,
                response_serializer=GetGroupsForPrincipalRequest.SerializeToString,
            ),
            "GetUsers": grpc.unary_unary_rpc_method_handler(
                self.get_users,
                request_deserializer=GetUsersRequest.FromString,
                response_serializer=GetUsersRequest.SerializeToString,
            ),
            "ExtractAuthTokens": grpc.unary_unary_rpc_method_handler(
                self.extract_auth_tokens,
                request_deserializer=ExtractAuthTokensRequest.FromString,
                response_serializer=ExtractAuthTokensRequest.SerializeToString,
            ),
            "RestoreAuthToken": grpc.unary_unary_rpc_method_handler(
                self.restore_auth_token,
                request_deserializer=RestoreAuthTokenRequest.FromString,
                response_serializer=RestoreAuthTokenRequest.SerializeToString,
            ),
            "DeleteExpiredAuthTokens": grpc.unary_unary_rpc_method_handler(
                self.delete_expired_auth_tokens,
                request_deserializer=DeleteExpiredAuthTokensRequest.FromString,
                response_serializer=DeleteExpiredAuthTokensRequest.SerializeToString,
            ),
            "RotateRootToken": grpc.unary_unary_rpc_method_handler(
                self.rotate_root_token,
                request_deserializer=RotateRootTokenRequest.FromString,
                response_serializer=RotateRootTokenRequest.SerializeToString,
            ),
        }
