# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: api/identity/identity.proto
# plugin: python-betterproto
# This file has been @generated
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpc


if TYPE_CHECKING:
    import grpc


@dataclass(eq=False, repr=False)
class User(betterproto.Message):
    """User represents an IDP user that has authenticated via OIDC"""

    email: str = betterproto.string_field(1)
    last_authenticated: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class IdentityServerConfig(betterproto.Message):
    """
    IdentityServerConfig is the configuration for the identity web server. When
    the configuration is changed the web server is reloaded automatically.
    """

    issuer: str = betterproto.string_field(1)
    id_token_expiry: str = betterproto.string_field(2)
    rotation_token_expiry: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class SetIdentityServerConfigRequest(betterproto.Message):
    config: "IdentityServerConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SetIdentityServerConfigResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetIdentityServerConfigRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetIdentityServerConfigResponse(betterproto.Message):
    config: "IdentityServerConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class IdpConnector(betterproto.Message):
    """IDPConnector represents a connection to an identity provider"""

    id: str = betterproto.string_field(1)
    """ID is the unique identifier for this connector."""

    name: str = betterproto.string_field(2)
    """
    Name is the human-readable identifier for this connector, which will be
    shown to end users when they're authenticating.
    """

    type: str = betterproto.string_field(3)
    """Type is the type of the IDP ex. `saml`, `oidc`, `github`."""

    config_version: int = betterproto.int64_field(4)
    """
    ConfigVersion must be incremented every time a connector is updated, to
    avoid concurrent updates conflicting.
    """

    json_config: str = betterproto.string_field(5)
    """
    This is left for backwards compatibility, but we want users to use the
    config defined below.
    """

    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(6)
    """
    Config is the configuration for the upstream IDP, which varies based on the
    type. We make the assumption that this is either yaml or JSON.
    """


@dataclass(eq=False, repr=False)
class CreateIdpConnectorRequest(betterproto.Message):
    connector: "IdpConnector" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateIdpConnectorResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdateIdpConnectorRequest(betterproto.Message):
    connector: "IdpConnector" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateIdpConnectorResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListIdpConnectorsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListIdpConnectorsResponse(betterproto.Message):
    connectors: List["IdpConnector"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetIdpConnectorRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetIdpConnectorResponse(betterproto.Message):
    connector: "IdpConnector" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteIdpConnectorRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DeleteIdpConnectorResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class OidcClient(betterproto.Message):
    id: str = betterproto.string_field(1)
    redirect_uris: List[str] = betterproto.string_field(2)
    trusted_peers: List[str] = betterproto.string_field(3)
    name: str = betterproto.string_field(4)
    secret: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class CreateOidcClientRequest(betterproto.Message):
    client: "OidcClient" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateOidcClientResponse(betterproto.Message):
    client: "OidcClient" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetOidcClientRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetOidcClientResponse(betterproto.Message):
    client: "OidcClient" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListOidcClientsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListOidcClientsResponse(betterproto.Message):
    clients: List["OidcClient"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateOidcClientRequest(betterproto.Message):
    client: "OidcClient" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateOidcClientResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteOidcClientRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DeleteOidcClientResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteAllRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteAllResponse(betterproto.Message):
    pass


class ApiStub:

    def __init__(self, channel: "grpc.Channel"):
        self.__rpc_set_identity_server_config = channel.unary_unary(
            "/identity_v2.API/SetIdentityServerConfig",
            request_serializer=SetIdentityServerConfigRequest.SerializeToString,
            response_deserializer=SetIdentityServerConfigResponse.FromString,
        )
        self.__rpc_get_identity_server_config = channel.unary_unary(
            "/identity_v2.API/GetIdentityServerConfig",
            request_serializer=GetIdentityServerConfigRequest.SerializeToString,
            response_deserializer=GetIdentityServerConfigResponse.FromString,
        )
        self.__rpc_create_idp_connector = channel.unary_unary(
            "/identity_v2.API/CreateIDPConnector",
            request_serializer=CreateIdpConnectorRequest.SerializeToString,
            response_deserializer=CreateIdpConnectorResponse.FromString,
        )
        self.__rpc_update_idp_connector = channel.unary_unary(
            "/identity_v2.API/UpdateIDPConnector",
            request_serializer=UpdateIdpConnectorRequest.SerializeToString,
            response_deserializer=UpdateIdpConnectorResponse.FromString,
        )
        self.__rpc_list_idp_connectors = channel.unary_unary(
            "/identity_v2.API/ListIDPConnectors",
            request_serializer=ListIdpConnectorsRequest.SerializeToString,
            response_deserializer=ListIdpConnectorsResponse.FromString,
        )
        self.__rpc_get_idp_connector = channel.unary_unary(
            "/identity_v2.API/GetIDPConnector",
            request_serializer=GetIdpConnectorRequest.SerializeToString,
            response_deserializer=GetIdpConnectorResponse.FromString,
        )
        self.__rpc_delete_idp_connector = channel.unary_unary(
            "/identity_v2.API/DeleteIDPConnector",
            request_serializer=DeleteIdpConnectorRequest.SerializeToString,
            response_deserializer=DeleteIdpConnectorResponse.FromString,
        )
        self.__rpc_create_oidc_client = channel.unary_unary(
            "/identity_v2.API/CreateOIDCClient",
            request_serializer=CreateOidcClientRequest.SerializeToString,
            response_deserializer=CreateOidcClientResponse.FromString,
        )
        self.__rpc_update_oidc_client = channel.unary_unary(
            "/identity_v2.API/UpdateOIDCClient",
            request_serializer=UpdateOidcClientRequest.SerializeToString,
            response_deserializer=UpdateOidcClientResponse.FromString,
        )
        self.__rpc_get_oidc_client = channel.unary_unary(
            "/identity_v2.API/GetOIDCClient",
            request_serializer=GetOidcClientRequest.SerializeToString,
            response_deserializer=GetOidcClientResponse.FromString,
        )
        self.__rpc_list_oidc_clients = channel.unary_unary(
            "/identity_v2.API/ListOIDCClients",
            request_serializer=ListOidcClientsRequest.SerializeToString,
            response_deserializer=ListOidcClientsResponse.FromString,
        )
        self.__rpc_delete_oidc_client = channel.unary_unary(
            "/identity_v2.API/DeleteOIDCClient",
            request_serializer=DeleteOidcClientRequest.SerializeToString,
            response_deserializer=DeleteOidcClientResponse.FromString,
        )
        self.__rpc_delete_all = channel.unary_unary(
            "/identity_v2.API/DeleteAll",
            request_serializer=DeleteAllRequest.SerializeToString,
            response_deserializer=DeleteAllResponse.FromString,
        )

    def set_identity_server_config(
        self, *, config: "IdentityServerConfig" = None
    ) -> "SetIdentityServerConfigResponse":

        request = SetIdentityServerConfigRequest()
        if config is not None:
            request.config = config

        return self.__rpc_set_identity_server_config(request)

    def get_identity_server_config(self) -> "GetIdentityServerConfigResponse":

        request = GetIdentityServerConfigRequest()

        return self.__rpc_get_identity_server_config(request)

    def create_idp_connector(
        self, *, connector: "IdpConnector" = None
    ) -> "CreateIdpConnectorResponse":

        request = CreateIdpConnectorRequest()
        if connector is not None:
            request.connector = connector

        return self.__rpc_create_idp_connector(request)

    def update_idp_connector(
        self, *, connector: "IdpConnector" = None
    ) -> "UpdateIdpConnectorResponse":

        request = UpdateIdpConnectorRequest()
        if connector is not None:
            request.connector = connector

        return self.__rpc_update_idp_connector(request)

    def list_idp_connectors(self) -> "ListIdpConnectorsResponse":

        request = ListIdpConnectorsRequest()

        return self.__rpc_list_idp_connectors(request)

    def get_idp_connector(self, *, id: str = "") -> "GetIdpConnectorResponse":

        request = GetIdpConnectorRequest()
        request.id = id

        return self.__rpc_get_idp_connector(request)

    def delete_idp_connector(self, *, id: str = "") -> "DeleteIdpConnectorResponse":

        request = DeleteIdpConnectorRequest()
        request.id = id

        return self.__rpc_delete_idp_connector(request)

    def create_oidc_client(
        self, *, client: "OidcClient" = None
    ) -> "CreateOidcClientResponse":

        request = CreateOidcClientRequest()
        if client is not None:
            request.client = client

        return self.__rpc_create_oidc_client(request)

    def update_oidc_client(
        self, *, client: "OidcClient" = None
    ) -> "UpdateOidcClientResponse":

        request = UpdateOidcClientRequest()
        if client is not None:
            request.client = client

        return self.__rpc_update_oidc_client(request)

    def get_oidc_client(self, *, id: str = "") -> "GetOidcClientResponse":

        request = GetOidcClientRequest()
        request.id = id

        return self.__rpc_get_oidc_client(request)

    def list_oidc_clients(self) -> "ListOidcClientsResponse":

        request = ListOidcClientsRequest()

        return self.__rpc_list_oidc_clients(request)

    def delete_oidc_client(self, *, id: str = "") -> "DeleteOidcClientResponse":

        request = DeleteOidcClientRequest()
        request.id = id

        return self.__rpc_delete_oidc_client(request)

    def delete_all(self) -> "DeleteAllResponse":

        request = DeleteAllRequest()

        return self.__rpc_delete_all(request)


class ApiBase:

    def set_identity_server_config(
        self, config: "IdentityServerConfig", context: "grpc.ServicerContext"
    ) -> "SetIdentityServerConfigResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_identity_server_config(
        self, context: "grpc.ServicerContext"
    ) -> "GetIdentityServerConfigResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def create_idp_connector(
        self, connector: "IdpConnector", context: "grpc.ServicerContext"
    ) -> "CreateIdpConnectorResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def update_idp_connector(
        self, connector: "IdpConnector", context: "grpc.ServicerContext"
    ) -> "UpdateIdpConnectorResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_idp_connectors(
        self, context: "grpc.ServicerContext"
    ) -> "ListIdpConnectorsResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_idp_connector(
        self, id: str, context: "grpc.ServicerContext"
    ) -> "GetIdpConnectorResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_idp_connector(
        self, id: str, context: "grpc.ServicerContext"
    ) -> "DeleteIdpConnectorResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def create_oidc_client(
        self, client: "OidcClient", context: "grpc.ServicerContext"
    ) -> "CreateOidcClientResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def update_oidc_client(
        self, client: "OidcClient", context: "grpc.ServicerContext"
    ) -> "UpdateOidcClientResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_oidc_client(
        self, id: str, context: "grpc.ServicerContext"
    ) -> "GetOidcClientResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_oidc_clients(
        self, context: "grpc.ServicerContext"
    ) -> "ListOidcClientsResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_oidc_client(
        self, id: str, context: "grpc.ServicerContext"
    ) -> "DeleteOidcClientResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_all(self, context: "grpc.ServicerContext") -> "DeleteAllResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    __proto_path__ = "identity_v2.API"

    @property
    def __rpc_methods__(self):
        return {
            "SetIdentityServerConfig": grpc.unary_unary_rpc_method_handler(
                self.set_identity_server_config,
                request_deserializer=SetIdentityServerConfigRequest.FromString,
                response_serializer=SetIdentityServerConfigRequest.SerializeToString,
            ),
            "GetIdentityServerConfig": grpc.unary_unary_rpc_method_handler(
                self.get_identity_server_config,
                request_deserializer=GetIdentityServerConfigRequest.FromString,
                response_serializer=GetIdentityServerConfigRequest.SerializeToString,
            ),
            "CreateIDPConnector": grpc.unary_unary_rpc_method_handler(
                self.create_idp_connector,
                request_deserializer=CreateIdpConnectorRequest.FromString,
                response_serializer=CreateIdpConnectorRequest.SerializeToString,
            ),
            "UpdateIDPConnector": grpc.unary_unary_rpc_method_handler(
                self.update_idp_connector,
                request_deserializer=UpdateIdpConnectorRequest.FromString,
                response_serializer=UpdateIdpConnectorRequest.SerializeToString,
            ),
            "ListIDPConnectors": grpc.unary_unary_rpc_method_handler(
                self.list_idp_connectors,
                request_deserializer=ListIdpConnectorsRequest.FromString,
                response_serializer=ListIdpConnectorsRequest.SerializeToString,
            ),
            "GetIDPConnector": grpc.unary_unary_rpc_method_handler(
                self.get_idp_connector,
                request_deserializer=GetIdpConnectorRequest.FromString,
                response_serializer=GetIdpConnectorRequest.SerializeToString,
            ),
            "DeleteIDPConnector": grpc.unary_unary_rpc_method_handler(
                self.delete_idp_connector,
                request_deserializer=DeleteIdpConnectorRequest.FromString,
                response_serializer=DeleteIdpConnectorRequest.SerializeToString,
            ),
            "CreateOIDCClient": grpc.unary_unary_rpc_method_handler(
                self.create_oidc_client,
                request_deserializer=CreateOidcClientRequest.FromString,
                response_serializer=CreateOidcClientRequest.SerializeToString,
            ),
            "UpdateOIDCClient": grpc.unary_unary_rpc_method_handler(
                self.update_oidc_client,
                request_deserializer=UpdateOidcClientRequest.FromString,
                response_serializer=UpdateOidcClientRequest.SerializeToString,
            ),
            "GetOIDCClient": grpc.unary_unary_rpc_method_handler(
                self.get_oidc_client,
                request_deserializer=GetOidcClientRequest.FromString,
                response_serializer=GetOidcClientRequest.SerializeToString,
            ),
            "ListOIDCClients": grpc.unary_unary_rpc_method_handler(
                self.list_oidc_clients,
                request_deserializer=ListOidcClientsRequest.FromString,
                response_serializer=ListOidcClientsRequest.SerializeToString,
            ),
            "DeleteOIDCClient": grpc.unary_unary_rpc_method_handler(
                self.delete_oidc_client,
                request_deserializer=DeleteOidcClientRequest.FromString,
                response_serializer=DeleteOidcClientRequest.SerializeToString,
            ),
            "DeleteAll": grpc.unary_unary_rpc_method_handler(
                self.delete_all,
                request_deserializer=DeleteAllRequest.FromString,
                response_serializer=DeleteAllRequest.SerializeToString,
            ),
        }
