# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: api/pfs/pfs.proto
# plugin: python-betterproto
# This file has been @generated
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    Iterator,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpc

from .. import (
    auth as _auth__,
    taskapi as _taskapi__,
)


if TYPE_CHECKING:
    import grpc


class OriginKind(betterproto.Enum):
    """These are the different places where a commit may be originated from"""

    ORIGIN_KIND_UNKNOWN = 0
    USER = 1
    AUTO = 2
    FSCK = 3


class FileType(betterproto.Enum):
    RESERVED = 0
    FILE = 1
    DIR = 2


class CommitState(betterproto.Enum):
    """
    CommitState describes the states a commit can be in. The states are
    increasingly specific, i.e. a commit that is FINISHED also counts as
    STARTED.
    """

    COMMIT_STATE_UNKNOWN = 0
    STARTED = 1
    READY = 2
    FINISHING = 3
    FINISHED = 4


class Delimiter(betterproto.Enum):
    NONE = 0
    JSON = 1
    LINE = 2
    SQL = 3
    CSV = 4


class RepoPageOrdering(betterproto.Enum):
    PROJECT_REPO = 0


class GetFileSetRequestFileSetType(betterproto.Enum):
    TOTAL = 0
    DIFF = 1


class SqlDatabaseEgressFileFormatType(betterproto.Enum):
    UNKNOWN = 0
    CSV = 1
    JSON = 2
    PARQUET = 3


@dataclass(eq=False, repr=False)
class Repo(betterproto.Message):
    name: str = betterproto.string_field(1)
    type: str = betterproto.string_field(2)
    project: "Project" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Branch(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class File(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    path: str = betterproto.string_field(2)
    datum: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class RepoInfo(betterproto.Message):
    """RepoInfo is the main data structure representing a Repo in etcd"""

    repo: "Repo" = betterproto.message_field(1)
    created: datetime = betterproto.message_field(2)
    size_bytes_upper_bound: int = betterproto.int64_field(3)
    description: str = betterproto.string_field(4)
    branches: List["Branch"] = betterproto.message_field(5)
    auth_info: "AuthInfo" = betterproto.message_field(6)
    """
    Set by ListRepo and InspectRepo if Pachyderm's auth system is active, but
    not stored in etcd. To set a user's auth scope for a repo, use the
    Pachyderm Auth API (in src/client/auth/auth.proto)
    """

    details: "RepoInfoDetails" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class RepoInfoDetails(betterproto.Message):
    """Details are only provided when explicitly requested"""

    size_bytes: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class AuthInfo(betterproto.Message):
    """
    AuthInfo includes the caller's access scope for a resource, and is returned
    by services like ListRepo, InspectRepo, and ListProject, but is not
    persisted in the database. It's used by the Pachyderm dashboard to render
    repo access appropriately. To set a user's auth scope for a resource, use
    the Pachyderm Auth API (in src/auth/auth.proto)
    """

    permissions: List["_auth__.Permission"] = betterproto.enum_field(1)
    """
    The callers access level to the relevant resource. These are very granular
    permissions - for the end user it makes sense to show them the roles they
    have instead.
    """

    roles: List[str] = betterproto.string_field(2)
    """
    The caller's roles on the relevant resource. This includes inherited roles
    from the cluster, project, group membership, etc.
    """


@dataclass(eq=False, repr=False)
class BranchInfo(betterproto.Message):
    branch: "Branch" = betterproto.message_field(1)
    head: "Commit" = betterproto.message_field(2)
    provenance: List["Branch"] = betterproto.message_field(3)
    subvenance: List["Branch"] = betterproto.message_field(4)
    direct_provenance: List["Branch"] = betterproto.message_field(5)
    trigger: "Trigger" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class Trigger(betterproto.Message):
    """
    Trigger defines the conditions under which a head is moved, and to which
    branch it is moved.
    """

    branch: str = betterproto.string_field(1)
    """Which branch this trigger refers to"""

    all: bool = betterproto.bool_field(2)
    """
    All indicates that all conditions must be satisfied before the trigger
    happens, otherwise any conditions being satisfied will trigger it.
    """

    rate_limit_spec: str = betterproto.string_field(3)
    """
    Triggers if the rate limit spec (cron expression) has been satisfied since
    the last trigger.
    """

    size: str = betterproto.string_field(4)
    """
    Triggers if there's been `size` new data added since the last trigger.
    """

    commits: int = betterproto.int64_field(5)
    """
    Triggers if there's been `commits` new commits added since the last
    trigger.
    """

    cron_spec: str = betterproto.string_field(6)
    """
    Creates a background process which fires the trigger on the schedule
    provided by the cron spec. This condition is mutually exclusive with
    respect to the others, so setting this will result with the trigger only
    firing based on the cron schedule.
    """


@dataclass(eq=False, repr=False)
class CommitOrigin(betterproto.Message):
    kind: "OriginKind" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class Commit(betterproto.Message):
    """
    Commit is a reference to a commit (e.g. the collection of branches and the
    collection of currently-open commits in etcd are collections of Commit
    protos)
    """

    repo: "Repo" = betterproto.message_field(3)
    id: str = betterproto.string_field(2)
    branch: "Branch" = betterproto.message_field(1)
    """only used by the client"""


@dataclass(eq=False, repr=False)
class CommitInfo(betterproto.Message):
    """CommitInfo is the main data structure representing a commit in etcd"""

    commit: "Commit" = betterproto.message_field(1)
    origin: "CommitOrigin" = betterproto.message_field(2)
    description: str = betterproto.string_field(3)
    """description is a user-provided script describing this commit"""

    parent_commit: "Commit" = betterproto.message_field(4)
    child_commits: List["Commit"] = betterproto.message_field(5)
    started: datetime = betterproto.message_field(6)
    finishing: datetime = betterproto.message_field(7)
    finished: datetime = betterproto.message_field(8)
    direct_provenance: List["Commit"] = betterproto.message_field(13)
    error: str = betterproto.string_field(10)
    size_bytes_upper_bound: int = betterproto.int64_field(11)
    details: "CommitInfoDetails" = betterproto.message_field(12)


@dataclass(eq=False, repr=False)
class CommitInfoDetails(betterproto.Message):
    """Details are only provided when explicitly requested"""

    size_bytes: int = betterproto.int64_field(1)
    compacting_time: timedelta = betterproto.message_field(2)
    validating_time: timedelta = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class CommitSet(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CommitSetInfo(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)
    commits: List["CommitInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class FileInfo(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    file_type: "FileType" = betterproto.enum_field(2)
    committed: datetime = betterproto.message_field(3)
    size_bytes: int = betterproto.int64_field(4)
    hash: bytes = betterproto.bytes_field(5)


@dataclass(eq=False, repr=False)
class Project(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ProjectInfo(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)
    auth_info: "AuthInfo" = betterproto.message_field(3)
    created_at: datetime = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class CreateRepoRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)
    update: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class InspectRepoRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListRepoRequest(betterproto.Message):
    type: str = betterproto.string_field(1)
    """
    Type is the type of (system) repo that should be returned. An empty string
    requests all repos.
    """

    projects: List["Project"] = betterproto.message_field(2)
    """
    Filters out repos whos project isn't represented. An empty list of projects
    doesn't filter repos by their project.
    """

    page: "RepoPage" = betterproto.message_field(3)
    """
    Specifies which page of repos should be returned. If page isn't specified,
    a single page containing all the relevant repos is returned.
    """


@dataclass(eq=False, repr=False)
class RepoPage(betterproto.Message):
    order: "RepoPageOrdering" = betterproto.enum_field(1)
    page_size: int = betterproto.int64_field(2)
    page_index: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class DeleteRepoRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class DeleteReposRequest(betterproto.Message):
    """DeleteReposRequest is used to delete more than one repo at once."""

    projects: List["Project"] = betterproto.message_field(1)
    """
    All repos in each project will be deleted if the caller has permission.
    """

    force: bool = betterproto.bool_field(2)
    all: bool = betterproto.bool_field(3)
    """
    If all is set, then all repos in all projects will be deleted if the caller
    has permission.
    """


@dataclass(eq=False, repr=False)
class DeleteRepoResponse(betterproto.Message):
    """
    DeleteRepoResponse returns the repos that were deleted by a DeleteRepo
    call.
    """

    deleted: bool = betterproto.bool_field(1)
    """The repos that were deleted, perhaps none."""


@dataclass(eq=False, repr=False)
class DeleteReposResponse(betterproto.Message):
    repos: List["Repo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class StartCommitRequest(betterproto.Message):
    parent: "Commit" = betterproto.message_field(1)
    """
    parent may be empty in which case the commit that Branch points to will be
    used as the parent. If the branch does not exist, the commit will have no
    parent.
    """

    description: str = betterproto.string_field(2)
    """description is a user-provided string describing this commit"""

    branch: "Branch" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class FinishCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)
    """
    description is a user-provided string describing this commit. Setting this
    will overwrite the description set in StartCommit
    """

    error: str = betterproto.string_field(3)
    force: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class InspectCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    wait: "CommitState" = betterproto.enum_field(2)
    """
    Wait causes inspect commit to wait until the commit is in the desired
    state.
    """


@dataclass(eq=False, repr=False)
class ListCommitRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    from_: "Commit" = betterproto.message_field(2)
    to: "Commit" = betterproto.message_field(3)
    number: int = betterproto.int64_field(4)
    reverse: bool = betterproto.bool_field(5)
    all: bool = betterproto.bool_field(6)
    origin_kind: "OriginKind" = betterproto.enum_field(7)
    started_time: datetime = betterproto.message_field(8)


@dataclass(eq=False, repr=False)
class InspectCommitSetRequest(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)
    wait: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class ListCommitSetRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SquashCommitSetRequest(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DropCommitSetRequest(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SubscribeCommitRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    branch: str = betterproto.string_field(2)
    from_: "Commit" = betterproto.message_field(3)
    """only commits created since this commit are returned"""

    state: "CommitState" = betterproto.enum_field(4)
    """Don't return commits until they're in (at least) the desired state."""

    all: bool = betterproto.bool_field(5)
    origin_kind: "OriginKind" = betterproto.enum_field(6)


@dataclass(eq=False, repr=False)
class ClearCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SquashCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    recursive: bool = betterproto.bool_field(2)
    """
    Setting recursive to true indicates that the squash should be applied
    recursively to subvenant commits. If recursive is set to false and the
    provided commit has subvenant commits, the squash will fail.
    """


@dataclass(eq=False, repr=False)
class SquashCommitResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DropCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    recursive: bool = betterproto.bool_field(2)
    """
    Setting recursive to true indicates that the drop should be applied
    recursively to subvenant commits. If recursive is set to false and the
    provided commit has subvenant commits, the drop will fail.
    """


@dataclass(eq=False, repr=False)
class DropCommitResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CreateBranchRequest(betterproto.Message):
    head: "Commit" = betterproto.message_field(1)
    branch: "Branch" = betterproto.message_field(2)
    provenance: List["Branch"] = betterproto.message_field(3)
    trigger: "Trigger" = betterproto.message_field(4)
    new_commit_set: bool = betterproto.bool_field(5)


@dataclass(eq=False, repr=False)
class FindCommitsRequest(betterproto.Message):
    start: "Commit" = betterproto.message_field(1)
    file_path: str = betterproto.string_field(2)
    limit: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class FindCommitsResponse(betterproto.Message):
    found_commit: "Commit" = betterproto.message_field(1, group="result")
    last_searched_commit: "Commit" = betterproto.message_field(2, group="result")
    commits_searched: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class InspectBranchRequest(betterproto.Message):
    branch: "Branch" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListBranchRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    reverse: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class DeleteBranchRequest(betterproto.Message):
    branch: "Branch" = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class CreateProjectRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)
    update: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class InspectProjectRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class InspectProjectV2Request(betterproto.Message):
    project: "Project" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class InspectProjectV2Response(betterproto.Message):
    info: "ProjectInfo" = betterproto.message_field(1)
    defaults_json: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ListProjectRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteProjectRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class AddFile(betterproto.Message):
    path: str = betterproto.string_field(1)
    datum: str = betterproto.string_field(2)
    raw: Optional[bytes] = betterproto.message_field(
        3, wraps=betterproto.TYPE_BYTES, group="source"
    )
    url: "AddFileUrlSource" = betterproto.message_field(4, group="source")


@dataclass(eq=False, repr=False)
class AddFileUrlSource(betterproto.Message):
    url: str = betterproto.string_field(1)
    recursive: bool = betterproto.bool_field(2)
    concurrency: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class DeleteFile(betterproto.Message):
    path: str = betterproto.string_field(1)
    datum: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CopyFile(betterproto.Message):
    dst: str = betterproto.string_field(1)
    datum: str = betterproto.string_field(2)
    src: "File" = betterproto.message_field(3)
    append: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class ModifyFileRequest(betterproto.Message):
    set_commit: "Commit" = betterproto.message_field(1, group="body")
    add_file: "AddFile" = betterproto.message_field(2, group="body")
    delete_file: "DeleteFile" = betterproto.message_field(3, group="body")
    copy_file: "CopyFile" = betterproto.message_field(4, group="body")


@dataclass(eq=False, repr=False)
class GetFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    url: str = betterproto.string_field(2)
    offset: int = betterproto.int64_field(3)
    path_range: "PathRange" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class InspectFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    """
    File is the parent directory of the files we want to list. This sets the
    repo, the commit/branch, and path prefix of files we're interested in If
    the "path" field is omitted, a list of files at the top level of the repo
    is returned
    """

    pagination_marker: "File" = betterproto.message_field(3)
    """
    Marker for pagination. If set, the files that come after the marker in
    lexicographical order will be returned. If reverse is also set, the files
    that come before the marker in lexicographical order will be returned.
    """

    number: int = betterproto.int64_field(4)
    """Number of files to return"""

    reverse: bool = betterproto.bool_field(5)
    """If true, return files in reverse order"""


@dataclass(eq=False, repr=False)
class WalkFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    pagination_marker: "File" = betterproto.message_field(2)
    """
    Marker for pagination. If set, the files that come after the marker in
    lexicographical order will be returned. If reverse is also set, the files
    that come before the marker in lexicographical order will be returned.
    """

    number: int = betterproto.int64_field(3)
    """Number of files to return"""

    reverse: bool = betterproto.bool_field(4)
    """If true, return files in reverse order"""


@dataclass(eq=False, repr=False)
class GlobFileRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    pattern: str = betterproto.string_field(2)
    path_range: "PathRange" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class DiffFileRequest(betterproto.Message):
    new_file: "File" = betterproto.message_field(1)
    old_file: "File" = betterproto.message_field(2)
    """
    OldFile may be left nil in which case the same path in the parent of
    NewFile's commit will be used.
    """

    shallow: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class DiffFileResponse(betterproto.Message):
    new_file: "FileInfo" = betterproto.message_field(1)
    old_file: "FileInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class FsckRequest(betterproto.Message):
    fix: bool = betterproto.bool_field(1)
    zombie_target: "Commit" = betterproto.message_field(2, group="zombie_check")
    zombie_all: bool = betterproto.bool_field(3, group="zombie_check")
    """run zombie data detection against all pipelines"""


@dataclass(eq=False, repr=False)
class FsckResponse(betterproto.Message):
    fix: str = betterproto.string_field(1)
    error: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CreateFileSetResponse(betterproto.Message):
    file_set_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetFileSetRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    type: "GetFileSetRequestFileSetType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class AddFileSetRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    file_set_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RenewFileSetRequest(betterproto.Message):
    file_set_id: str = betterproto.string_field(1)
    ttl_seconds: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class ComposeFileSetRequest(betterproto.Message):
    file_set_ids: List[str] = betterproto.string_field(1)
    ttl_seconds: int = betterproto.int64_field(2)
    compact: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ShardFileSetRequest(betterproto.Message):
    """
    If both num_files and size_bytes are set, shards are created based on
    whichever threshold is surpassed first. If a shard configuration field
    (num_files, size_bytes) is unset, the storage's default value is used.
    """

    file_set_id: str = betterproto.string_field(1)
    num_files: int = betterproto.int64_field(2)
    size_bytes: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class PathRange(betterproto.Message):
    lower: str = betterproto.string_field(1)
    upper: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ShardFileSetResponse(betterproto.Message):
    shards: List["PathRange"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CheckStorageRequest(betterproto.Message):
    read_chunk_data: bool = betterproto.bool_field(1)
    chunk_begin: bytes = betterproto.bytes_field(2)
    chunk_end: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class CheckStorageResponse(betterproto.Message):
    chunk_object_count: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class PutCacheRequest(betterproto.Message):
    key: str = betterproto.string_field(1)
    value: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    file_set_ids: List[str] = betterproto.string_field(3)
    tag: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class GetCacheRequest(betterproto.Message):
    key: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetCacheResponse(betterproto.Message):
    value: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ClearCacheRequest(betterproto.Message):
    tag_prefix: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ActivateAuthRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ActivateAuthResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ObjectStorageEgress(betterproto.Message):
    url: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class SqlDatabaseEgress(betterproto.Message):
    url: str = betterproto.string_field(1)
    file_format: "SqlDatabaseEgressFileFormat" = betterproto.message_field(2)
    secret: "SqlDatabaseEgressSecret" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class SqlDatabaseEgressFileFormat(betterproto.Message):
    type: "SqlDatabaseEgressFileFormatType" = betterproto.enum_field(1)
    columns: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SqlDatabaseEgressSecret(betterproto.Message):
    name: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class EgressRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    object_storage: "ObjectStorageEgress" = betterproto.message_field(2, group="target")
    sql_database: "SqlDatabaseEgress" = betterproto.message_field(3, group="target")


@dataclass(eq=False, repr=False)
class EgressResponse(betterproto.Message):
    object_storage: "EgressResponseObjectStorageResult" = betterproto.message_field(
        1, group="result"
    )
    sql_database: "EgressResponseSqlDatabaseResult" = betterproto.message_field(
        2, group="result"
    )


@dataclass(eq=False, repr=False)
class EgressResponseObjectStorageResult(betterproto.Message):
    bytes_written: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class EgressResponseSqlDatabaseResult(betterproto.Message):
    rows_written: Dict[str, int] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_INT64
    )


class ApiStub:

    def __init__(self, channel: "grpc.Channel"):
        self.__rpc_create_repo = channel.unary_unary(
            "/pfs_v2.API/CreateRepo",
            request_serializer=CreateRepoRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_inspect_repo = channel.unary_unary(
            "/pfs_v2.API/InspectRepo",
            request_serializer=InspectRepoRequest.SerializeToString,
            response_deserializer=RepoInfo.FromString,
        )
        self.__rpc_list_repo = channel.unary_stream(
            "/pfs_v2.API/ListRepo",
            request_serializer=ListRepoRequest.SerializeToString,
            response_deserializer=RepoInfo.FromString,
        )
        self.__rpc_delete_repo = channel.unary_unary(
            "/pfs_v2.API/DeleteRepo",
            request_serializer=DeleteRepoRequest.SerializeToString,
            response_deserializer=DeleteRepoResponse.FromString,
        )
        self.__rpc_delete_repos = channel.unary_unary(
            "/pfs_v2.API/DeleteRepos",
            request_serializer=DeleteReposRequest.SerializeToString,
            response_deserializer=DeleteReposResponse.FromString,
        )
        self.__rpc_start_commit = channel.unary_unary(
            "/pfs_v2.API/StartCommit",
            request_serializer=StartCommitRequest.SerializeToString,
            response_deserializer=Commit.FromString,
        )
        self.__rpc_finish_commit = channel.unary_unary(
            "/pfs_v2.API/FinishCommit",
            request_serializer=FinishCommitRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_clear_commit = channel.unary_unary(
            "/pfs_v2.API/ClearCommit",
            request_serializer=ClearCommitRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_inspect_commit = channel.unary_unary(
            "/pfs_v2.API/InspectCommit",
            request_serializer=InspectCommitRequest.SerializeToString,
            response_deserializer=CommitInfo.FromString,
        )
        self.__rpc_list_commit = channel.unary_stream(
            "/pfs_v2.API/ListCommit",
            request_serializer=ListCommitRequest.SerializeToString,
            response_deserializer=CommitInfo.FromString,
        )
        self.__rpc_subscribe_commit = channel.unary_stream(
            "/pfs_v2.API/SubscribeCommit",
            request_serializer=SubscribeCommitRequest.SerializeToString,
            response_deserializer=CommitInfo.FromString,
        )
        self.__rpc_squash_commit = channel.unary_unary(
            "/pfs_v2.API/SquashCommit",
            request_serializer=SquashCommitRequest.SerializeToString,
            response_deserializer=SquashCommitResponse.FromString,
        )
        self.__rpc_drop_commit = channel.unary_unary(
            "/pfs_v2.API/DropCommit",
            request_serializer=DropCommitRequest.SerializeToString,
            response_deserializer=DropCommitResponse.FromString,
        )
        self.__rpc_inspect_commit_set = channel.unary_stream(
            "/pfs_v2.API/InspectCommitSet",
            request_serializer=InspectCommitSetRequest.SerializeToString,
            response_deserializer=CommitInfo.FromString,
        )
        self.__rpc_list_commit_set = channel.unary_stream(
            "/pfs_v2.API/ListCommitSet",
            request_serializer=ListCommitSetRequest.SerializeToString,
            response_deserializer=CommitSetInfo.FromString,
        )
        self.__rpc_squash_commit_set = channel.unary_unary(
            "/pfs_v2.API/SquashCommitSet",
            request_serializer=SquashCommitSetRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_drop_commit_set = channel.unary_unary(
            "/pfs_v2.API/DropCommitSet",
            request_serializer=DropCommitSetRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_find_commits = channel.unary_stream(
            "/pfs_v2.API/FindCommits",
            request_serializer=FindCommitsRequest.SerializeToString,
            response_deserializer=FindCommitsResponse.FromString,
        )
        self.__rpc_create_branch = channel.unary_unary(
            "/pfs_v2.API/CreateBranch",
            request_serializer=CreateBranchRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_inspect_branch = channel.unary_unary(
            "/pfs_v2.API/InspectBranch",
            request_serializer=InspectBranchRequest.SerializeToString,
            response_deserializer=BranchInfo.FromString,
        )
        self.__rpc_list_branch = channel.unary_stream(
            "/pfs_v2.API/ListBranch",
            request_serializer=ListBranchRequest.SerializeToString,
            response_deserializer=BranchInfo.FromString,
        )
        self.__rpc_delete_branch = channel.unary_unary(
            "/pfs_v2.API/DeleteBranch",
            request_serializer=DeleteBranchRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_modify_file = channel.stream_unary(
            "/pfs_v2.API/ModifyFile",
            request_serializer=ModifyFileRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_get_file = channel.unary_stream(
            "/pfs_v2.API/GetFile",
            request_serializer=GetFileRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.BytesValue.FromString,
        )
        self.__rpc_get_file_tar = channel.unary_stream(
            "/pfs_v2.API/GetFileTAR",
            request_serializer=GetFileRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.BytesValue.FromString,
        )
        self.__rpc_inspect_file = channel.unary_unary(
            "/pfs_v2.API/InspectFile",
            request_serializer=InspectFileRequest.SerializeToString,
            response_deserializer=FileInfo.FromString,
        )
        self.__rpc_list_file = channel.unary_stream(
            "/pfs_v2.API/ListFile",
            request_serializer=ListFileRequest.SerializeToString,
            response_deserializer=FileInfo.FromString,
        )
        self.__rpc_walk_file = channel.unary_stream(
            "/pfs_v2.API/WalkFile",
            request_serializer=WalkFileRequest.SerializeToString,
            response_deserializer=FileInfo.FromString,
        )
        self.__rpc_glob_file = channel.unary_stream(
            "/pfs_v2.API/GlobFile",
            request_serializer=GlobFileRequest.SerializeToString,
            response_deserializer=FileInfo.FromString,
        )
        self.__rpc_diff_file = channel.unary_stream(
            "/pfs_v2.API/DiffFile",
            request_serializer=DiffFileRequest.SerializeToString,
            response_deserializer=DiffFileResponse.FromString,
        )
        self.__rpc_activate_auth = channel.unary_unary(
            "/pfs_v2.API/ActivateAuth",
            request_serializer=ActivateAuthRequest.SerializeToString,
            response_deserializer=ActivateAuthResponse.FromString,
        )
        self.__rpc_delete_all = channel.unary_unary(
            "/pfs_v2.API/DeleteAll",
            request_serializer=betterproto_lib_google_protobuf.Empty.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_fsck = channel.unary_stream(
            "/pfs_v2.API/Fsck",
            request_serializer=FsckRequest.SerializeToString,
            response_deserializer=FsckResponse.FromString,
        )
        self.__rpc_create_file_set = channel.stream_unary(
            "/pfs_v2.API/CreateFileSet",
            request_serializer=ModifyFileRequest.SerializeToString,
            response_deserializer=CreateFileSetResponse.FromString,
        )
        self.__rpc_get_file_set = channel.unary_unary(
            "/pfs_v2.API/GetFileSet",
            request_serializer=GetFileSetRequest.SerializeToString,
            response_deserializer=CreateFileSetResponse.FromString,
        )
        self.__rpc_add_file_set = channel.unary_unary(
            "/pfs_v2.API/AddFileSet",
            request_serializer=AddFileSetRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_renew_file_set = channel.unary_unary(
            "/pfs_v2.API/RenewFileSet",
            request_serializer=RenewFileSetRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_compose_file_set = channel.unary_unary(
            "/pfs_v2.API/ComposeFileSet",
            request_serializer=ComposeFileSetRequest.SerializeToString,
            response_deserializer=CreateFileSetResponse.FromString,
        )
        self.__rpc_shard_file_set = channel.unary_unary(
            "/pfs_v2.API/ShardFileSet",
            request_serializer=ShardFileSetRequest.SerializeToString,
            response_deserializer=ShardFileSetResponse.FromString,
        )
        self.__rpc_check_storage = channel.unary_unary(
            "/pfs_v2.API/CheckStorage",
            request_serializer=CheckStorageRequest.SerializeToString,
            response_deserializer=CheckStorageResponse.FromString,
        )
        self.__rpc_put_cache = channel.unary_unary(
            "/pfs_v2.API/PutCache",
            request_serializer=PutCacheRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_get_cache = channel.unary_unary(
            "/pfs_v2.API/GetCache",
            request_serializer=GetCacheRequest.SerializeToString,
            response_deserializer=GetCacheResponse.FromString,
        )
        self.__rpc_clear_cache = channel.unary_unary(
            "/pfs_v2.API/ClearCache",
            request_serializer=ClearCacheRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_list_task = channel.unary_stream(
            "/pfs_v2.API/ListTask",
            request_serializer=_taskapi__.ListTaskRequest.SerializeToString,
            response_deserializer=_taskapi__.TaskInfo.FromString,
        )
        self.__rpc_egress = channel.unary_unary(
            "/pfs_v2.API/Egress",
            request_serializer=EgressRequest.SerializeToString,
            response_deserializer=EgressResponse.FromString,
        )
        self.__rpc_create_project = channel.unary_unary(
            "/pfs_v2.API/CreateProject",
            request_serializer=CreateProjectRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )
        self.__rpc_inspect_project = channel.unary_unary(
            "/pfs_v2.API/InspectProject",
            request_serializer=InspectProjectRequest.SerializeToString,
            response_deserializer=ProjectInfo.FromString,
        )
        self.__rpc_inspect_project_v2 = channel.unary_unary(
            "/pfs_v2.API/InspectProjectV2",
            request_serializer=InspectProjectV2Request.SerializeToString,
            response_deserializer=InspectProjectV2Response.FromString,
        )
        self.__rpc_list_project = channel.unary_stream(
            "/pfs_v2.API/ListProject",
            request_serializer=ListProjectRequest.SerializeToString,
            response_deserializer=ProjectInfo.FromString,
        )
        self.__rpc_delete_project = channel.unary_unary(
            "/pfs_v2.API/DeleteProject",
            request_serializer=DeleteProjectRequest.SerializeToString,
            response_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
        )

    def create_repo(
        self, *, repo: "Repo" = None, description: str = "", update: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = CreateRepoRequest()
        if repo is not None:
            request.repo = repo
        request.description = description
        request.update = update

        return self.__rpc_create_repo(request)

    def inspect_repo(self, *, repo: "Repo" = None) -> "RepoInfo":

        request = InspectRepoRequest()
        if repo is not None:
            request.repo = repo

        return self.__rpc_inspect_repo(request)

    def list_repo(
        self,
        *,
        type: str = "",
        projects: Optional[List["Project"]] = None,
        page: "RepoPage" = None
    ) -> Iterator["RepoInfo"]:
        projects = projects or []

        request = ListRepoRequest()
        request.type = type
        if projects is not None:
            request.projects = projects
        if page is not None:
            request.page = page

        for response in self.__rpc_list_repo(request):
            yield response

    def delete_repo(
        self, *, repo: "Repo" = None, force: bool = False
    ) -> "DeleteRepoResponse":

        request = DeleteRepoRequest()
        if repo is not None:
            request.repo = repo
        request.force = force

        return self.__rpc_delete_repo(request)

    def delete_repos(
        self,
        *,
        projects: Optional[List["Project"]] = None,
        force: bool = False,
        all: bool = False
    ) -> "DeleteReposResponse":
        projects = projects or []

        request = DeleteReposRequest()
        if projects is not None:
            request.projects = projects
        request.force = force
        request.all = all

        return self.__rpc_delete_repos(request)

    def start_commit(
        self, *, parent: "Commit" = None, description: str = "", branch: "Branch" = None
    ) -> "Commit":

        request = StartCommitRequest()
        if parent is not None:
            request.parent = parent
        request.description = description
        if branch is not None:
            request.branch = branch

        return self.__rpc_start_commit(request)

    def finish_commit(
        self,
        *,
        commit: "Commit" = None,
        description: str = "",
        error: str = "",
        force: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = FinishCommitRequest()
        if commit is not None:
            request.commit = commit
        request.description = description
        request.error = error
        request.force = force

        return self.__rpc_finish_commit(request)

    def clear_commit(
        self, *, commit: "Commit" = None
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = ClearCommitRequest()
        if commit is not None:
            request.commit = commit

        return self.__rpc_clear_commit(request)

    def inspect_commit(
        self, *, commit: "Commit" = None, wait: "CommitState" = None
    ) -> "CommitInfo":

        request = InspectCommitRequest()
        if commit is not None:
            request.commit = commit
        request.wait = wait

        return self.__rpc_inspect_commit(request)

    def list_commit(
        self,
        *,
        repo: "Repo" = None,
        from_: "Commit" = None,
        to: "Commit" = None,
        number: int = 0,
        reverse: bool = False,
        all: bool = False,
        origin_kind: "OriginKind" = None,
        started_time: datetime = None
    ) -> Iterator["CommitInfo"]:

        request = ListCommitRequest()
        if repo is not None:
            request.repo = repo
        if from_ is not None:
            request.from_ = from_
        if to is not None:
            request.to = to
        request.number = number
        request.reverse = reverse
        request.all = all
        request.origin_kind = origin_kind
        if started_time is not None:
            request.started_time = started_time

        for response in self.__rpc_list_commit(request):
            yield response

    def subscribe_commit(
        self,
        *,
        repo: "Repo" = None,
        branch: str = "",
        from_: "Commit" = None,
        state: "CommitState" = None,
        all: bool = False,
        origin_kind: "OriginKind" = None
    ) -> Iterator["CommitInfo"]:

        request = SubscribeCommitRequest()
        if repo is not None:
            request.repo = repo
        request.branch = branch
        if from_ is not None:
            request.from_ = from_
        request.state = state
        request.all = all
        request.origin_kind = origin_kind

        for response in self.__rpc_subscribe_commit(request):
            yield response

    def squash_commit(
        self, *, commit: "Commit" = None, recursive: bool = False
    ) -> "SquashCommitResponse":

        request = SquashCommitRequest()
        if commit is not None:
            request.commit = commit
        request.recursive = recursive

        return self.__rpc_squash_commit(request)

    def drop_commit(
        self, *, commit: "Commit" = None, recursive: bool = False
    ) -> "DropCommitResponse":

        request = DropCommitRequest()
        if commit is not None:
            request.commit = commit
        request.recursive = recursive

        return self.__rpc_drop_commit(request)

    def inspect_commit_set(
        self, *, commit_set: "CommitSet" = None, wait: bool = False
    ) -> Iterator["CommitInfo"]:

        request = InspectCommitSetRequest()
        if commit_set is not None:
            request.commit_set = commit_set
        request.wait = wait

        for response in self.__rpc_inspect_commit_set(request):
            yield response

    def list_commit_set(
        self, *, project: "Project" = None
    ) -> Iterator["CommitSetInfo"]:

        request = ListCommitSetRequest()
        if project is not None:
            request.project = project

        for response in self.__rpc_list_commit_set(request):
            yield response

    def squash_commit_set(
        self, *, commit_set: "CommitSet" = None
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = SquashCommitSetRequest()
        if commit_set is not None:
            request.commit_set = commit_set

        return self.__rpc_squash_commit_set(request)

    def drop_commit_set(
        self, *, commit_set: "CommitSet" = None
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DropCommitSetRequest()
        if commit_set is not None:
            request.commit_set = commit_set

        return self.__rpc_drop_commit_set(request)

    def find_commits(
        self, *, start: "Commit" = None, file_path: str = "", limit: int = 0
    ) -> Iterator["FindCommitsResponse"]:

        request = FindCommitsRequest()
        if start is not None:
            request.start = start
        request.file_path = file_path
        request.limit = limit

        for response in self.__rpc_find_commits(request):
            yield response

    def create_branch(
        self,
        *,
        head: "Commit" = None,
        branch: "Branch" = None,
        provenance: Optional[List["Branch"]] = None,
        trigger: "Trigger" = None,
        new_commit_set: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":
        provenance = provenance or []

        request = CreateBranchRequest()
        if head is not None:
            request.head = head
        if branch is not None:
            request.branch = branch
        if provenance is not None:
            request.provenance = provenance
        if trigger is not None:
            request.trigger = trigger
        request.new_commit_set = new_commit_set

        return self.__rpc_create_branch(request)

    def inspect_branch(self, *, branch: "Branch" = None) -> "BranchInfo":

        request = InspectBranchRequest()
        if branch is not None:
            request.branch = branch

        return self.__rpc_inspect_branch(request)

    def list_branch(
        self, *, repo: "Repo" = None, reverse: bool = False
    ) -> Iterator["BranchInfo"]:

        request = ListBranchRequest()
        if repo is not None:
            request.repo = repo
        request.reverse = reverse

        for response in self.__rpc_list_branch(request):
            yield response

    def delete_branch(
        self, *, branch: "Branch" = None, force: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DeleteBranchRequest()
        if branch is not None:
            request.branch = branch
        request.force = force

        return self.__rpc_delete_branch(request)

    def modify_file(
        self,
        request_iterator: Union[
            AsyncIterable["ModifyFileRequest"], Iterable["ModifyFileRequest"]
        ],
    ) -> "betterproto_lib_google_protobuf.Empty":

        return self.__rpc_modify_file(request_iterator)

    def get_file(
        self,
        *,
        file: "File" = None,
        url: str = "",
        offset: int = 0,
        path_range: "PathRange" = None
    ) -> Iterator["betterproto_lib_google_protobuf.BytesValue"]:

        request = GetFileRequest()
        if file is not None:
            request.file = file
        request.url = url
        request.offset = offset
        if path_range is not None:
            request.path_range = path_range

        for response in self.__rpc_get_file(request):
            yield response

    def get_file_tar(
        self,
        *,
        file: "File" = None,
        url: str = "",
        offset: int = 0,
        path_range: "PathRange" = None
    ) -> Iterator["betterproto_lib_google_protobuf.BytesValue"]:

        request = GetFileRequest()
        if file is not None:
            request.file = file
        request.url = url
        request.offset = offset
        if path_range is not None:
            request.path_range = path_range

        for response in self.__rpc_get_file_tar(request):
            yield response

    def inspect_file(self, *, file: "File" = None) -> "FileInfo":

        request = InspectFileRequest()
        if file is not None:
            request.file = file

        return self.__rpc_inspect_file(request)

    def list_file(
        self,
        *,
        file: "File" = None,
        pagination_marker: "File" = None,
        number: int = 0,
        reverse: bool = False
    ) -> Iterator["FileInfo"]:

        request = ListFileRequest()
        if file is not None:
            request.file = file
        if pagination_marker is not None:
            request.pagination_marker = pagination_marker
        request.number = number
        request.reverse = reverse

        for response in self.__rpc_list_file(request):
            yield response

    def walk_file(
        self,
        *,
        file: "File" = None,
        pagination_marker: "File" = None,
        number: int = 0,
        reverse: bool = False
    ) -> Iterator["FileInfo"]:

        request = WalkFileRequest()
        if file is not None:
            request.file = file
        if pagination_marker is not None:
            request.pagination_marker = pagination_marker
        request.number = number
        request.reverse = reverse

        for response in self.__rpc_walk_file(request):
            yield response

    def glob_file(
        self,
        *,
        commit: "Commit" = None,
        pattern: str = "",
        path_range: "PathRange" = None
    ) -> Iterator["FileInfo"]:

        request = GlobFileRequest()
        if commit is not None:
            request.commit = commit
        request.pattern = pattern
        if path_range is not None:
            request.path_range = path_range

        for response in self.__rpc_glob_file(request):
            yield response

    def diff_file(
        self, *, new_file: "File" = None, old_file: "File" = None, shallow: bool = False
    ) -> Iterator["DiffFileResponse"]:

        request = DiffFileRequest()
        if new_file is not None:
            request.new_file = new_file
        if old_file is not None:
            request.old_file = old_file
        request.shallow = shallow

        for response in self.__rpc_diff_file(request):
            yield response

    def activate_auth(self) -> "ActivateAuthResponse":

        request = ActivateAuthRequest()

        return self.__rpc_activate_auth(request)

    def delete_all(self) -> "betterproto_lib_google_protobuf.Empty":

        request = betterproto_lib_google_protobuf.Empty()

        return self.__rpc_delete_all(request)

    def fsck(
        self,
        *,
        fix: bool = False,
        zombie_target: "Commit" = None,
        zombie_all: bool = False
    ) -> Iterator["FsckResponse"]:

        request = FsckRequest()
        request.fix = fix
        if zombie_target is not None:
            request.zombie_target = zombie_target
        request.zombie_all = zombie_all

        for response in self.__rpc_fsck(request):
            yield response

    def create_file_set(
        self,
        request_iterator: Union[
            AsyncIterable["ModifyFileRequest"], Iterable["ModifyFileRequest"]
        ],
    ) -> "CreateFileSetResponse":

        return self.__rpc_create_file_set(request_iterator)

    def get_file_set(
        self, *, commit: "Commit" = None, type: "GetFileSetRequestFileSetType" = None
    ) -> "CreateFileSetResponse":

        request = GetFileSetRequest()
        if commit is not None:
            request.commit = commit
        request.type = type

        return self.__rpc_get_file_set(request)

    def add_file_set(
        self, *, commit: "Commit" = None, file_set_id: str = ""
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = AddFileSetRequest()
        if commit is not None:
            request.commit = commit
        request.file_set_id = file_set_id

        return self.__rpc_add_file_set(request)

    def renew_file_set(
        self, *, file_set_id: str = "", ttl_seconds: int = 0
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = RenewFileSetRequest()
        request.file_set_id = file_set_id
        request.ttl_seconds = ttl_seconds

        return self.__rpc_renew_file_set(request)

    def compose_file_set(
        self,
        *,
        file_set_ids: Optional[List[str]] = None,
        ttl_seconds: int = 0,
        compact: bool = False
    ) -> "CreateFileSetResponse":
        file_set_ids = file_set_ids or []

        request = ComposeFileSetRequest()
        request.file_set_ids = file_set_ids
        request.ttl_seconds = ttl_seconds
        request.compact = compact

        return self.__rpc_compose_file_set(request)

    def shard_file_set(
        self, *, file_set_id: str = "", num_files: int = 0, size_bytes: int = 0
    ) -> "ShardFileSetResponse":

        request = ShardFileSetRequest()
        request.file_set_id = file_set_id
        request.num_files = num_files
        request.size_bytes = size_bytes

        return self.__rpc_shard_file_set(request)

    def check_storage(
        self,
        *,
        read_chunk_data: bool = False,
        chunk_begin: bytes = b"",
        chunk_end: bytes = b""
    ) -> "CheckStorageResponse":

        request = CheckStorageRequest()
        request.read_chunk_data = read_chunk_data
        request.chunk_begin = chunk_begin
        request.chunk_end = chunk_end

        return self.__rpc_check_storage(request)

    def put_cache(
        self,
        *,
        key: str = "",
        value: "betterproto_lib_google_protobuf.Any" = None,
        file_set_ids: Optional[List[str]] = None,
        tag: str = ""
    ) -> "betterproto_lib_google_protobuf.Empty":
        file_set_ids = file_set_ids or []

        request = PutCacheRequest()
        request.key = key
        if value is not None:
            request.value = value
        request.file_set_ids = file_set_ids
        request.tag = tag

        return self.__rpc_put_cache(request)

    def get_cache(self, *, key: str = "") -> "GetCacheResponse":

        request = GetCacheRequest()
        request.key = key

        return self.__rpc_get_cache(request)

    def clear_cache(
        self, *, tag_prefix: str = ""
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = ClearCacheRequest()
        request.tag_prefix = tag_prefix

        return self.__rpc_clear_cache(request)

    def list_task(self, *, group: "Group" = None) -> Iterator["_taskapi__.TaskInfo"]:

        request = _taskapi__.ListTaskRequest()
        if group is not None:
            request.group = group

        for response in self.__rpc_list_task(request):
            yield response

    def egress(
        self,
        *,
        commit: "Commit" = None,
        object_storage: "ObjectStorageEgress" = None,
        sql_database: "SqlDatabaseEgress" = None
    ) -> "EgressResponse":

        request = EgressRequest()
        if commit is not None:
            request.commit = commit
        if object_storage is not None:
            request.object_storage = object_storage
        if sql_database is not None:
            request.sql_database = sql_database

        return self.__rpc_egress(request)

    def create_project(
        self, *, project: "Project" = None, description: str = "", update: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = CreateProjectRequest()
        if project is not None:
            request.project = project
        request.description = description
        request.update = update

        return self.__rpc_create_project(request)

    def inspect_project(self, *, project: "Project" = None) -> "ProjectInfo":

        request = InspectProjectRequest()
        if project is not None:
            request.project = project

        return self.__rpc_inspect_project(request)

    def inspect_project_v2(
        self, *, project: "Project" = None
    ) -> "InspectProjectV2Response":

        request = InspectProjectV2Request()
        if project is not None:
            request.project = project

        return self.__rpc_inspect_project_v2(request)

    def list_project(self) -> Iterator["ProjectInfo"]:

        request = ListProjectRequest()

        for response in self.__rpc_list_project(request):
            yield response

    def delete_project(
        self, *, project: "Project" = None, force: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DeleteProjectRequest()
        if project is not None:
            request.project = project
        request.force = force

        return self.__rpc_delete_project(request)


class ApiBase:

    def create_repo(
        self,
        repo: "Repo",
        description: str,
        update: bool,
        context: "grpc.ServicerContext",
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_repo(self, repo: "Repo", context: "grpc.ServicerContext") -> "RepoInfo":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_repo(
        self,
        type: str,
        projects: Optional[List["Project"]],
        page: "RepoPage",
        context: "grpc.ServicerContext",
    ) -> Iterator["RepoInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_repo(
        self, repo: "Repo", force: bool, context: "grpc.ServicerContext"
    ) -> "DeleteRepoResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_repos(
        self,
        projects: Optional[List["Project"]],
        force: bool,
        all: bool,
        context: "grpc.ServicerContext",
    ) -> "DeleteReposResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def start_commit(
        self,
        parent: "Commit",
        description: str,
        branch: "Branch",
        context: "grpc.ServicerContext",
    ) -> "Commit":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def finish_commit(
        self,
        commit: "Commit",
        description: str,
        error: str,
        force: bool,
        context: "grpc.ServicerContext",
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def clear_commit(
        self, commit: "Commit", context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_commit(
        self, commit: "Commit", wait: "CommitState", context: "grpc.ServicerContext"
    ) -> "CommitInfo":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_commit(
        self,
        repo: "Repo",
        from_: "Commit",
        to: "Commit",
        number: int,
        reverse: bool,
        all: bool,
        origin_kind: "OriginKind",
        started_time: datetime,
        context: "grpc.ServicerContext",
    ) -> Iterator["CommitInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def subscribe_commit(
        self,
        repo: "Repo",
        branch: str,
        from_: "Commit",
        state: "CommitState",
        all: bool,
        origin_kind: "OriginKind",
        context: "grpc.ServicerContext",
    ) -> Iterator["CommitInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def squash_commit(
        self, commit: "Commit", recursive: bool, context: "grpc.ServicerContext"
    ) -> "SquashCommitResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def drop_commit(
        self, commit: "Commit", recursive: bool, context: "grpc.ServicerContext"
    ) -> "DropCommitResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_commit_set(
        self, commit_set: "CommitSet", wait: bool, context: "grpc.ServicerContext"
    ) -> Iterator["CommitInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_commit_set(
        self, project: "Project", context: "grpc.ServicerContext"
    ) -> Iterator["CommitSetInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def squash_commit_set(
        self, commit_set: "CommitSet", context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def drop_commit_set(
        self, commit_set: "CommitSet", context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def find_commits(
        self,
        start: "Commit",
        file_path: str,
        limit: int,
        context: "grpc.ServicerContext",
    ) -> Iterator["FindCommitsResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def create_branch(
        self,
        head: "Commit",
        branch: "Branch",
        provenance: Optional[List["Branch"]],
        trigger: "Trigger",
        new_commit_set: bool,
        context: "grpc.ServicerContext",
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_branch(
        self, branch: "Branch", context: "grpc.ServicerContext"
    ) -> "BranchInfo":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_branch(
        self, repo: "Repo", reverse: bool, context: "grpc.ServicerContext"
    ) -> Iterator["BranchInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_branch(
        self, branch: "Branch", force: bool, context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def modify_file(
        self,
        request_iterator: Iterator["ModifyFileRequest"],
        context: "grpc.ServicerContext",
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_file(
        self,
        file: "File",
        url: str,
        offset: int,
        path_range: "PathRange",
        context: "grpc.ServicerContext",
    ) -> Iterator["betterproto_lib_google_protobuf.BytesValue"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_file_tar(
        self,
        file: "File",
        url: str,
        offset: int,
        path_range: "PathRange",
        context: "grpc.ServicerContext",
    ) -> Iterator["betterproto_lib_google_protobuf.BytesValue"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_file(self, file: "File", context: "grpc.ServicerContext") -> "FileInfo":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_file(
        self,
        file: "File",
        pagination_marker: "File",
        number: int,
        reverse: bool,
        context: "grpc.ServicerContext",
    ) -> Iterator["FileInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def walk_file(
        self,
        file: "File",
        pagination_marker: "File",
        number: int,
        reverse: bool,
        context: "grpc.ServicerContext",
    ) -> Iterator["FileInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def glob_file(
        self,
        commit: "Commit",
        pattern: str,
        path_range: "PathRange",
        context: "grpc.ServicerContext",
    ) -> Iterator["FileInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def diff_file(
        self,
        new_file: "File",
        old_file: "File",
        shallow: bool,
        context: "grpc.ServicerContext",
    ) -> Iterator["DiffFileResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def activate_auth(self, context: "grpc.ServicerContext") -> "ActivateAuthResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_all(
        self, context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def fsck(
        self,
        fix: bool,
        zombie_target: "Commit",
        zombie_all: bool,
        context: "grpc.ServicerContext",
    ) -> Iterator["FsckResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def create_file_set(
        self,
        request_iterator: Iterator["ModifyFileRequest"],
        context: "grpc.ServicerContext",
    ) -> "CreateFileSetResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_file_set(
        self,
        commit: "Commit",
        type: "GetFileSetRequestFileSetType",
        context: "grpc.ServicerContext",
    ) -> "CreateFileSetResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def add_file_set(
        self, commit: "Commit", file_set_id: str, context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def renew_file_set(
        self, file_set_id: str, ttl_seconds: int, context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def compose_file_set(
        self,
        file_set_ids: Optional[List[str]],
        ttl_seconds: int,
        compact: bool,
        context: "grpc.ServicerContext",
    ) -> "CreateFileSetResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def shard_file_set(
        self,
        file_set_id: str,
        num_files: int,
        size_bytes: int,
        context: "grpc.ServicerContext",
    ) -> "ShardFileSetResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def check_storage(
        self,
        read_chunk_data: bool,
        chunk_begin: bytes,
        chunk_end: bytes,
        context: "grpc.ServicerContext",
    ) -> "CheckStorageResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def put_cache(
        self,
        key: str,
        value: "betterproto_lib_google_protobuf.Any",
        file_set_ids: Optional[List[str]],
        tag: str,
        context: "grpc.ServicerContext",
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_cache(
        self, key: str, context: "grpc.ServicerContext"
    ) -> "GetCacheResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def clear_cache(
        self, tag_prefix: str, context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_task(
        self, group: "Group", context: "grpc.ServicerContext"
    ) -> Iterator["_taskapi__.TaskInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def egress(
        self,
        commit: "Commit",
        object_storage: "ObjectStorageEgress",
        sql_database: "SqlDatabaseEgress",
        context: "grpc.ServicerContext",
    ) -> "EgressResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def create_project(
        self,
        project: "Project",
        description: str,
        update: bool,
        context: "grpc.ServicerContext",
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_project(
        self, project: "Project", context: "grpc.ServicerContext"
    ) -> "ProjectInfo":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_project_v2(
        self, project: "Project", context: "grpc.ServicerContext"
    ) -> "InspectProjectV2Response":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_project(self, context: "grpc.ServicerContext") -> Iterator["ProjectInfo"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_project(
        self, project: "Project", force: bool, context: "grpc.ServicerContext"
    ) -> "betterproto_lib_google_protobuf.Empty":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    __proto_path__ = "pfs_v2.API"

    @property
    def __rpc_methods__(self):
        return {
            "CreateRepo": grpc.unary_unary_rpc_method_handler(
                self.create_repo,
                request_deserializer=CreateRepoRequest.FromString,
                response_serializer=CreateRepoRequest.SerializeToString,
            ),
            "InspectRepo": grpc.unary_unary_rpc_method_handler(
                self.inspect_repo,
                request_deserializer=InspectRepoRequest.FromString,
                response_serializer=InspectRepoRequest.SerializeToString,
            ),
            "ListRepo": grpc.unary_stream_rpc_method_handler(
                self.list_repo,
                request_deserializer=ListRepoRequest.FromString,
                response_serializer=ListRepoRequest.SerializeToString,
            ),
            "DeleteRepo": grpc.unary_unary_rpc_method_handler(
                self.delete_repo,
                request_deserializer=DeleteRepoRequest.FromString,
                response_serializer=DeleteRepoRequest.SerializeToString,
            ),
            "DeleteRepos": grpc.unary_unary_rpc_method_handler(
                self.delete_repos,
                request_deserializer=DeleteReposRequest.FromString,
                response_serializer=DeleteReposRequest.SerializeToString,
            ),
            "StartCommit": grpc.unary_unary_rpc_method_handler(
                self.start_commit,
                request_deserializer=StartCommitRequest.FromString,
                response_serializer=StartCommitRequest.SerializeToString,
            ),
            "FinishCommit": grpc.unary_unary_rpc_method_handler(
                self.finish_commit,
                request_deserializer=FinishCommitRequest.FromString,
                response_serializer=FinishCommitRequest.SerializeToString,
            ),
            "ClearCommit": grpc.unary_unary_rpc_method_handler(
                self.clear_commit,
                request_deserializer=ClearCommitRequest.FromString,
                response_serializer=ClearCommitRequest.SerializeToString,
            ),
            "InspectCommit": grpc.unary_unary_rpc_method_handler(
                self.inspect_commit,
                request_deserializer=InspectCommitRequest.FromString,
                response_serializer=InspectCommitRequest.SerializeToString,
            ),
            "ListCommit": grpc.unary_stream_rpc_method_handler(
                self.list_commit,
                request_deserializer=ListCommitRequest.FromString,
                response_serializer=ListCommitRequest.SerializeToString,
            ),
            "SubscribeCommit": grpc.unary_stream_rpc_method_handler(
                self.subscribe_commit,
                request_deserializer=SubscribeCommitRequest.FromString,
                response_serializer=SubscribeCommitRequest.SerializeToString,
            ),
            "SquashCommit": grpc.unary_unary_rpc_method_handler(
                self.squash_commit,
                request_deserializer=SquashCommitRequest.FromString,
                response_serializer=SquashCommitRequest.SerializeToString,
            ),
            "DropCommit": grpc.unary_unary_rpc_method_handler(
                self.drop_commit,
                request_deserializer=DropCommitRequest.FromString,
                response_serializer=DropCommitRequest.SerializeToString,
            ),
            "InspectCommitSet": grpc.unary_stream_rpc_method_handler(
                self.inspect_commit_set,
                request_deserializer=InspectCommitSetRequest.FromString,
                response_serializer=InspectCommitSetRequest.SerializeToString,
            ),
            "ListCommitSet": grpc.unary_stream_rpc_method_handler(
                self.list_commit_set,
                request_deserializer=ListCommitSetRequest.FromString,
                response_serializer=ListCommitSetRequest.SerializeToString,
            ),
            "SquashCommitSet": grpc.unary_unary_rpc_method_handler(
                self.squash_commit_set,
                request_deserializer=SquashCommitSetRequest.FromString,
                response_serializer=SquashCommitSetRequest.SerializeToString,
            ),
            "DropCommitSet": grpc.unary_unary_rpc_method_handler(
                self.drop_commit_set,
                request_deserializer=DropCommitSetRequest.FromString,
                response_serializer=DropCommitSetRequest.SerializeToString,
            ),
            "FindCommits": grpc.unary_stream_rpc_method_handler(
                self.find_commits,
                request_deserializer=FindCommitsRequest.FromString,
                response_serializer=FindCommitsRequest.SerializeToString,
            ),
            "CreateBranch": grpc.unary_unary_rpc_method_handler(
                self.create_branch,
                request_deserializer=CreateBranchRequest.FromString,
                response_serializer=CreateBranchRequest.SerializeToString,
            ),
            "InspectBranch": grpc.unary_unary_rpc_method_handler(
                self.inspect_branch,
                request_deserializer=InspectBranchRequest.FromString,
                response_serializer=InspectBranchRequest.SerializeToString,
            ),
            "ListBranch": grpc.unary_stream_rpc_method_handler(
                self.list_branch,
                request_deserializer=ListBranchRequest.FromString,
                response_serializer=ListBranchRequest.SerializeToString,
            ),
            "DeleteBranch": grpc.unary_unary_rpc_method_handler(
                self.delete_branch,
                request_deserializer=DeleteBranchRequest.FromString,
                response_serializer=DeleteBranchRequest.SerializeToString,
            ),
            "ModifyFile": grpc.stream_unary_rpc_method_handler(
                self.modify_file,
                request_deserializer=ModifyFileRequest.FromString,
                response_serializer=ModifyFileRequest.SerializeToString,
            ),
            "GetFile": grpc.unary_stream_rpc_method_handler(
                self.get_file,
                request_deserializer=GetFileRequest.FromString,
                response_serializer=GetFileRequest.SerializeToString,
            ),
            "GetFileTAR": grpc.unary_stream_rpc_method_handler(
                self.get_file_tar,
                request_deserializer=GetFileRequest.FromString,
                response_serializer=GetFileRequest.SerializeToString,
            ),
            "InspectFile": grpc.unary_unary_rpc_method_handler(
                self.inspect_file,
                request_deserializer=InspectFileRequest.FromString,
                response_serializer=InspectFileRequest.SerializeToString,
            ),
            "ListFile": grpc.unary_stream_rpc_method_handler(
                self.list_file,
                request_deserializer=ListFileRequest.FromString,
                response_serializer=ListFileRequest.SerializeToString,
            ),
            "WalkFile": grpc.unary_stream_rpc_method_handler(
                self.walk_file,
                request_deserializer=WalkFileRequest.FromString,
                response_serializer=WalkFileRequest.SerializeToString,
            ),
            "GlobFile": grpc.unary_stream_rpc_method_handler(
                self.glob_file,
                request_deserializer=GlobFileRequest.FromString,
                response_serializer=GlobFileRequest.SerializeToString,
            ),
            "DiffFile": grpc.unary_stream_rpc_method_handler(
                self.diff_file,
                request_deserializer=DiffFileRequest.FromString,
                response_serializer=DiffFileRequest.SerializeToString,
            ),
            "ActivateAuth": grpc.unary_unary_rpc_method_handler(
                self.activate_auth,
                request_deserializer=ActivateAuthRequest.FromString,
                response_serializer=ActivateAuthRequest.SerializeToString,
            ),
            "DeleteAll": grpc.unary_unary_rpc_method_handler(
                self.delete_all,
                request_deserializer=betterproto_lib_google_protobuf.Empty.FromString,
                response_serializer=betterproto_lib_google_protobuf.Empty.SerializeToString,
            ),
            "Fsck": grpc.unary_stream_rpc_method_handler(
                self.fsck,
                request_deserializer=FsckRequest.FromString,
                response_serializer=FsckRequest.SerializeToString,
            ),
            "CreateFileSet": grpc.stream_unary_rpc_method_handler(
                self.create_file_set,
                request_deserializer=ModifyFileRequest.FromString,
                response_serializer=ModifyFileRequest.SerializeToString,
            ),
            "GetFileSet": grpc.unary_unary_rpc_method_handler(
                self.get_file_set,
                request_deserializer=GetFileSetRequest.FromString,
                response_serializer=GetFileSetRequest.SerializeToString,
            ),
            "AddFileSet": grpc.unary_unary_rpc_method_handler(
                self.add_file_set,
                request_deserializer=AddFileSetRequest.FromString,
                response_serializer=AddFileSetRequest.SerializeToString,
            ),
            "RenewFileSet": grpc.unary_unary_rpc_method_handler(
                self.renew_file_set,
                request_deserializer=RenewFileSetRequest.FromString,
                response_serializer=RenewFileSetRequest.SerializeToString,
            ),
            "ComposeFileSet": grpc.unary_unary_rpc_method_handler(
                self.compose_file_set,
                request_deserializer=ComposeFileSetRequest.FromString,
                response_serializer=ComposeFileSetRequest.SerializeToString,
            ),
            "ShardFileSet": grpc.unary_unary_rpc_method_handler(
                self.shard_file_set,
                request_deserializer=ShardFileSetRequest.FromString,
                response_serializer=ShardFileSetRequest.SerializeToString,
            ),
            "CheckStorage": grpc.unary_unary_rpc_method_handler(
                self.check_storage,
                request_deserializer=CheckStorageRequest.FromString,
                response_serializer=CheckStorageRequest.SerializeToString,
            ),
            "PutCache": grpc.unary_unary_rpc_method_handler(
                self.put_cache,
                request_deserializer=PutCacheRequest.FromString,
                response_serializer=PutCacheRequest.SerializeToString,
            ),
            "GetCache": grpc.unary_unary_rpc_method_handler(
                self.get_cache,
                request_deserializer=GetCacheRequest.FromString,
                response_serializer=GetCacheRequest.SerializeToString,
            ),
            "ClearCache": grpc.unary_unary_rpc_method_handler(
                self.clear_cache,
                request_deserializer=ClearCacheRequest.FromString,
                response_serializer=ClearCacheRequest.SerializeToString,
            ),
            "ListTask": grpc.unary_stream_rpc_method_handler(
                self.list_task,
                request_deserializer=_taskapi__.ListTaskRequest.FromString,
                response_serializer=_taskapi__.ListTaskRequest.SerializeToString,
            ),
            "Egress": grpc.unary_unary_rpc_method_handler(
                self.egress,
                request_deserializer=EgressRequest.FromString,
                response_serializer=EgressRequest.SerializeToString,
            ),
            "CreateProject": grpc.unary_unary_rpc_method_handler(
                self.create_project,
                request_deserializer=CreateProjectRequest.FromString,
                response_serializer=CreateProjectRequest.SerializeToString,
            ),
            "InspectProject": grpc.unary_unary_rpc_method_handler(
                self.inspect_project,
                request_deserializer=InspectProjectRequest.FromString,
                response_serializer=InspectProjectRequest.SerializeToString,
            ),
            "InspectProjectV2": grpc.unary_unary_rpc_method_handler(
                self.inspect_project_v2,
                request_deserializer=InspectProjectV2Request.FromString,
                response_serializer=InspectProjectV2Request.SerializeToString,
            ),
            "ListProject": grpc.unary_stream_rpc_method_handler(
                self.list_project,
                request_deserializer=ListProjectRequest.FromString,
                response_serializer=ListProjectRequest.SerializeToString,
            ),
            "DeleteProject": grpc.unary_unary_rpc_method_handler(
                self.delete_project,
                request_deserializer=DeleteProjectRequest.FromString,
                response_serializer=DeleteProjectRequest.SerializeToString,
            ),
        }
