# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: api/pjs/pjs.proto
# plugin: python-betterproto
# This file has been @generated
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    Iterator,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpc


if TYPE_CHECKING:
    import grpc


class JobState(betterproto.Enum):
    JobState_UNSPECIFIED = 0
    """UNSPECIFIED means the job state is unspecified."""

    QUEUED = 1
    """
    QUEUED means the job is currently in a queue. A QUEUED job will not have
    any descendants.
    """

    PROCESSING = 2
    """PROCESSING means the job is currently being processed by a worker."""

    DONE = 3
    """DONE means the job, and all of its descendants, are done."""


class JobErrorCode(betterproto.Enum):
    JobErrorCode_UNSPECIFIED = 0
    """UNSPECIFIED means the job error code is unspecified."""

    FAILED = 1
    """
    FAILED means that the worker processing the job indicated that it failed.
    """

    DISCONNECTED = 2
    """DISCONNECTED means the worker processing the job disconnected."""

    CANCELED = 3
    """CANCELED means the job was canceled."""


@dataclass(eq=False, repr=False)
class Job(betterproto.Message):
    """
    Job uniquely identifies a Job Job will be nil to indicate no Job, or an
    unset Job.
    """

    id: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class JobInfo(betterproto.Message):
    """JobInfo describes a Job"""

    job: "Job" = betterproto.message_field(1)
    """Job is the Job's identity"""

    parent_job: "Job" = betterproto.message_field(2)
    """parent_job is the Job's parent if it exists."""

    state: "JobState" = betterproto.enum_field(3)
    """
    state is the Job's state. See JobState for a description of the possible
    states.
    """

    spec: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(4)
    """spec is the code specification for the Job."""

    input: "QueueElement" = betterproto.message_field(5)
    """input is the input data for the Job."""

    output: "QueueElement" = betterproto.message_field(6, group="result")
    """output is produced by a successfully completing Job"""

    error: "JobErrorCode" = betterproto.enum_field(7, group="result")
    """error is set when the Job is unable to complete successfully"""


@dataclass(eq=False, repr=False)
class JobInfoDetails(betterproto.Message):
    """
    JobInfoDetails is more detailed information about a Job. It contains a
    superset of the information in JobInfo
    """

    job_info: "JobInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Queue(betterproto.Message):
    """
    Queue uniquely identifies a Queue Queue will be nil to identify no Queue,
    or to indicate unset.
    """

    id: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueueInfo(betterproto.Message):
    """QueueInfo describes a Queue"""

    queue: "Queue" = betterproto.message_field(1)
    """queue is the Queue's identity"""

    spec: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """spec specifies the code to be run to process the Queue."""


@dataclass(eq=False, repr=False)
class QueueInfoDetails(betterproto.Message):
    """
    QueueInfoDetails contains detailed information about a Queue, which may be
    more expensive to get. It contains a superset of the information in
    QueueInfo.
    """

    queue_info: "QueueInfo" = betterproto.message_field(1)
    size: int = betterproto.int64_field(2)
    """size is the number of elements queued."""


@dataclass(eq=False, repr=False)
class QueueElement(betterproto.Message):
    """QueueElement is a single element in a Queue."""

    data: bytes = betterproto.bytes_field(1)
    """data is opaque data used as the input and output of Jobs"""

    filesets: List[str] = betterproto.string_field(2)
    """
    filesets is a list of Fileset handles, used to associate Filesets with the
    input and output of Jobs. Any of the filesets referenced here will be
    persisted for as long as this element is in a Queue. New handles, pointing
    to equivalent Filesets, are minted whenever they cross the API boundary.
    """


@dataclass(eq=False, repr=False)
class CreateJobRequest(betterproto.Message):
    context: str = betterproto.string_field(1)
    """
    context is a bearer token used when calling from within a running Job.
    """

    spec: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    input: "QueueElement" = betterproto.message_field(3)
    cache_read: bool = betterproto.bool_field(4)
    cache_write: bool = betterproto.bool_field(5)


@dataclass(eq=False, repr=False)
class CreateJobResponse(betterproto.Message):
    id: "Job" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CancelJobRequest(betterproto.Message):
    context: str = betterproto.string_field(1)
    """
    context is a bearer token used when calling from within a running Job.
    """

    job: "Job" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CancelJobResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteJobRequest(betterproto.Message):
    context: str = betterproto.string_field(1)
    """
    context is a bearer token used when calling from within a running Job.
    """

    job: "Job" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DeleteJobResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListJobRequest(betterproto.Message):
    """TODO: - Filter - Paginate"""

    context: str = betterproto.string_field(1)
    """
    context is a bearer token used when calling from within a running Job.
    """

    job: "Job" = betterproto.message_field(2)
    """
    job is the job to start listing at. If nil, then the listing starts at the
    first job in the natural ordering.
    """


@dataclass(eq=False, repr=False)
class ListJobResponse(betterproto.Message):
    """
    ListJobResponse lists information about Jobs ID will always be set. Info
    and Details may not be set depending on how much information was requested.
    """

    id: "Job" = betterproto.message_field(1)
    info: "JobInfo" = betterproto.message_field(2)
    details: "JobInfoDetails" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class WalkJobRequest(betterproto.Message):
    context: str = betterproto.string_field(1)
    """
    context is a bearer token used when calling from within a running Job.
    """

    job: "Job" = betterproto.message_field(2)
    """
    job is the job to start walking from.  If unset, the context Job is
    assumed.
    """


@dataclass(eq=False, repr=False)
class InspectJobRequest(betterproto.Message):
    context: str = betterproto.string_field(1)
    """
    context is a bearer token used when calling from within a running Job.
    """

    job: "Job" = betterproto.message_field(2)
    """
    job is the job to start walking from.  If unset the context Job is assumed.
    """


@dataclass(eq=False, repr=False)
class InspectJobResponse(betterproto.Message):
    details: "JobInfoDetails" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ProcessQueueRequest(betterproto.Message):
    """
    Queue Messages ProcessQueueRequest is the client -> server message for the
    bi-di ProcessQueue RPC.
    """

    queue: "Queue" = betterproto.message_field(1)
    """queue is set to start processing from a Queue."""

    output: "QueueElement" = betterproto.message_field(2, group="result")
    """output is set by the client to complete the Job successfully."""

    failed: bool = betterproto.bool_field(3, group="result")
    """
    failed is set by the client to fail the Job. The Job will transition to
    state DONE with code FAILED.
    """


@dataclass(eq=False, repr=False)
class ProcessQueueResponse(betterproto.Message):
    """
    ProcessQueueResposne is the server -> client message for the bi-di
    ProcessQueue RPC.
    """

    context: str = betterproto.string_field(1)
    """
    context is a bearer token used to act on behalf of the Job in other RPCs.
    The server issues this token to the client, and the client should use it
    when performing Job RPCs.
    """

    input: "QueueElement" = betterproto.message_field(2)
    """
    input is the input data for a Job. The server sends this to ask the client
    to compute the output.
    """


@dataclass(eq=False, repr=False)
class ListQueueRequest(betterproto.Message):
    """TODO: - Filter - Paginate"""

    pass


@dataclass(eq=False, repr=False)
class ListQueueResponse(betterproto.Message):
    id: "Queue" = betterproto.message_field(1)
    info: "QueueInfo" = betterproto.message_field(2)
    details: "QueueInfoDetails" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class InspectQueueRequest(betterproto.Message):
    queue: "Queue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class InspectQueueResponse(betterproto.Message):
    details: "QueueInfoDetails" = betterproto.message_field(1)


class ApiStub:

    def __init__(self, channel: "grpc.Channel"):
        self.__rpc_create_job = channel.unary_unary(
            "/pjs.API/CreateJob",
            request_serializer=CreateJobRequest.SerializeToString,
            response_deserializer=CreateJobResponse.FromString,
        )
        self.__rpc_cancel_job = channel.unary_unary(
            "/pjs.API/CancelJob",
            request_serializer=CancelJobRequest.SerializeToString,
            response_deserializer=CancelJobResponse.FromString,
        )
        self.__rpc_delete_job = channel.unary_unary(
            "/pjs.API/DeleteJob",
            request_serializer=DeleteJobRequest.SerializeToString,
            response_deserializer=DeleteJobResponse.FromString,
        )
        self.__rpc_list_job = channel.unary_stream(
            "/pjs.API/ListJob",
            request_serializer=ListJobRequest.SerializeToString,
            response_deserializer=ListJobResponse.FromString,
        )
        self.__rpc_walk_job = channel.unary_stream(
            "/pjs.API/WalkJob",
            request_serializer=WalkJobRequest.SerializeToString,
            response_deserializer=ListJobResponse.FromString,
        )
        self.__rpc_inspect_job = channel.unary_unary(
            "/pjs.API/InspectJob",
            request_serializer=InspectJobRequest.SerializeToString,
            response_deserializer=InspectJobResponse.FromString,
        )
        self.__rpc_process_queue = channel.stream_stream(
            "/pjs.API/ProcessQueue",
            request_serializer=ProcessQueueRequest.SerializeToString,
            response_deserializer=ProcessQueueResponse.FromString,
        )
        self.__rpc_list_queue = channel.unary_stream(
            "/pjs.API/ListQueue",
            request_serializer=ListQueueRequest.SerializeToString,
            response_deserializer=ListQueueResponse.FromString,
        )
        self.__rpc_inspect_queue = channel.unary_unary(
            "/pjs.API/InspectQueue",
            request_serializer=InspectQueueRequest.SerializeToString,
            response_deserializer=InspectQueueResponse.FromString,
        )

    def create_job(
        self,
        *,
        context: str = "",
        spec: "betterproto_lib_google_protobuf.Any" = None,
        input: "QueueElement" = None,
        cache_read: bool = False,
        cache_write: bool = False
    ) -> "CreateJobResponse":

        request = CreateJobRequest()
        request.context = context
        if spec is not None:
            request.spec = spec
        if input is not None:
            request.input = input
        request.cache_read = cache_read
        request.cache_write = cache_write

        return self.__rpc_create_job(request)

    def cancel_job(
        self, *, context: str = "", job: "Job" = None
    ) -> "CancelJobResponse":

        request = CancelJobRequest()
        request.context = context
        if job is not None:
            request.job = job

        return self.__rpc_cancel_job(request)

    def delete_job(
        self, *, context: str = "", job: "Job" = None
    ) -> "DeleteJobResponse":

        request = DeleteJobRequest()
        request.context = context
        if job is not None:
            request.job = job

        return self.__rpc_delete_job(request)

    def list_job(
        self, *, context: str = "", job: "Job" = None
    ) -> Iterator["ListJobResponse"]:

        request = ListJobRequest()
        request.context = context
        if job is not None:
            request.job = job

        for response in self.__rpc_list_job(request):
            yield response

    def walk_job(
        self, *, context: str = "", job: "Job" = None
    ) -> Iterator["ListJobResponse"]:

        request = WalkJobRequest()
        request.context = context
        if job is not None:
            request.job = job

        for response in self.__rpc_walk_job(request):
            yield response

    def inspect_job(
        self, *, context: str = "", job: "Job" = None
    ) -> "InspectJobResponse":

        request = InspectJobRequest()
        request.context = context
        if job is not None:
            request.job = job

        return self.__rpc_inspect_job(request)

    def process_queue(
        self,
        request_iterator: Union[
            AsyncIterable["ProcessQueueRequest"], Iterable["ProcessQueueRequest"]
        ],
    ) -> Iterator["ProcessQueueResponse"]:

        for response in self.__rpc_process_queue(request_iterator):
            yield response

    def list_queue(self) -> Iterator["ListQueueResponse"]:

        request = ListQueueRequest()

        for response in self.__rpc_list_queue(request):
            yield response

    def inspect_queue(self, *, queue: "Queue" = None) -> "InspectQueueResponse":

        request = InspectQueueRequest()
        if queue is not None:
            request.queue = queue

        return self.__rpc_inspect_queue(request)


class ApiBase:

    def create_job(
        self,
        context: str,
        spec: "betterproto_lib_google_protobuf.Any",
        input: "QueueElement",
        cache_read: bool,
        cache_write: bool,
        context: "grpc.ServicerContext",
    ) -> "CreateJobResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def cancel_job(
        self, context: str, job: "Job", context: "grpc.ServicerContext"
    ) -> "CancelJobResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def delete_job(
        self, context: str, job: "Job", context: "grpc.ServicerContext"
    ) -> "DeleteJobResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_job(
        self, context: str, job: "Job", context: "grpc.ServicerContext"
    ) -> Iterator["ListJobResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def walk_job(
        self, context: str, job: "Job", context: "grpc.ServicerContext"
    ) -> Iterator["ListJobResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_job(
        self, context: str, job: "Job", context: "grpc.ServicerContext"
    ) -> "InspectJobResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def process_queue(
        self,
        request_iterator: Iterator["ProcessQueueRequest"],
        context: "grpc.ServicerContext",
    ) -> Iterator["ProcessQueueResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def list_queue(
        self, context: "grpc.ServicerContext"
    ) -> Iterator["ListQueueResponse"]:
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def inspect_queue(
        self, queue: "Queue", context: "grpc.ServicerContext"
    ) -> "InspectQueueResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    __proto_path__ = "pjs.API"

    @property
    def __rpc_methods__(self):
        return {
            "CreateJob": grpc.unary_unary_rpc_method_handler(
                self.create_job,
                request_deserializer=CreateJobRequest.FromString,
                response_serializer=CreateJobRequest.SerializeToString,
            ),
            "CancelJob": grpc.unary_unary_rpc_method_handler(
                self.cancel_job,
                request_deserializer=CancelJobRequest.FromString,
                response_serializer=CancelJobRequest.SerializeToString,
            ),
            "DeleteJob": grpc.unary_unary_rpc_method_handler(
                self.delete_job,
                request_deserializer=DeleteJobRequest.FromString,
                response_serializer=DeleteJobRequest.SerializeToString,
            ),
            "ListJob": grpc.unary_stream_rpc_method_handler(
                self.list_job,
                request_deserializer=ListJobRequest.FromString,
                response_serializer=ListJobRequest.SerializeToString,
            ),
            "WalkJob": grpc.unary_stream_rpc_method_handler(
                self.walk_job,
                request_deserializer=WalkJobRequest.FromString,
                response_serializer=WalkJobRequest.SerializeToString,
            ),
            "InspectJob": grpc.unary_unary_rpc_method_handler(
                self.inspect_job,
                request_deserializer=InspectJobRequest.FromString,
                response_serializer=InspectJobRequest.SerializeToString,
            ),
            "ProcessQueue": grpc.stream_stream_rpc_method_handler(
                self.process_queue,
                request_deserializer=ProcessQueueRequest.FromString,
                response_serializer=ProcessQueueRequest.SerializeToString,
            ),
            "ListQueue": grpc.unary_stream_rpc_method_handler(
                self.list_queue,
                request_deserializer=ListQueueRequest.FromString,
                response_serializer=ListQueueRequest.SerializeToString,
            ),
            "InspectQueue": grpc.unary_unary_rpc_method_handler(
                self.inspect_queue,
                request_deserializer=InspectQueueRequest.FromString,
                response_serializer=InspectQueueRequest.SerializeToString,
            ),
        }
