import setuptools
with open("README.md", "r") as fh:
    long_description = fh.read()
setuptools.setup(
    name="finsaber",
    version="0.1.2",
    author="waylonli",
    author_email="waylon.li@ed.ac.uk",
    description="Financial INvesting Strategy Assessment with Bias mitigation, Expanded time, and Range of symbols (FINSABER)",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/waylonli/FINSABER",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    install_requires=[
        "annotated_types==0.7.0",
        "backoff==2.2.1",
        "backtrader==1.9.78.123",
        "beautifulsoup4==4.13.4",
        "ccxt==4.4.68",
        "certifi==2025.1.31",
        "cleantext==1.1.4",
        "colorlog==6.9.0",
        "datasets==3.0.0",
        "exchange_calendars==3.6.3",
        "finnhub_python==2.4.20",
        "gym==0.26.2",
        "gymnasium==1.0.0",
        "httpx==0.28.1",
        "ib_insync==0.9.86",
        "ipdb==0.13.13",
        "joblib==1.4.2",
        "jqdatasdk==1.9.7",
        "json5==0.10.0",
        "langchain_community==0.3.25",
        "langchain_together==0.3.0",
        "lxml==5.3.0",
        "matplotlib==3.10.3",
        "mmengine==0.10.7",
        "model_wrapper==1.1.2",
        "numpy==1.26.4",
        "openai==1.88.0",
        "optuna==4.4.0",
        "pandas==2.3.0",
        "pandas_datareader==0.10.0",
        "pandas_market_calendars==5.1.0",
        "pandas_ta==0.3.14b0",
        "polars==1.31.0",
        "polygon==1.2.6",
        "pwb_toolbox==0.1.1",
        "pydantic==2.11.7",
        "pyecharts==2.0.8",
        "pyfolio==0.9.2",
        "pyfolio_reloaded==0.9.8",
        "pytest==8.3.5",
        "python-dotenv==1.1.0",
        "python_dateutil==2.9.0.post0",
        "python_Levenshtein==0.27.1",
        "pytz==2024.2",
        "quantstats==0.0.64",
        "ray==2.43.0",
        "Requests==2.32.4",
        "rich==14.0.0",
        "scikit_learn==1.7.0",
        "scipy==1.15.3",
        "setuptools==75.8.0",
        "sortedcontainers==2.4.0",
        "sphinx_rtd_theme==3.0.2",
        "stable_baselines3==2.5.0",
        "statsmodels==0.14.2",
        "stockstats==0.6.4",
        "ta==0.11.0",
        "TA_Lib==0.4.32",
        "tabulate==0.9.0",
        "tenacity==8.3.0",
        "tiktoken==0.8.0",
        "toml==0.10.2",
        "torch==2.4.1",
        "torch_geometric==2.6.1",
        "tqdm==4.66.5",
        "transformers==4.45.1",
        "tushare==1.4.13",
        "typer==0.16.0",
        "vaderSentiment==3.3.2",
        "webdriver_manager==4.0.2",
        "xgboost==3.0.2",
        "yfinance==0.2.43",
    ],
    python_requires='>=3.10',
)