# 更新日志

Hypergraph-DB 项目的所有重要变更都记录在此文件中。

格式基于 [Keep a Changelog](https://keepachangelog.com/zh-CN/1.0.0/)，
并且本项目遵循 [语义化版本控制](https://semver.org/lang/zh-CN/)。

## [0.3.0] - 2025-10-14

### 新增
- 🎨 增强超图查看器的可视化交互和悬停效果
- 🔍 在查看器中为顶点和超边添加动态属性显示
- 📊 可视化中键值信息显示的增强
- 🎯 支持2节点条目的普通边，并基于超边进行集群分配
- 🌐 超图数据检索的API端点和动态数据加载
- 📦 将uv.lock添加到版本控制以确保可重现构建

### 改进
- 🔧 **主要类型系统改进**：增强类型注解并修复里氏替换原则违反问题
- ⚡ 改进基类和派生类的方法签名和返回类型
- 🎨 重构超图查看器，改进颜色映射和工具提示显示
- 🛠️ 增强CI/CD流水线，更新发布工作流和质量检查
- 📝 更新load()和save()方法返回bool类型以提高API一致性
- 🎛️ 改进顶点排序逻辑和查看器布局优化
- 🔍 更好的悬停交互和自定义G6库集成

### 修复
- 🐛 修复mypy类型错误和方法签名不匹配
- 🔧 纠正查看器组件中"Hypergraph"的拼写
- 📖 更新超图可视化文档
- 🎯 修复应返回List但返回Set的方法的返回类型
- 💾 改进字典类型注解以支持各种键类型
- 🎨 增强draw_hypergraph()函数与BaseHypergraphDB的兼容性

## [0.2.0] - 2025-09-09

### 新增
- 📖 添加中文文档支持
- 🌐 国际化 (i18n) 配置
- 📚 更完整的 API 文档
- 🎨 改进的可视化界面
- 从 Sphinx 迁移到 MkDocs 文档系统
- 高级使用模式和教程

### 改进
- 🔧 更好的错误处理
- ⚡ 性能优化
- 📝 更详细的代码示例
- 🧪 增强的测试覆盖
- 更新项目结构以适应现代 Python 开发
- 从 Poetry 迁移到 uv 进行依赖管理
- 通过自动化脚本增强开发工作流

### 修复
- 🐛 修复可视化渲染问题
- 📖 文档与代码一致性修复
- 🔗 修复内部链接问题

## [0.1.2] - 2024-12-22

### 修复
- 🐛 修复 `remove_e()` 函数的错误
- 📖 更新 README 文档

## [0.1.1] - 2024-12-16

### 新增
- 🧪 更全面的测试套件
- 📊 专用压力测试以确保系统稳定性和性能

### 改进
- ⚡ **重大性能提升**: 超图构建和查询速度提升100倍
  - 构建包含10,000个节点的超图并执行40,000次顶点和超边查询
  - v0.1.0耗时90秒，v0.1.1仅需0.05秒
- 改进的 API 设计和一致性
- 更好的文档和示例

## [0.1.0] - 2024-12-16

### 新增
- 🎉 Hypergraph-DB 首次发布
- 📊 基础超图数据结构实现
- 🎨 Web 可视化界面
- 📖 基础文档和 API 参考
- 🧪 基础测试套件

### 核心功能
- 🏗️ `Hypergraph` 核心类
- 🔗 超边（hyperedge）操作
- 📊 超点（hypervertex）操作
- 📈 基础图算法
- 🎯 邻居查询功能

### 可视化功能
- 🌐 Web 界面超图可视化
- 🎨 交互式超图展示
- 📱 响应式设计
- 🎛️ 可定制的视觉样式

### API 功能
- ➕ `add_hyperedge()` - 添加超边
- ➕ `add_hypervertex()` - 添加超点
- 🗑️ `remove_hyperedge()` - 删除超边
- 🗑️ `remove_hypervertex()` - 删除超点
- 📊 `degree_v()` - 计算超点度数
- 📊 `degree_e()` - 计算超边度数
- 🔍 `nbr_v_of_e()` - 查询超边的邻接超点
- 🔍 `nbr_e_of_v()` - 查询超点的邻接超边
- 🎨 `draw()` - 可视化超图
