# Code of Conduct

## Purpose

BRS-KB is a professional security project. We maintain a technical, focused environment for security research and development.

## Standards

### Expected Behavior

- **Technical Focus**: Keep discussions technical and relevant to XSS vulnerabilities
- **Respectful Communication**: Treat all contributors professionally
- **Constructive Feedback**: Provide actionable, specific feedback on contributions
- **Quality Contributions**: Submit well-researched, tested content
- **Proper Attribution**: Credit sources and original researchers

### Unacceptable Behavior

- **Malicious Code**: Never submit malicious payloads or backdoors
- **Personal Attacks**: No harassment, discrimination, or personal attacks
- **Spam**: No promotional content, advertising, or off-topic posts
- **Plagiarism**: Always credit original sources and researchers
- **Low-Quality Submissions**: Avoid untested or unverified information

## Contribution Quality

### Required for All Contributions

1. **Accuracy**: Information must be technically accurate
2. **Testing**: Attack vectors should be tested and verified
3. **Documentation**: Code and techniques must be well-documented
4. **English**: All content in English (per project standards)
5. **Professional**: No emojis, maintain professional tone

### Security Research Ethics

- Only share publicly known vulnerabilities
- Do not include 0-days or unreported vulnerabilities
- Follow responsible disclosure principles
- Respect security researchers' work and credits

## Enforcement

### Violations

Project maintainers have the right to:
- Remove, edit, or reject contributions that violate this code
- Ban temporarily or permanently any contributor for inappropriate behavior
- Close issues or pull requests that don't meet standards

### Reporting

To report violations:
- GitHub Issues: For public concerns
- Telegram: https://t.me/easyprotech (for private concerns)

## Scope

This Code of Conduct applies to:
- GitHub repository (issues, PRs, discussions)
- Project documentation
- Community interactions related to BRS-KB
- Public and private project communications

## Attribution

This Code of Conduct is focused on maintaining professional security research standards.

## Contact

- **Telegram**: https://t.me/easyprotech
- **GitHub**: https://github.com/EPTLLC/BRS-KB
- **BRS-XSS**: https://github.com/EPTLLC/brs-xss
- **BRS-Recon**: https://github.com/EPTLLC/brs-recon
- **BRS-GUI**: https://github.com/EPTLLC/BRS-GUI
- **BRS-GPT**: https://github.com/EPTLLC/brs-gpt

---

**Project**: BRS-KB  
**License**: MIT  
**Status**: Production-Ready

*Professional Security Research • Community Driven • Quality First*

