datascience_format_options = {
    'spotify' : {
        'attributes' : ['savedTracks', 'followedArtists', 'playHistory', 'savedPlaylists', 'profile'],
        'col_to_type' : {
            'addedAt' : 'raw_datetime',
            'album' : 'raw_string',
            'artists' : 'raw_list',
            'birthdate' : 'raw_date',
            'context' : 'raw_object',
            'context.external_urls.spotify' : 'url',
            'context.href' : 'raw_url',
            'context.type' : 'raw_enum',
            'context.uri' : 'raw_url',
            'country' : 'raw_string',
            'createdAt' : 'raw_datetime',
            'display_name' : 'raw_string',
            'email' : 'raw_email',
            'external_urls.spotify' : 'raw_url',
            'followers' : 'raw_integer',
            'followers.href' : 'raw_url',
            'followers.total' : 'raw_integer',
            'genres' : 'raw_list',
            'href' : 'raw_url',
            'id' : 'id',
            'images' : 'raw_list',
            'img' : 'raw_url',
            'latestPull' : 'raw_datetime',
            'metaData.acousticness' : 'raw_float',
            'metaData.analysis_url' : 'raw_url',
            'metaData.danceability' : 'raw_float',
            'metaData.duration_ms' : 'raw_integer',
            'metaData.energy' : 'raw_float',
            'metaData.id' : 'id',
            'metaData.instrumentalness' : 'raw_integer',
            'metaData.key' : 'raw_integer',
            'metaData.liveness' : 'raw_float',
            'metaData.loudness' : 'raw_float',
            'metaData.mode' : 'raw_integer',
            'metaData.speechiness' : 'raw_float',
            'metaData.tempo' : 'raw_float',
            'metaData.time_signature' : 'raw_integer',
            'metaData.track_href' : 'raw_url',
            'metaData.type' : 'raw_enum',
            'metaData.uri' : 'raw_url',
            'metaData.valence' : 'raw_float',
            'name' : 'raw_string',
            'numTracks' : 'raw_integer',
            'played_at' : 'raw_datetime',
            'popularity' : 'raw_integer',
            'previewUrl' : 'raw_url',
            'product' : 'raw_enum',
            'public' : 'raw_boolean',
            'timestamp' : 'raw_datetime',
            'track.artists' : 'raw_list',
            'track.duration_ms' : 'raw_integer',
            'track.explicit' : 'raw_boolean',
            'track.href' : 'raw_url',
            'track.id' : 'id',
            'track.name' : 'raw_string',
            'track.popularity' : 'raw_integer',
            'track.preview_url' : 'raw_url',
            'track.track_number' : 'raw_integer',
            'tracks' : 'raw_list',
            'type' : 'raw_enum',
            'updatedAt' : 'raw_datetime',
            'uri' : 'raw_url'
        },
        'date_str_strip' : '%Y-%m-%d',
        'indexes' : ['addedAt', 'timestamp', 'updatedAt', 'played_at'],
        'getAttributes' : {
            'topTracks' : 'tracks', 
            'topArtists' : 'artists'
        }
    },
    'reddit' : {
        'attributes' : ['subscribed', 'comments', 'karmaList', 'savedPosts', 'submittedPosts', 
                      'upvoted', 'downvoted', 'profile'],
        'col_to_type' : {
            'accountCreated' : 'raw_integer',
            'author' : 'raw_username_string',
            'commentKarma' : 'raw_integer',
            'created' : 'raw_datetime',
            'createdAt' : 'raw_datetime',
            'downs' : 'raw_integer',
            'id' : 'id',
            'isEmployee' : 'raw_boolean',
            'isGold' : 'raw_boolean',
            'isMod' : 'raw_boolean',
            'isSponsor' : 'raw_boolean',
            'isVideo' : 'raw_boolean',
            'kind' : 'raw_enum',
            'latestPull' : 'raw_datetime',
            'linkKarma' : 'raw_integer',
            'name' : 'raw_string',
            'numComments' : 'raw_integer',
            'numSubscribers' : 'raw_integer',
            'over18' : 'raw_boolean',
            'postBody' : 'raw_text',
            'saved' : 'raw_boolean',
            'score' : 'raw_integer',
            'subreddit' : 'raw_enum',
            'subreddit_id' : 'id',
            'title' : 'raw_text',
            'updatedAt' : 'raw_datetime',
            'ups' : 'raw_integer',
            'url' : 'raw_url',
            'username' : 'raw_username_string',
            'view_count' : 'raw_integer'
        },
        'indexes' : ['created', 'updatedAt']
    },
    'instagram' : {
        'attributes' : ['posts', 'likes', 'followers', 'following', 'counts', 'profile'],
        'col_to_type' : {
            '_filter' : 'raw_enum',
            'bio' : 'raw_text',
            'caption' : 'raw_text',
            'commentsCount' : 'raw_integer',
            'counts.followed_by' : 'raw_integer',
            'counts.follows' : 'raw_integer',
            'counts.media' : 'raw_integer',
            'createdAt' : 'raw_timestamp',
            'filter' : 'raw_enum',
            'followed_by' : 'raw_integer',
            'follows' : 'raw_integer',
            'full_name' : 'raw_string',
            'id' : 'id',
            'is_business' : 'raw_boolean',
            'latestPull' : 'raw_timestamp',
            'likesCount' : 'raw_integer',
            'link' : 'raw_url',
            'location' : 'raw_object',
            'location.id' : 'id',
            'location.latitude' : 'raw_float',
            'location.longitude' : 'raw_float',
            'location.name' : 'raw_string',
            'media' : 'raw_integer',
            'name' : 'raw_string',
            'photoURL' : 'raw_ur;',
            'postAuthorId' : 'id',
            'postAuthorName' : 'raw_string',
            'postAuthorUsername' : 'raw_username_string',
            'postType' : 'raw_enum',
            'profile_picture' : 'raw_url',
            'tags' : 'raw_list',
            'timePulled' : 'raw_datetime',
            'timestamp' : 'raw_datetime',
            'updatedAt' : 'raw_datetime',
            'username' : 'raw_username_string',
            'usersTagged' : 'raw_list',
            'website' : 'raw_url'
        },
        'indexes' : ['timestamp', 'timePulled', 'updatedAt']
    },
    'rescuetime' : {
        'attributes' : ['data'],
        'col_to_type' : {
            'activity' : 'raw_enum',
            'category' : 'raw_enum',
            'createdAt' : 'raw_timestamp',
            'date' : 'raw_timestamp',
            'latestPull' : 'raw_timestamp',
            'productivity' : 'raw_integer',
            'timeSpent' : 'raw_integer',
            'updatedAt' : 'raw_timestamp',   
        },
        'indexes' : ['date', 'updatedAt']
    },
    'youtube' : {
        'attributes' : ['uploadedVideos', 'subscriptions', 'myActivity', 'likes', 'profile'],
        'col_to_type' : {
            'accountCreated' : 'raw_datetime',
            'action.like.resourceId.kind' : 'raw_enum',
            'action.like.resourceId.videoId' : 'id',
            'action.playlistItem.playlistId' : 'id',
            'action.playlistItem.playlistItemId' : 'id',
            'action.playlistItem.resourceId.kind' : 'raw_enum',
            'action.playlistItem.resourceId.videoId' : 'id',
            'action.subscription.resourceId.channelId' : 'id',
            'action.subscription.resourceId.kind' : 'raw_enum',
            'action.upload.videoId' : 'id',
            'actionDetails.actionBy' : 'raw_string',
            'actionDetails.actionDate' : 'raw_datetime',
            'actionDetails.actionType' : 'raw_enum',
            'channelDescription' : 'raw_text',
            'channelId' : 'id',
            'channelTitle' : 'raw_string',
            'createdAt' : 'raw_datetime',
            'dateLiked' : 'raw_datetime',
            'description' : 'raw_text',
            'etag' : 'raw_url_end',
            'id' : 'id',
            'kind' : 'raw_enum',
            'latestPull' : 'raw_datetime',
            'likeId' : 'id',
            'relatedPlaylists.favorites' : 'raw_url_end',
            'relatedPlaylists.likes' : 'raw_url_end',
            'relatedPlaylists.uploads' : 'raw_url_end',
            'relatedPlaylists.watchHistory' : 'raw_url_end',
            'relatedPlaylists.watchLater' : 'raw_url_end',
            'subscribedAt' : 'raw_datetime',
            'thumbnails.default.height' : 'raw_integer',
            'thumbnails.default.url' : 'raw_url',
            'thumbnails.default.width' : 'raw_integer',
            'thumbnails.high.height' : 'raw_integer',
            'thumbnails.high.url' : 'raw_url',
            'thumbnails.high.width' : 'raw_integer',
            'thumbnails.maxres.height' : 'raw_integer',
            'thumbnails.maxres.url' : 'raw_url',
            'thumbnails.maxres.width' : 'raw_integer',
            'thumbnails.medium.height' : 'raw_integer',
            'thumbnails.medium.url' : 'raw_url',
            'thumbnails.medium.width' : 'raw_integer',
            'thumbnails.standard.height' : 'raw_integer',
            'thumbnails.standard.url' : 'raw_url',
            'thumbnails.standard.width' : 'raw_integer',
            'updatedAt' : 'raw_datetime',
            'videoDescription' : 'raw_text',
            'videoId' : 'id',
            'videoPublishedAt': 'raw_datetime',
            'videoThumbnails' : 'raw_object',
            'videoThumbnails.default.height' : 'raw_integer',
            'videoThumbnails.default.url' : 'raw_url',
            'videoThumbnails.default.width' : 'raw_integer',
            'videoThumbnails.high.height' : 'raw_integer',
            'videoThumbnails.high.url' : 'raw_url',
            'videoThumbnails.high.width' : 'raw_integer',
            'videoThumbnails.maxres.height' : 'raw_integer',
            'videoThumbnails.maxres.url' : 'raw_url',
            'videoThumbnails.maxres.width' : 'raw_integer',
            'videoThumbnails.medium.height' : 'raw_integer',
            'videoThumbnails.medium.url' : 'raw_url',
            'videoThumbnails.medium.width' : 'raw_integer',
            'videoThumbnails.standard.height' : 'raw_integer',
            'videoThumbnails.standard.url' : 'raw_url',
            'videoThumbnails.standard.width' : 'raw_integer',
            'videoTitle' : 'raw_text'
        },
        'indexes' : ['videoPublishedAt', 'subscribedAt', 'actionDetails.actionDate', 'dateLiked', 'updatedAt']
    },
    'linkedin' : {
         'additional_details' : ['formattedName', 'numConnections',  'firstName', 'headline', 
                              'lastName', 'industry', 'summary', 'siteStandardProfileRequest', 
                              'pictureUrl', 'location', 'publicProfileUrl', 'id',
                              'updatedAt', 'createdAt', 'latestPull'],
        'attributes' : ['shares', 'positions'],
        'col_to_type' : {
            'author.firstName' : 'raw_string',
            'author.id' : 'id',
            'author.lastName' : 'raw_string',
            'company.id' : 'id',
            'company.industry' : 'raw_enum',
            'company.name' : 'raw_string',
            'content.description' : 'raw_text',
            'content.eyebrowUrl' : 'raw_url',
            'content.resolvedUrl' : 'raw_url',
            'content.shortenedUrl' : 'raw_url',
            'content.submittedImageUrl' : 'raw_url',
            'content.submittedUrl' : 'raw_url',
            'content.thumbnailUrl' : 'raw_url',
            'content.title' : 'raw_text',
            'createdAt' : 'raw_datetime',
            'firstName' : 'raw_string',
            'formattedName' : 'raw_string',
            'headline' : 'raw_text',
            'id' : 'id',
            'industry' : 'raw_enum',
            'isCurrent' : 'raw_boolean',
            'lastName' : 'raw_string',
            'latestPull' : 'raw_datetime',
            'location.country.code' : 'raw_enum',
            'location.name' : 'raw_string',
            'numConnections' : 'raw_integer',
            'pictureUrl' : 'raw_url',
            'publicProfileUrl' : 'raw_url',
            'siteStandardProfileRequest.url': 'raw_url',
            'source.serviceProvider.name' : 'raw_string',
            'startDate.month' : 'raw_integer',
            'startDate.year' : 'raw_integer',
            'summary' : 'raw_text',
            'timestamp' : 'raw_datetime',
            'title' : 'raw_text',
            'updatedAt' : 'raw_datetime',
            'visibility.code' : 'raw_enum'            
        },
        'indexes' : ['timestamp', 'updatedAt']
    },
    'facebook' : {
        'additional_details' : ['picture', 'hometown', 'location', 'significant_other',
                              'locale', 'quotes', 'timezone', 'id', 'first_name', 'verified',
                                'name_format', 'political', 'religion', 'is_verified', 'email', 
                                'short_name', 'is_shared_login', 'birthday', 'link', 'name',
                                'gender', 'updated_time', 'updatedAt', 'createdAt', 'latestPull'],
        'attributes' : ['feed',  'television', 'videos', 'tagged_places', 'movies',
                        'friends', 'photos', 'books', 'music', 'likes', 'family', 'games',
                        'albums', 'video_broadcasts', 'events', 'permissions', 
                        'inspirational_people', 'education', 'sports', 'languages', 'security_settings',
                        'favourite_teams', 'currency', 'favourite_athletes', 'cover',
                        'devices', 'interested_in'],
        'collapse' : ['userEdges', 'userFields'],
        'col_to_type' : {
            'birthday' : 'raw_date',
            'classes' : 'raw_list',
            'concentration' : 'raw_list',
            'createdAt' : 'raw_datetime',
            'created_time' : 'raw_datetime',
            'currency_offset' : 'raw_float',
            'description' : 'raw_text',
            'email' : 'raw_email',
            'end_time' : 'raw_datetime',
            'first_name' : 'raw_string',
            'gender' : 'raw_enum',
            'hardware' : 'raw_string',
            'hometown.id' : 'id',
            'hometown.name' : 'raw_string',
            'id' : 'id',
            'interested_in' : 'raw_enum',
            'is_shared_login' : 'raw_boolean',
            'is_verified' : 'raw_boolean',
            'latestPull' : 'raw_datetime',
            'link' : 'raw_url',
            'locale' : 'raw_enum',
            'location.id' : 'id',
            'location.name' : 'raw_string',
            'message' : 'raw_text',
            'name' : 'raw_string',
            'name_format' : 'raw_string',
            'offset_x' : 'raw_int',
            'offset_y' : 'raw_int',
            'os' : 'raw_string',
            'permission' : 'raw_string',
            'picture.is_silhouette' : 'raw_boolean',
            'picture.url' : 'raw_url',
            'place' : 'raw_object',
            'place.id' : 'id',
            'place.location.city' : 'raw_string',
            'place.location.country' : 'raw_string',
            'place.location.latitude' : 'raw_boolean',
            'place.location.located_in' : 'id',
            'place.location.longitude' : 'raw_float',
            'place.location.state' : 'raw_string',
            'place.location.street' : 'raw_string',
            'place.location.zip' : 'raw_integer',
            'place.name' : 'raw_string',
            'political' : 'raw_string',
            'quotes' : 'raw_text',
            'relationship' : 'raw_enum',
            'religion' : 'raw_string',
            'rsvp_status' : 'raw_enum',
            'school.id' : 'id',
            'school.name' : 'raw_string',
            'secure_browsing.enabled' : 'raw_boolean',
            'short_name' : 'raw_string',
            'source' : 'raw_url',
            'start_time' : 'raw_datetime',
            'status' : 'raw_enum',
            'story' : 'raw_text',
            'timezone' : 'raw_integer',
            'type' : 'raw_enum',
            'updatedAt' : 'raw_datetime',
            'updated_time' : 'raw_datetime',
            'usd_exchange' : 'raw_float',
            'usd_exchange_inverse' : 'raw_float',
            'user_currency' : 'raw_enum',
            'verified' : 'raw_boolean',
            'with' : 'raw_list',
            'year' : 'raw_object',
            'year.id' : 'id',
            'year.name' : 'raw_string'
        },
        'indexes' : ['created_time', 'updatedAt', 'updated_time', 'start_time']
    },
    'fitbit' : {
        'additional_details' : ['displayName', 'id', 'updatedAt', 'createdAt', 'latestPull'],
        'attributes' : ['sleepData', 'fatData', 'bmiData', 'foodData', 'devices', 'weightData', 
                           'activityData', 'heartData', 'lifetimeStats'],
        'col_to_type' : {
            'best.total.distance.date' : 'raw_datetime',
            'best.total.distance.value' : 'raw_float',
            'best.total.floors.date' : 'raw_datetime',
            'best.total.floors.value' : 'raw_integer',
            'best.total.steps.date' : 'raw_datetime',
            'best.total.steps.value' : 'raw_integer',
            'best.tracker.distance.date' : 'raw_datetime',
            'best.tracker.distance.value' : 'raw_float',
            'best.tracker.floors.date' : 'raw_datetime',
            'best.tracker.floors.value' : 'raw_integer',
            'best.tracker.steps.date' : 'raw_datetime',
            'best.tracker.steps.value' : 'raw_integer',
            'createdAt' : 'raw_datetime',
            'date' : 'raw_datetime',
            'displayName' : 'raw_string',
            'foods' : 'raw_list',
            'goals.caloriesOut': 'raw_integer',
            'goals.distance': 'raw_float',
            'goals.floors': 'raw_integer',
            'goals.steps': 'raw_integer',
            'heartRateZones' : 'raw_object',
            'id' : 'id',
            'latestPull' : 'raw_datetime',
            'lifetime.total.caloriesOut' : 'raw_integer',
            'lifetime.total.distance' : 'raw_float',
            'lifetime.total.floors' : 'raw_integer',
            'lifetime.total.steps' : 'raw_integer',
            'lifetime.tracker.caloriesOut' : 'raw_integer',
            'lifetime.tracker.distance' : 'raw_float',
            'lifetime.tracker.floors' : 'raw_integer',
            'lifetime.tracker.steps' : 'raw_integer',
            'restingHeartRate' : 'raw_integer',
            'sleep' : 'raw_list',
            'summary.activityCalories' : 'raw_integer',
            'summary.calories': 'raw_integer',
            'summary.caloriesBMR' : 'raw_integer',
            'summary.caloriesOut': 'raw_integer',
            'summary.carbs': 'raw_integer',
            'summary.distances' : 'raw_list',
            'summary.elevation' : 'raw_float',
            'summary.fairlyActiveMinutes' : 'raw_integer',
            'summary.fat': 'raw_integer',
            'summary.fiber': 'raw_integer',
            'summary.floors' : 'raw_integer',
            'summary.lightlyActiveMinutes' : 'raw_integer',
            'summary.marginalCalories' : 'raw_integer',
            'summary.protein': 'raw_integer',
            'summary.sedentaryMinutes' : 'raw_integer',
            'summary.sodium': 'raw_integer',
            'summary.steps' : 'raw_integer',
            'summary.totalMinutesAsleep' : 'raw_integer',
            'summary.totalSleepRecords' : 'raw_integer',
            'summary.totalTimeInBed' : 'raw_integer',
            'summary.veryActiveMinutes' : 'raw_integer',
            'summary.water': 'raw_integer',
            'updatedAt' : 'raw_datetime',
            'value' : 'raw_float'
        },
        'indexes' : ['date', 'updatedAt']
    },
    'moves' : {
        'attributes' : ['places', 'summaries', 'storyline', 'profile'],
        'col_to_type' : {
            'caloriesAvailable' : 'raw_boolean',
            'createdAt' : 'raw_datetime',
            'currentTimeZone.id' : 'id',
            'currentTimeZone.offset' : 'raw_integer',
            'date' : 'raw_date',
            'firstDate' : 'raw_integer',
            'lastUpdate' : 'raw_datetime',
            'latestPull' : 'raw_datetime',
            'localization.firstWeekDay' : 'raw_integer',
            'localization.language' : 'raw_enum',
            'localization.locale' : 'raw_enum',
            'localization.metric' : 'raw_boolean',
            'platform' : 'raw_enum',
            'segments' : 'raw_list',
            'summary' : 'raw_list',
            'updatedAt' : 'raw_datetime',
            'userId' : 'id'  
        },
        'indexes' : ['lastUpdate', 'updatedAt', 'date'],
        'try_dates' : ['%Y%m%d', '%Y%m%dT%H%M%S%fZ', '%Y-%m-%dT%H:%M:%S.%fZ']
    }
}    