# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IncidentPostmortem(BaseModel):
    """
    IncidentPostmortem
    """ # noqa: E501
    body_updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the published postmortem body was last updated.")
    preview_key: Optional[StrictStr] = Field(default=None, description="A unique key that allows public access to preview the postmortem before it's published.")
    incident_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the incident this postmortem belongs to.")
    body_draft_updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the draft postmortem body was last updated.")
    body: Optional[StrictStr] = Field(default=None, description="The published content of the postmortem in Markdown format.")
    body_draft: Optional[StrictStr] = Field(default=None, description="The draft content of the postmortem that hasn't been published yet.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the postmortem was created.")
    updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the postmortem was last updated.")
    notify_subscribers: Optional[StrictBool] = Field(default=None, description="Whether to notify subscribers when the postmortem is published.")
    published_at: Optional[datetime] = Field(default=None, description="The timestamp when the postmortem was published and made publicly available.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the incident postmortem.")
    __properties: ClassVar[List[str]] = ["body_updated_at", "preview_key", "incident_id", "body_draft_updated_at", "body", "body_draft", "created_at", "updated_at", "notify_subscribers", "published_at", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IncidentPostmortem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "incident_id",
            "created_at",
            "updated_at",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IncidentPostmortem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "body_updated_at": obj.get("body_updated_at"),
            "preview_key": obj.get("preview_key"),
            "incident_id": obj.get("incident_id"),
            "body_draft_updated_at": obj.get("body_draft_updated_at"),
            "body": obj.get("body"),
            "body_draft": obj.get("body_draft"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "notify_subscribers": obj.get("notify_subscribers"),
            "published_at": obj.get("published_at"),
            "id": obj.get("id")
        })
        return _obj


