# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pingera.models.o_auth_provider import OAuthProvider
from typing import Optional, Set
from typing_extensions import Self

class LinkedOAuthAccount(BaseModel):
    """
    LinkedOAuthAccount
    """ # noqa: E501
    last_used_at: Optional[datetime] = Field(default=None, description="When this OAuth account was last used for login")
    provider: Optional[OAuthProvider] = None
    provider_email: Optional[StrictStr] = Field(default=None, description="Email address from OAuth provider")
    created_at: Optional[datetime] = Field(default=None, description="When the OAuth account was linked")
    provider_avatar_url: Optional[StrictStr] = Field(default=None, description="Avatar URL from OAuth provider")
    provider_name: Optional[StrictStr] = Field(default=None, description="Display name from OAuth provider")
    id: Optional[StrictStr] = Field(default=None, description="OAuth account link ID")
    __properties: ClassVar[List[str]] = ["last_used_at", "provider", "provider_email", "created_at", "provider_avatar_url", "provider_name", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LinkedOAuthAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "last_used_at",
            "provider",
            "provider_email",
            "created_at",
            "provider_avatar_url",
            "provider_name",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # set to None if last_used_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_used_at is None and "last_used_at" in self.model_fields_set:
            _dict['last_used_at'] = None

        # set to None if provider_avatar_url (nullable) is None
        # and model_fields_set contains the field
        if self.provider_avatar_url is None and "provider_avatar_url" in self.model_fields_set:
            _dict['provider_avatar_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LinkedOAuthAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "last_used_at": obj.get("last_used_at"),
            "provider": OAuthProvider.from_dict(obj["provider"]) if obj.get("provider") is not None else None,
            "provider_email": obj.get("provider_email"),
            "created_at": obj.get("created_at"),
            "provider_avatar_url": obj.get("provider_avatar_url"),
            "provider_name": obj.get("provider_name"),
            "id": obj.get("id")
        })
        return _obj


