# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from pingera.models.past_incident_update import PastIncidentUpdate
from typing import Optional, Set
from typing_extensions import Self

class LogPastIncident(BaseModel):
    """
    LogPastIncident
    """ # noqa: E501
    incident_updates: Annotated[List[PastIncidentUpdate], Field(min_length=1)] = Field(description="Array of incident updates in chronological order")
    name: StrictStr = Field(description="The name of the incident")
    deliver_notifications: Optional[StrictBool] = Field(default=False, description="Whether to send notifications")
    impact: StrictStr = Field(description="The impact level of the incident")
    __properties: ClassVar[List[str]] = ["incident_updates", "name", "deliver_notifications", "impact"]

    @field_validator('impact')
    def impact_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['minor', 'major', 'critical']):
            raise ValueError("must be one of enum values ('minor', 'major', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LogPastIncident from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in incident_updates (list)
        _items = []
        if self.incident_updates:
            for _item_incident_updates in self.incident_updates:
                if _item_incident_updates:
                    _items.append(_item_incident_updates.to_dict())
            _dict['incident_updates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LogPastIncident from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "incident_updates": [PastIncidentUpdate.from_dict(_item) for _item in obj["incident_updates"]] if obj.get("incident_updates") is not None else None,
            "name": obj.get("name"),
            "deliver_notifications": obj.get("deliver_notifications") if obj.get("deliver_notifications") is not None else False,
            "impact": obj.get("impact")
        })
        return _obj


