# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Secret2(BaseModel):
    """
    Secret2
    """ # noqa: E501
    secret_value: Optional[StrictStr] = Field(default=None, description="The secret value. This will be encrypted in storage but returned in API responses.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the secret was created in ISO format.")
    secret_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=100)]] = Field(default=None, description="A unique name for the secret within the organization. Max 100 characters.")
    updated_by: Optional[StrictStr] = Field(default=None, description="The ID of the user who last updated the secret.")
    updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the secret was last updated in ISO format.")
    created_by: Optional[StrictStr] = Field(default=None, description="The ID of the user who created the secret.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the secret.")
    __properties: ClassVar[List[str]] = ["secret_value", "created_at", "secret_name", "updated_by", "updated_at", "created_by", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Secret2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "updated_by",
            "updated_at",
            "created_by",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Secret2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "secret_value": obj.get("secret_value"),
            "created_at": obj.get("created_at"),
            "secret_name": obj.get("secret_name"),
            "updated_by": obj.get("updated_by"),
            "updated_at": obj.get("updated_at"),
            "created_by": obj.get("created_by"),
            "id": obj.get("id")
        })
        return _obj


