# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pingera.models.check_server import CheckServer
from typing import Optional, Set
from typing_extensions import Self

class UnifiedResult(BaseModel):
    """
    UnifiedResult
    """ # noqa: E501
    response_time: Optional[StrictInt] = Field(default=None, description="The response time in milliseconds.")
    check_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata from the check.")
    check_server_id: Optional[StrictStr] = None
    status: Optional[StrictStr] = Field(default=None, description="The result status of the check execution.")
    created_at: Optional[datetime] = None
    check_type: Optional[StrictStr] = Field(default=None, description="The type of check performed (e.g., web, api, ssl).")
    check_id: Optional[StrictStr] = Field(default=None, description="The identifier of the monitor check, if applicable.")
    result_type: Optional[StrictStr] = Field(default=None, description="Type of the result.")
    check_server: Optional[CheckServer] = None
    region: Optional[StrictStr] = Field(default=None, description="The region where the check was executed from.")
    check_name: Optional[StrictStr] = Field(default=None, description="The name of the check.")
    error_message: Optional[StrictStr] = Field(default=None, description="Error message if the check failed.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the result or job.")
    __properties: ClassVar[List[str]] = ["response_time", "check_metadata", "check_server_id", "status", "created_at", "check_type", "check_id", "result_type", "check_server", "region", "check_name", "error_message", "id"]

    @field_validator('result_type')
    def result_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['regular', 'on_demand']):
            raise ValueError("must be one of enum values ('regular', 'on_demand')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UnifiedResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "check_type",
            "result_type",
            "check_server",
            "region",
            "check_name",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of check_server
        if self.check_server:
            _dict['check_server'] = self.check_server.to_dict()
        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UnifiedResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "response_time": obj.get("response_time"),
            "check_metadata": obj.get("check_metadata"),
            "check_server_id": obj.get("check_server_id"),
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "check_type": obj.get("check_type"),
            "check_id": obj.get("check_id"),
            "result_type": obj.get("result_type"),
            "check_server": CheckServer.from_dict(obj["check_server"]) if obj.get("check_server") is not None else None,
            "region": obj.get("region"),
            "check_name": obj.get("check_name"),
            "error_message": obj.get("error_message"),
            "id": obj.get("id")
        })
        return _obj


