"""Add expected file source and handling options.

Revision ID: 29c521f4449c
Revises: 2ad667bb4592
Create Date: 2013-04-03 22:13:32.034983

"""

# revision identifiers, used by Alembic.
revision = '29c521f4449c'
down_revision = '2ad667bb4592'

from alembic import op
import sqlalchemy as sa

output_type_type = sa.Enum(u'diff', u'image', u'text', name=u'output_type')
source_type = sa.Enum(u'file', u'stderr', u'stdout', name=u'source')


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    output_type_type.create(op.get_bind(), checkfirst=False)
    source_type.create(op.get_bind(), checkfirst=False)
    op.add_column('testcase', sa.Column(
            'source', source_type, server_default='stdout', nullable=False))
    op.add_column('testcase', sa.Column('output_filename', sa.Unicode(),
                                        nullable=True))
    op.add_column('testcase', sa.Column(
            'output_type', output_type_type, server_default='diff',
            nullable=False))
    op.alter_column('testcase', u'expected_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('testcase', u'expected_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.drop_column('testcase', 'output_type')
    op.drop_column('testcase', 'output_filename')
    op.drop_column('testcase', 'source')
    source_type.drop(op.get_bind(), checkfirst=False)
    output_type_type.drop(op.get_bind(), checkfirst=False)

    ### end Alembic commands ###
