"""Add points to TestableResult.

Revision ID: 305b60854a99
Revises: 4d7019b218d4
Create Date: 2013-10-27 22:07:10.819122

"""

# revision identifiers, used by Alembic.
revision = '305b60854a99'
down_revision = '1cf84ddb034c'

from alembic import op
from collections import defaultdict
from sqlalchemy.sql import table, column
import sqlalchemy as sa

make_status = sa.Enum(u'make_failed', u'nonexistent_executable', u'success',
                      name=u'make_status')

testableresult = table('testableresult',
                       column('id', sa.Integer),
                       column('points', sa.Integer),
                       column('status', make_status),
                       column('submission_id', sa.Integer),
                       column('testable_id', sa.Integer))

testcase = table('testcase',
                 column('id', sa.Integer),
                 column('points', sa.Integer),
                 column('testable_id', sa.Integer))

testcaseresult = table('testcaseresult',
                       column('diff_id', sa.Integer),
                       column('status',
                              sa.Enum('nonexistent_executable',
                                      'output_limit_exceeded',
                                      'signal', 'success', 'timed_out',
                                      name='status')),
                       column('submission_id', sa.Integer),
                       column('test_case_id', sa.Integer))


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('submission', u'points_possible')
    op.drop_column('submission', u'points')
    op.add_column('testableresult', sa.Column('points', sa.Integer(),
                                              nullable=True))
    conn = op.get_bind()
    # Fetch the points for each test case
    tc_points = {}
    tc_to_t = {}
    for (tc_id, points, t_id) in conn.execute(testcase.select()):
        tc_points[tc_id] = points
        tc_to_t[tc_id] = t_id
    # Fetch all the testableresults
    tr_scores = defaultdict(int)
    s_to_tr = defaultdict(dict)
    for (tr_id, _, status, s_id, t_id) in \
            conn.execute(testableresult.select()):
        if status != 'success':
            tr_scores[tr_id] = 0
        else:
            s_to_tr[s_id][t_id] = tr_id
    # update points for the testableresult associated with each testcaseresult
    for (diff, status, s_id, tc_id) in conn.execute(testcaseresult.select()):
        points = 0
        # Assumes diff is None when it matches
        if status == 'success' and not diff:
            points = tc_points[tc_id]
        tr_scores[s_to_tr[s_id][tc_to_t[tc_id]]] += points
    scores = [{'tr_id': x, 'points': y} for (x, y) in tr_scores.items()]
    conn.execute(testableresult.update()
                 .where(testableresult.c.id == sa.bindparam('tr_id'))
                 .values(points=sa.bindparam('points')), scores)

    op.alter_column('testableresult', u'points', existing_type=sa.Integer,
                    nullable=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('testableresult', 'points')
    op.add_column('submission', sa.Column(u'points', sa.INTEGER(),
                                          server_default='0', nullable=False))
    op.add_column('submission', sa.Column(u'points_possible', sa.INTEGER(),
                                          server_default='0', nullable=False))
    ### end Alembic commands ###
