"""Add status field to project and remove is_ready field.

Revision ID: 32da2a33a6cc
Revises: 41dda8349f27
Create Date: 2013-10-08 22:41:31.545627

"""

# revision identifiers, used by Alembic.
revision = '32da2a33a6cc'
down_revision = '41dda8349f27'

from alembic import op
import sqlalchemy as sa

status_type = sa.Enum(u'locked', u'notready', u'ready', name=u'proj_status')
project = sa.sql.table('project', sa.Column(u'is_ready', sa.Boolean),
                       sa.Column(u'status', status_type))



def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    status_type.create(op.get_bind(), checkfirst=False)
    op.add_column('project', sa.Column('status', status_type,
                                       server_default=u'notready',
                                       nullable=False))
    op.execute(project.update().where(project.c.is_ready)
               .values(status=u'ready'))
    op.drop_column('project', u'is_ready')
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column('project', sa.Column(u'is_ready', sa.BOOLEAN(),
                                       nullable=False, server_default=u'0'))
    op.execute(project.update().where(project.c.status == 'ready')
               .values(is_ready=True))
    op.drop_column('project', 'status')
    status_type.drop(op.get_bind(), checkfirst=False)
    ### end Alembic commands ###
