"""Remove ProjectView table.

Revision ID: 38b07be99394
Revises: 2a3f02244cb4
Create Date: 2014-02-18 12:04:14.294587

"""

# revision identifiers, used by Alembic.
revision = '38b07be99394'
down_revision = '2a3f02244cb4'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

group = sa.sql.table('group',
                     sa.Column(u'id', sa.Integer),
                     sa.Column(u'project_id', sa.Integer),
                     sa.Column(u'viewed_at', sa.DateTime(timezone=True),
                               nullable=True))
pv = sa.sql.table('projectview',
                  sa.Column(u'group_id', sa.Integer),
                  sa.Column(u'project_id', sa.Integer),
                  sa.Column(u'created_at', sa.DateTime(timezone=True)))



def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column('group', sa.Column('viewed_at', sa.DateTime(timezone=True),
                                     nullable=True))
    op.execute(group.update().where(group.c.id==pv.c.group_id)
               .values(viewed_at=pv.c.created_at))

    op.drop_table('projectview')
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('projectview',
    sa.Column('created_at', postgresql.TIMESTAMP(timezone=True),
              autoincrement=False, nullable=False),
    sa.Column('project_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['group_id'], [u'group.id'],
                            name=u'projectview_group_id_fkey'),
    sa.ForeignKeyConstraint(['project_id'], [u'project.id'],
                            name=u'projectview_project_id_fkey'),
    sa.PrimaryKeyConstraint('project_id', 'group_id', name=u'projectview_pkey')
    )

    # Recreate ProjectViews
    pvs = []

    conn = op.get_bind()
    for (g_id, p_id, viewed_at) in conn.execute(group.select()):
        if viewed_at:
            pvs.append({'group_id': g_id, 'project_id': p_id,
                        'created_at': viewed_at})
    op.bulk_insert(pv, pvs)

    # Drop the viewed_at column
    op.drop_column('group', 'viewed_at')

    ### end Alembic commands ###
