"""Refactor make process result status handling.

Revision ID: 4d7019b218d4
Revises: 344c3f86394c
Create Date: 2013-10-26 14:30:23.680114

"""

# revision identifiers, used by Alembic.
revision = '4d7019b218d4'
down_revision = '344c3f86394c'

from alembic import op
from sqlalchemy.sql import table, column
from collections import defaultdict
import sqlalchemy as sa

make_status = sa.Enum(u'make_failed', u'nonexistent_executable', u'success',
                      name=u'make_status')

testable = table('testable',
                 column('id', sa.Integer),
                 column('make_target', sa.Unicode))

testableresult = table('testableresult',
                       column('id', sa.Integer),
                       column('make_results', sa.UnicodeText),
                       column('status', make_status),
                       column('submission_id', sa.Integer),
                       column('testable_id', sa.Integer))

testcase = table('testcase',
                 column('id', sa.Integer),
                 column('testable_id', sa.Integer))

testcaseresult = table('testcaseresult',
                       column('submission_id', sa.Integer),
                       column('test_case_id', sa.Integer))


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    make_status.create(op.get_bind(), checkfirst=False)
    op.add_column('testableresult',
                  sa.Column('status', make_status, nullable=True))
    op.alter_column('testableresult', u'make_results',
                    existing_type=sa.UnicodeText(),
                    nullable=True)

    # Retroactively set status
    conn = op.get_bind()
    update_to = {'make_failed': [], 'nonexistent_executable': [],
                 'success': []}
    blank_verify = defaultdict(list)
    success_verify = defaultdict(list)
    s_to_tr = defaultdict(dict)
    for (tr_id, make, _, s_id, t_id) in conn.execute(testableresult.select()):
        if make == '':
            # We need to verify that the testable does not have a makefile
            blank_verify[t_id].append(tr_id)
        elif make.startswith('Expected executable'):
            update_to['nonexistent_executable'].append(tr_id)
        else:
            # We need to verify if there are test cases and at least one result
            success_verify[t_id].append(s_id)
            s_to_tr[s_id][t_id] = tr_id

    # Verify we should test certain testables' make results to blank
    blank = []
    for (t_id, target) in conn.execute(testable.select()
                                       .where(testable.c.id
                                              .in_(blank_verify.keys()))):
        assert target is None
        blank.extend(blank_verify[t_id])
        update_to['success'].extend(blank_verify[t_id])
    # Blank out the make results
    op.execute(testableresult.update()
               .where(testableresult.c.id.in_(blank))
               .values(make_results=None))

    # Create testcase to testable mapping and prune success_verify
    tc_to_t = {}
    for (tc_id, t_id) in conn.execute(testcase.select()):
        tc_to_t[tc_id] = t_id
        if t_id in success_verify:
            del success_verify[t_id]
    assert not success_verify  # Each testable should have a test case

    # Determine which testables have results (make succeeded)
    for (s_id, tc_id) in conn.execute(testcaseresult.select()
                                      .where(testcaseresult.c.submission_id
                                             .in_(s_to_tr.keys()))):
        t_id = tc_to_t[tc_id]
        if s_id in s_to_tr and t_id in s_to_tr[s_id]:
            update_to['success'].append(s_to_tr[s_id][t_id])
            del s_to_tr[s_id][t_id]

    for ts in s_to_tr.values():
        update_to['make_failed'].extend(ts.values())

    # Set status for each testable
    for status, ids in update_to.items():
        if not ids:
            continue
        op.execute(testableresult.update().where(testableresult.c.id.in_(ids))
                   .values(status=status))

    op.alter_column('testableresult', u'status', existing_type=make_status,
                    nullable=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('testableresult', 'status')

    op.execute(testableresult.update()
               .where(testableresult.c.make_results == None)
               .values(make_results=u''))

    op.alter_column('testableresult', u'make_results',
                    existing_type=sa.UnicodeText(),
                    nullable=False)
    make_status.drop(op.get_bind(), checkfirst=False)
    ### end Alembic commands ###
