"""Associate submissions to users through project groups.

Revision ID: a364e6e9c14
Revises: 34ac45196731
Create Date: 2013-09-18 16:24:20.626636

"""

# revision identifiers, used by Alembic.
revision = 'a364e6e9c14'
down_revision = '34ac45196731'

from alembic import op
from sqlalchemy.sql import table, column
import sqlalchemy as sa


submission = table('submission',
                   column('id', sa.Integer),
                   column('created_at', sa.DateTime(timezone=True)),
                   column('user_id', sa.Integer),
                   column('group_id', sa.Integer),
                   column('project_id', sa.Integer))

group = table('group',
              column('id', sa.Integer),
              column('created_at', sa.DateTime(timezone=True)),
              column('project_id', sa.Integer))

usertogroup = table('user_to_group',
                    column('created_at', sa.DateTime(timezone=True)),
                    column('group_id', sa.Integer),
                    column('project_id', sa.Integer),
                    column('user_id', sa.Integer))

project_view = table('projectview')


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('group',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['project_id'], [u'project.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table(u'user_to_group',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('group_id', sa.Integer(), nullable=False),
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['group_id'], [u'group.id'], ),
    sa.ForeignKeyConstraint(['project_id'], [u'project.id'], ),
    sa.ForeignKeyConstraint(['user_id'], [u'user.id'], ),
    sa.PrimaryKeyConstraint('project_id', 'user_id')
    )
    op.add_column(u'submission', sa.Column('group_id', sa.Integer()))

    # Migrate all the data
    conn = op.get_bind()
    groups = []
    group_mapping = {}
    subs = []
    user_to_group = []
    for (key, created_at, user_id, _, project_id) \
            in conn.execute(submission.select()):
        group_key = (user_id, project_id)
        sub = (key, created_at, user_id, project_id)
        if group_key not in group_mapping:
            group_id = len(groups)
            groups.append({'id': group_id, 'created_at': created_at,
                          'project_id': project_id})
            group_mapping[group_key] = group_id
            user_to_group.append({'created_at': created_at,
                                  'group_id': group_id,
                                  'project_id': project_id,
                                  'user_id': user_id})
        else:
            group_id = group_mapping[group_key]
        subs.append({'s_id': key, 'group_id': group_id})

    # Create all the groups and associations
    op.bulk_insert(group, groups)
    op.bulk_insert(usertogroup, user_to_group)

    # Update submission to point to group
    conn.execute(submission.update()
                 .where(submission.c.id == sa.bindparam('s_id'))
                 .values(group_id=sa.bindparam('group_id')), subs)

    # Make the group_id not nullable
    op.alter_column(u'submission', u'group_id', existing_type=sa.INTEGER(),
                    nullable=False)

    # Rename the user mapping column
    op.alter_column(u'submission', u'user_id',
                    new_column_name=u'created_by_id')

    # Update the foreign keys
    op.drop_constraint(u'submission_user_id_fkey', u'submission')
    op.create_foreign_key(u'submission_created_by_id_fkey', u'submission',
                          u'user', [u'created_by_id'], [u'id'])
    op.create_foreign_key(u'submission_group_id_fkey', u'submission',
                          u'group', [u'group_id'], [u'id'])


    # Clear the project view table (should be emptied every once in a while)
    op.execute(project_view.delete())
    # Associate with groups not users
    op.alter_column(u'projectview', u'user_id',
                    new_column_name=u'group_id')
    op.drop_constraint(u'projectview_user_id_fkey', u'projectview')
    op.create_foreign_key(u'projectview_group_id_fkey', u'projectview',
                          u'group', [u'group_id'], [u'id'])


    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    # Clear the project view table (should be emptied every once in a while)
    op.execute(project_view.delete())
    # Associate projectview with users not groups
    op.alter_column(u'projectview', u'group_id',
                    new_column_name=u'user_id')
    op.drop_constraint(u'projectview_group_id_fkey', u'projectview')
    op.create_foreign_key(u'projectview_user_id_fkey', u'projectview', u'user',
                          [u'user_id'], [u'id'])

    # Update submission objects and group groups
    op.alter_column(u'submission', u'created_by_id',
                    new_column_name=u'user_id')

    # Update the foreign keys
    op.drop_constraint(u'submission_group_id_fkey', u'submission')
    op.drop_constraint(u'submission_created_by_id_fkey', u'submission')
    op.create_foreign_key(u'submission_user_id_fkey', u'submission',
                          u'user', [u'user_id'], [u'id'])

    op.drop_column(u'submission', 'group_id')
    op.drop_table(u'user_to_group')
    op.drop_table('group')


    ### end Alembic commands ###
