# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .parameter_location import ParameterLocation

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProblematicParameter(pydantic.BaseModel):
    id: str = pydantic.Field()
    """
    If the `location` of the parameter is `body`, this value is always a JSON Pointer, otherwise it's the name of the parameter.
    """

    location: ParameterLocation = pydantic.Field()
    """
    The location of the parameter. Possible values are `query`, `header`, `path` or `body`.
    """

    value: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    The given value of the parameter.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
