# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...engine.types.api_response import ApiResponse
from ...ticketing.types.priority import Priority

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TicketingWebhookResponse(ApiResponse):
    ticket_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the ticket in the ticketing system.
    """

    entity_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date pertiment to webhook operation e.g. if its TicketCreated would be creation date. This comes directly from the ticketing system without any date formatting changes.
    """

    priority: typing.Optional[Priority] = pydantic.Field(default=None)
    """
    The priority of the ticket.
    """

    short_description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Short Description of the ticket in the ticketing system.
    """

    raw_payload: str = pydantic.Field()
    """
    The Raw JSON that was sent by the ticketing system for this webhook event.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
