# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .scan_type_id import ScanTypeId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Scan(pydantic.BaseModel):
    """
    The Scan object describes characteristics of a proactive scan.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The administrator-supplied or application-generated name of the scan. For example: "Home office weekly user database scan", "Scan folders for viruses", "Full system virus scan"
    """

    targets: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Hosts or IP addresses targeted by the scan.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of scan.
    """

    type_id: ScanTypeId = pydantic.Field()
    """
    The type id of the scan.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The application-defined unique identifier assigned to an instance of a scan.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
