# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...account_base.types.account_id import AccountId
from ...bridges.types.bridge_group_id import BridgeGroupId
from ...integration_base.types.integration_id import IntegrationId
from ...member_base.types.member_id import MemberId
from .audit_type import AuditType
from .http_method import HttpMethod

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Audit(pydantic.BaseModel):
    environment: str
    created_at: dt.datetime = pydantic.Field()
    """
    Time when the API request occurred.
    """

    remote_addr: str
    user_agent: str
    audit_type: AuditType
    method: HttpMethod
    path: str
    code: str
    body: typing.Optional[typing.Any] = None
    response: typing.Optional[str] = None
    status: typing.Optional[str] = None
    member_id: typing.Optional[MemberId] = None
    account_id: typing.Optional[AccountId] = None
    integration_id: typing.Optional[IntegrationId] = None
    bridge_group_id: typing.Optional[BridgeGroupId] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
