# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...capabilities_base.types.category_id import CategoryId
from ...capabilities_base.types.provider_id import ProviderId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Connector(pydantic.BaseModel):
    """
    Provides details of the Connector.
    """

    id: CategoryId = pydantic.Field()
    """
    Unique identifier for the Connector.
    """

    name: CategoryId = pydantic.Field()
    """
    Name of the connector.
    """

    fullname: str = pydantic.Field()
    """
    Display name of the Connector.
    """

    description: str = pydantic.Field()
    """
    Description of the Connector.
    """

    provider_ids: typing.List[ProviderId] = pydantic.Field()
    """
    List of Providers that implement the Connector.
    """

    providers: typing.Optional[typing.List[ProviderCapabilities]] = pydantic.Field(default=None)
    """
    List of capabilities for Providers that implement the Connector.
    """

    connector: typing.Optional[CategoryId] = pydantic.Field(default=None)
    """
    DEPRECATED – use `id` instead.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}


from .provider_capabilities import ProviderCapabilities  # noqa: E402

Connector.update_forward_refs()
