# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ProviderAvailability(str, enum.Enum):
    IN_DEVELOPMENT = "in-development"
    """
    Currently in active development.
    """

    PRE_RELEASE = "pre-release"
    """
    Available for use, but not ready for production.
    """

    DEPRECATED = "deprecated"
    """
    Will be removed in the future.
    """

    GENERALLY_AVAILABLE = "generally-available"
    """
    Stable and available for production use.
    """

    def visit(
        self,
        in_development: typing.Callable[[], T_Result],
        pre_release: typing.Callable[[], T_Result],
        deprecated: typing.Callable[[], T_Result],
        generally_available: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ProviderAvailability.IN_DEVELOPMENT:
            return in_development()
        if self is ProviderAvailability.PRE_RELEASE:
            return pre_release()
        if self is ProviderAvailability.DEPRECATED:
            return deprecated()
        if self is ProviderAvailability.GENERALLY_AVAILABLE:
            return generally_available()
