# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...common.types.action_id import ActionId
from ...common.types.resource_id import ResourceId
from .mapping_data_type import MappingDataType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AdditionalMapping(pydantic.BaseModel):
    resource: ResourceId = pydantic.Field()
    """
    The resources that this mapping applies to.
    """

    actions: typing.List[ActionId] = pydantic.Field()
    """
    The actions that this mapping applies to. At least one action must be specified.
    """

    source: str = pydantic.Field()
    """
    The dot-separated path to the field in the source data coming from the provider. Use `\.` to escape literal dots in the field name.
    """

    destination: str = pydantic.Field()
    """
    The dot-separated path to where the data should reside in the custom fields object when data is returned from the provider.
    """

    literal: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, the value in 'source' is treated as a literal value rather than a mapping. This allows adding static values to custom fields. Default: false
    """

    data_type: MappingDataType = pydantic.Field()
    """
    The data type of the field. This ensures the data is processed to the correct type when mapping. Fields set to 'any' will not get validated
    or processed. Other types are cast depending as defined by each provider. For example, a field with 'datetime' is parsed based on the date
    format used by the provider, and normalized to a unix timestamp with millisecond precision.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
