# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .q_radar_credential import QRadarCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SiemQRadar(pydantic.BaseModel):
    """
    Configuration for IBM QRadar SIEM.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/qradar-setup)
    """

    collection_port: int = pydantic.Field()
    """
    Port used by QRadar to accept incoming HTTP Receiver events.
    """

    credential: QRadarCredential
    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the QRadar TLS certificate.
    """

    url: str = pydantic.Field()
    """
    Base URL for the QRadar API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
