# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .aws_s_3_credential import AwsS3Credential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class StorageAwsS3(pydantic.BaseModel):
    """
    Configuration for Amazon S3.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/aws-s3-storage-setup)
    """

    bucket: str = pydantic.Field()
    """
    Name of the Amazon S3 bucket where files are stored.
    """

    credential: AwsS3Credential
    endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    Endpoint used for connecting to Amazon S3 the external service. If not provided, the default Amazon S3 endpoint will be used.
    """

    region: str = pydantic.Field()
    """
    AWS region where the Amazon S3 bucket is located.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
