# Copyright (c) 2023 - 2025, AG2ai, Inc., AG2ai open-source projects maintainers and core contributors
#
# SPDX-License-Identifier: Apache-2.0
#
__all__: list[str] = []

from .available_condition import ExpressionAvailableCondition, StringAvailableCondition
from .context_condition import ExpressionContextCondition, StringContextCondition
from .context_expression import ContextExpression
from .context_str import ContextStr
from .context_variables import ContextVariables
from .handoffs import Handoffs
from .llm_condition import ContextStrLLMCondition, StringLLMCondition
from .on_condition import OnCondition
from .on_context_condition import OnContextCondition
from .reply_result import ReplyResult
from .speaker_selection_result import SpeakerSelectionResult
from .targets.group_chat_target import GroupChatConfig, GroupChatTarget

"""
from .targets.group_manager_target import (
    GroupManagerSelectionMessageContextStr,
    GroupManagerSelectionMessageString,
    GroupManagerTarget,
)
"""
from .targets.function_target import FunctionTarget, FunctionTargetResult
from .targets.transition_target import (
    AgentNameTarget,
    AgentTarget,
    AskUserTarget,
    NestedChatTarget,
    RevertToUserTarget,
    StayTarget,
    TerminateTarget,
)

__all__ = [
    "AgentNameTarget",
    "AgentTarget",
    "AskUserTarget",
    "ContextExpression",
    "ContextStr",
    "ContextStrLLMCondition",
    "ContextVariables",
    "ExpressionAvailableCondition",
    "ExpressionContextCondition",
    "FunctionTarget",
    "FunctionTargetResult",
    "GroupChatConfig",
    "GroupChatTarget",
    # "GroupManagerSelectionMessageContextStr",
    # "GroupManagerSelectionMessageString",
    # "GroupManagerTarget",
    "Handoffs",
    "NestedChatTarget",
    "OnCondition",
    "OnContextCondition",
    "ReplyResult",
    "RevertToUserTarget",
    "SpeakerSelectionResult",
    "StayTarget",
    "StringAvailableCondition",
    "StringContextCondition",
    "StringLLMCondition",
    "TerminateTarget",
]
