
# this script runs some tests on the similarity measures to ensure they have the expected behavior when computing the similarity between (1) two completely dissimilar spectra and (2) two identical spectra
from pycompound.similarity_measures import *
import numpy as np


intensities_A = np.array([0,0.2,0.1,0,0.5,0.2])
intensities_B = np.array([0.3,0,0,0.7,0,0])
sim_mixture = S_mixture(intensities_A, intensities_B, weights={'Cosine':0.25, 'Shannon':0.25, 'Renyi':0.25, 'Tsallis':0.25}, q=1.5)
print(f'\nIntensities of spectrum A: {intensities_A}')
print(f'Intensities of spectrum B: {intensities_B}')
print(f'Cosine similarity between spectrum A and spectrum B: {S_cos(intensities_A,intensities_B)}')
print(f'Shannon Entropy similarity between spectrum A and spectrum B: {S_shannon(intensities_A,intensities_B)}')
print(f'Renyi Entropy similarity between spectrum A and spectrum B with entropy dimension 1.5: {S_renyi(intensities_A,intensities_B,1.5)}')
print(f'Tsallis Entropy similarity between spectrum A and spectrum B with entropy dimension 1.5: {S_tsallis(intensities_A,intensities_B,1.5)}')
print(f'Similarity between spectrum A and spectrum B with respect to mixture of all four similarity measures with equal weights with entropy dimension 1.5: {sim_mixture}')
print(f'Jaccard similarity between spectrum A and spectrum B: {S_jaccard(intensities_A,intensities_B)}')
print(f'Dice similarity between spectrum A and spectrum B: {S_dice(intensities_A,intensities_B)}')
print(f'3W-Jaccard similarity between spectrum A and spectrum B: {S_3w_jaccard(intensities_A,intensities_B)}')
print(f'Sokal-Sneath similarity between spectrum A and spectrum B: {S_sokal_sneath(intensities_A,intensities_B)}')
print(f'Binary Cosine similarity between spectrum A and spectrum B: {S_binary_cosine(intensities_A,intensities_B)}')
print(f'Mountford similarity between spectrum A and spectrum B: {S_mountford(intensities_A,intensities_B)}')
print(f'McConnaughey similarity between spectrum A and spectrum B: {S_mcconnaughey(intensities_A,intensities_B)}')
print(f'Driver-Kroeber similarity between spectrum A and spectrum B: {S_driver_kroeber(intensities_A,intensities_B)}')
print(f'Simpson similarity between spectrum A and spectrum B: {S_simpson(intensities_A,intensities_B)}')
print(f'Braun-Banquet similarity between spectrum A and spectrum B: {S_braun_banquet(intensities_A,intensities_B)}')
print(f'Fager-McGowan similarity between spectrum A and spectrum B: {S_fager_mcgowan(intensities_A,intensities_B)}')
print(f'Kulczynski similarity between spectrum A and spectrum B: {S_kulczynski(intensities_A,intensities_B)}')
print(f'Intersection similarity between spectrum A and spectrum B: {S_intersection(intensities_A,intensities_B)}')
print(f'Hamming similarity between spectrum A and spectrum B: {S_hamming(intensities_A,intensities_B)}')
print(f'Hellinger similarity between spectrum A and spectrum B: {S_hellinger(intensities_A,intensities_B)}')

intensities_A = np.array([0.1,0.1,0.6,0,0,0.2])
intensities_B = intensities_A
sim_mixture = S_mixture(intensities_A, intensities_B, weights={'Cosine':0.25, 'Shannon':0.25, 'Renyi':0.25, 'Tsallis':0.25}, q=1.5)
print(f'\nIntensities of spectrum A: {intensities_A}')
print(f'Intensities of spectrum B: {intensities_B}')
print(f'Cosine similarity between spectrum A and spectrum B: {S_cos(intensities_A,intensities_B)}')
print(f'Shannon Entropy similarity between spectrum A and spectrum B: {S_shannon(intensities_A,intensities_B)}')
print(f'Renyi Entropy similarity between spectrum A and spectrum B with entropy dimension 1.5: {S_renyi(intensities_A,intensities_B,1.5)}')
print(f'Tsallis Entropy similarity between spectrum A and spectrum B with entropy dimension 1.5: {S_tsallis(intensities_A,intensities_B,1.5)}')
print(f'Similarity between spectrum A and spectrum B with respect to mixture of all four similarity measures with equal weights with entropy dimension 1.5: {sim_mixture}')
print(f'Jaccard similarity between spectrum A and spectrum B: {S_jaccard(intensities_A,intensities_B)}')
print(f'Dice similarity between spectrum A and spectrum B: {S_dice(intensities_A,intensities_B)}')
print(f'3W-Jaccard similarity between spectrum A and spectrum B: {S_3w_jaccard(intensities_A,intensities_B)}')
print(f'Sokal-Sneath similarity between spectrum A and spectrum B: {S_sokal_sneath(intensities_A,intensities_B)}')
print(f'Binary Cosine similarity between spectrum A and spectrum B: {S_binary_cosine(intensities_A,intensities_B)}')
print(f'Mountford similarity between spectrum A and spectrum B: {S_mountford(intensities_A,intensities_B)}')
print(f'McConnaughey similarity between spectrum A and spectrum B: {S_mcconnaughey(intensities_A,intensities_B)}')
print(f'Driver-Kroeber similarity between spectrum A and spectrum B: {S_driver_kroeber(intensities_A,intensities_B)}')
print(f'Simpson similarity between spectrum A and spectrum B: {S_simpson(intensities_A,intensities_B)}')
print(f'Braun-Banquet similarity between spectrum A and spectrum B: {S_braun_banquet(intensities_A,intensities_B)}')
print(f'Fager-McGowan similarity between spectrum A and spectrum B: {S_fager_mcgowan(intensities_A,intensities_B)}')
print(f'Kulczynski similarity between spectrum A and spectrum B: {S_kulczynski(intensities_A,intensities_B)}')
print(f'Intersection similarity between spectrum A and spectrum B: {S_intersection(intensities_A,intensities_B)}')
print(f'Hamming similarity between spectrum A and spectrum B: {S_hamming(intensities_A,intensities_B)}')
print(f'Hellinger similarity between spectrum A and spectrum B: {S_hellinger(intensities_A,intensities_B)}\n')


