## `BA`: Basic
| Code   | Description                                                                                                       | Rationale                                                                                                                                                                                                                    | Autofixable   |
|--------|-------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| BA100  | Marketplace content set to -1 makes it easier to tell from modified, versioned content.                           | The version for system content items should always be -1 as per the standard.                                                                                                                                                | Yes           |
| BA101  | Validate that the file id and name fields are identical.                                                          | The id attribute serves as the unique identifier of files across the platform                                                                                                                                                | Yes           |
| BA105  | Validate that the content item ID doesn't include any slashes (/).                                                | ids with slashes are not allowed in the platform                                                                                                                                                                             | Yes           |
| BA106  | Validate that the item's fromversion field is sufficient.                                                         | This field makes sure content can use the latest and greatest features of the platform. The minimal value is the third-last platform release version.                                                                        | Yes           |
| BA108  | Check if there are separators in the folder name.                                                                 | To ensure consistent, readable folder structures by avoiding separators like spaces, underscores, or hyphens.                                                                                                                |               |
| BA109  | Check if there are separators in the script or integration files names.                                           | Filenames for scripts and integrations should not contain separators to maintain consistency and readability.                                                                                                                |               |
| BA110  | Check that the entity name or display name does not contain the entity type.                                      | Improves clarity and simplicity in the content repository                                                                                                                                                                    |               |
| BA111  | Checks whether the name of a content item contains an excluded word.                                              | Increases clarity by keeping content names simple                                                                                                                                                                            |               |
| BA113  | Checks for content item names with trailing spaces.                                                               | Ensures accurate referencing.                                                                                                                                                                                                | Yes           |
| BA114  | Validate that we didn't move a content item from one pack to another.                                             | Pack of a content item should not be changed.                                                                                                                                                                                |               |
| BA116  | validate that the CLI name and the id match for incident and indicators field                                     | Consistency between the CLI name (used by the platform) and the id.                                                                                                                                                          | Yes           |
| BA118  | Validate that the item's toversion is greater/equal then its fromversion.                                         | Content with a from_version greater than to_version will not show in the platform.                                                                                                                                           | Yes           |
| BA119  | Validate that the python file doesn't have a copyright section with the words - BSD, MIT, Copyright, proprietary. | Content in the Cortex marketplace is licensed under the MIT license.                                                                                                                                                         |               |
| BA124  | Validate that the script / integration has a unit test file.                                                      | Unit tests make sure that the behaviors in code are consistent between versions.                                                                                                                                             |               |
| BA125  | Validate that customer facing docs and fields don't contain any internal terms that aren't clear for customers.   | Ensure customer-facing docs avoid internal terms for clarity.                                                                                                                                                                |               |
| BA126  | Checks if script/integration is deprecated correctly                                                              | Deprecated scripts/integrations need clear descriptions for user guidance. For deprecation process, see: https://xsoar.pan.dev/docs/reference/articles/deprecation-process-and-hidden-packs#how-to-deprecate-and-hide-a-pack |               |
| BA127  | Validate that the level of depth of the context output path in the yml is lower or equal to 5.                    | We wish to avoid over nested context to ease on data extraction.                                                                                                                                                             |               |
## `BC`: Backward Compatability
| Code   | Description                                                                                                             | Rationale                                                                                                                                                                        | Autofixable   |
|--------|-------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| BC100  | Validate that the pack name subtype of the new file matches the old one.                                                | Changing 'subtype' can break backward compatibility. For 'subtype' info, see: https://xsoar.pan.dev/docs/integrations/yaml-file#script                                           | Yes           |
| BC101  | Validate that no context output keys were removed from the script's output section.                                     | To ensure we don't break bc.                                                                                                                                                     |               |
| BC102  | Validate that the context path has been changed.                                                                        | Changing the paths may break dependent content items, which rely on the existing paths.                                                                                          |               |
| BC103  | Check if an argument name has been changed.                                                                             | If an existing argument has been renamed, it will break backward compatibility.                                                                                                  |               |
| BC104  | Check if the command name or argument name has been changed.                                                            | If an existing command or argument has been renamed, it will break backward compatibility                                                                                        |               |
| BC105  | Validate that the ID of the content item was not changed.                                                               | Changing the ID of an item will cause it to show as a new item in the platform, and not update properly for users who already have a previous version installed.                 | Yes           |
| BC106  | Check that the fromversion property was not changed on existing Content files.                                          | Changing the `fromversion` for a content item can break backward compatibility. For 'fromversion' info, see: https://xsoar.pan.dev/docs/integrations/yaml-file#version-and-tests |               |
| BC107  | Check that the toversion property was not changed on existing Content files.                                            | Changing the `toversion` field for a content item can break backward compatibility.                                                                                              |               |
| BC108  | Ensuring that the 'marketplaces' property hasn't been removed or added in a manner that effectively removes all others. | Removing `marketplaces` or adding a new one that effectively removes all others can cause issues with the content item's visibility and availability.                            |               |
| BC110  | Validate that no new *required* argument are added to an existing command.                                              | Adding a new argument to an existing command and defining it as *required* or changing an non-required argument to be required will break backward compatibility.                |               |
| BC111  | Ensure that no new *required* arguments are added to an existing script.                                                | Adding a new required argument or changing a non-required one to required without specifying a default value breaks backward compatibility.                                      |               |
| BC112  | Ensure that no parameters are removed from an existing integration.                                                     | Removed parameters can cause errors if the parameter is needed by the server of integration code.                                                                                |               |
| BC113  | Validate that no incident types were removed and no incident fields were changed.                                       | We want to ensure no breaking changes are made to existing mappers so customers won't lose data between pack updates.                                                            |               |
| BC114  | Ensure a pre-defined list of fields wasn't removed or modified in the integration yml.                                  | We wish to keep our behavior between different versions of the content item so we wish to enforce backwards compatibility breaking.                                              |               |
## `CL`: Classifier
| Code   | Description                                                   | Rationale                                                                                 | Autofixable   |
|--------|---------------------------------------------------------------|-------------------------------------------------------------------------------------------|---------------|
| CL100  | Validate that a classifier has a type = classification field. | This standardization is for the platform to correctly identify and handle the classifier. | Yes           |
## `CR`: Correlation Rule
| Code   | Description                                                                               | Rationale                                                                              | Autofixable   |
|--------|-------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------|---------------|
| CR102  | Validates 'search_window' existence and non-emptiness for 'execution_mode' = 'SCHEDULED'. | 'SCHEDULED' execution must have a defined time frame 'search_window' to operate within |               |
## `DA`: Dashboard
| Code   | Description                                                      | Rationale                                                                                  | Autofixable   |
|--------|------------------------------------------------------------------|--------------------------------------------------------------------------------------------|---------------|
| DA100  | Validate that the dashboard excludes all the unnecessary fields. | The Dashboard should contain only the required fields.                                     | Yes           |
| DA101  | Validate that the dashboard includes all the necessary fields.   | The Dashboard should contains the required 'fromDate', 'toDate', 'fromDateLicense' fields. |               |
## `DO`: Docker Image
| Code   | Description                                                                            | Rationale                                                                                                                                                                                                                     | Autofixable   |
|--------|----------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| DO100  | Validate that the given content-item does not use the tag 'latest' in its docker image | Locking content to use a specific tag of a docker image ensures stability. The tag is usually updated in newer versions of the content item.For more details on Docker, visit https://xsoar.pan.dev/docs/integrations/docker. | Yes           |
| DO101  | Validate that the given content-item uses demisto docker image                         | The Docker image used in a content item should originate from Demisto's Docker repository. This ensures that the Docker image is trusted, maintained, and compatible with the Demisto platform.                               |               |
| DO102  | Validate that the given content item uses a docker image that is not the native image. | The 'native-image' Docker image is intended for internal development and should not be used for running integrations or scripts.                                                                                              |               |
| DO103  | Validate that the given content item's docker-image actually exists in dockerhub       | Platform supported content must have their images available in dockerhub so they can be widely pulled and used.                                                                                                               |               |
| DO104  | Validate that the given content item has a docker_image.                               | Python and Powershell content run in containers.                                                                                                                                                                              |               |
| DO105  | Validate that the given content item uses a docker image that is not deprecated        | It is best practice to use images that are maintained by the platform.                                                                                                                                                        |               |
| DO106  | Validate that the given content-item's docker image isn't outdated.                    | Updated Docker images ensure that the code doesn't use outdated dependencies, including bug fixes and fixed vulnerabilities.                                                                                                  | Yes           |
## `DS`: Description
| Code   | Description                                                                  | Rationale                                                                                                                                           | Autofixable   |
|--------|------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| DS100  | Check whether a description file exists for a beta integration.              | Need a disclaimer for beta integrations.                                                                                                            |               |
| DS101  | Check if beta disclaimer exists in detailed description                      | Need a disclaimer for beta integrations.                                                                                                            |               |
| DS104  | Verifies that a Description file is present for an integration.              | It is recommended to have a Description file for each integration, which for example will have additional details on how to configure the instance. |               |
| DS105  | check if DESCRIPTION file contains contribution details.                     | the contribution/partner details will be generated automatically and we don't want should be duplicate.                                             |               |
| DS106  | Check if the description file exist and the name is valid.                   | We want to make sure all integrations have all required documentation and that the file name is according to our standards.                         |               |
| DS107  | Validate that none of the description lines contains the the word 'demisto'. | Ensure that the current name of the product is used rather than the old one.                                                                        |               |
| DS108  | Ensure that all yml's description fields ends with a dot.                    | To ensure high documentation standards.                                                                                                             | Yes           |
## `GF`: Generic Field
| Code   | Description                                   | Rationale                                                                                                                                                                                                                                       | Autofixable   |
|--------|-----------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| GF100  | Checks if group field is set to 4.            | Required by the platform.                                                                                                                                                                                                                       | Yes           |
| GF101  | Checks if the id starts with `generic_`.      | Required by the platform.                                                                                                                                                                                                                       |               |
| GF102  | Checks if the unsearchable key is set to true | Marking many items searchable causes index and search loads on the platform. Official demisto/content GenericField files must be set to Unsearchable. In custom content, it's recommended to keep the number of searchable fields to a minimum. |               |
## `GR`: Graph
| Code   | Description                                                                                                                                    | Rationale                                                                                                                                                                                                                                                                               | Autofixable   |
|--------|------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| GR100  | Detect content items that attempt to use other content items which are not supported in all of the marketplaces of the content item.           | Content graph proper construction.                                                                                                                                                                                                                                                      |               |
| GR101  | Validates that source's fromversion &gt;= target's fromversion.                                                                                   | Prevent issues where used objects are not available due to a version mismatch.                                                                                                                                                                                                          |               |
| GR102  | Validates that content items are not used in other content items which have a lower toversion.                                                 | Prevent issues where used objects are not available due to a version mismatch.                                                                                                                                                                                                          |               |
| GR103  | Validates that there is no usage of unknown content items                                                                                      | Content items should only use existing content items.                                                                                                                                                                                                                                   |               |
| GR104  | Validate that there are no duplicate display names of packs in the repo                                                                        | Prevent confusion between packs.                                                                                                                                                                                                                                                        |               |
| GR105  | Ensures that each content item has a unique ID to prevent conflicts.                                                                           | Duplicate IDs can cause conflicts and confusion.                                                                                                                                                                                                                                        |               |
| GR106  | Checks that every test playbook is linked to at least one content item. (the content item has a 'tests:' key with the ID of the test playbook) | In the demisto/content repo, unlinked test playbooks are not run in CI (for PRs) unless the test playbook itself is modified. Proper linkage of test playbooks ensures content quality. See  https://xsoar.pan.dev/docs/integrations/test-playbooks#adding-the-playbook-to-your-project |               |
| GR107  | Validates that deprecated content items are not used in other content items.                                                                   | Using deprecated content items can lead to unexpected behavior and should be avoided.                                                                                                                                                                                                   |               |
| GR108  | Validates that non-hidden packs do not have a hidden packs as mandatory dependencies.                                                          | Hidden packs are not available to install in the marketplace.                                                                                                                                                                                                                           |               |
## `IF`: Incident Field
| Code   | Description                                                                                                               | Rationale                                                                                                                                                                                                                                        | Autofixable   |
|--------|---------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| IF100  | Checks if the name and cliName do not contain potential incident synonyms.                                                | The name and cliName fields are limited by the platform.                                                                                                                                                                                         |               |
| IF101  | Checks if the incident field is marked as content.                                                                        | Required by the platform.                                                                                                                                                                                                                        | Yes           |
| IF102  | Checks if system flag is false.                                                                                           | Required by the platform.                                                                                                                                                                                                                        | Yes           |
| IF103  | Checks if given field type is valid.                                                                                      | The types of the IncidentField are limited by the platform.                                                                                                                                                                                      |               |
| IF104  | Checks if group field is set to 0.                                                                                        | Required by the platform.                                                                                                                                                                                                                        | Yes           |
| IF105  | Checks if cliName field is alphanumeric and lowercase.                                                                    | Required by the platform.                                                                                                                                                                                                                        |               |
| IF106  | Checks if `cliName` field is not a reserved word.                                                                         | The cliName values of the incident field are limited by the platform.                                                                                                                                                                            |               |
| IF111  | Checks if the field type changed.                                                                                         | Changing type of IncidentField is not allowed by the platform.                                                                                                                                                                                   | Yes           |
| IF113  | Checks if field name starts with its pack name or one of the item prefixes from pack metadata.                            | Required by the platform.                                                                                                                                                                                                                        |               |
| IF115  | Checks if the `unsearchable` key set to true.                                                                             | Marking many items searchable causes index and search loads on the platform. Official demisto/content IncidentField files must be set to Unsearchable. In custom content, it's recommended to keep the number of searchable fields to a minimum. |               |
| IF116  | We do not allow for incidentFields with multySelect types to have in the selectValues emtpy options                       | Due to UI issues, we cannot allow empty values for selectValues field                                                                                                                                                                            | Yes           |
| IF119  | We do not allow for incidentFields with singleSelect types to have in the selectValues more than one or only emtpy option | Due to UI issues, we cannot allow more than one or only empty values for selectValues field                                                                                                                                                      | Yes           |
## `IM`: Author Image
| Code   | Description                                                          | Rationale                                                                                                                                   | Autofixable   |
|--------|----------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| IM100  | Checks if the integration has an image path.                         | Images make it easier to find integrations.                                                                                                 |               |
| IM101  | Checks that the image file size are matching the requirements.       | Image needs to fit its place in the UI. For more information see: https://xsoar.pan.dev/docs/integrations/integration-logo                  |               |
| IM106  | Checks if the integration has an image other than the default ones.  | If an image is provided, it must not be the default ones.                                                                                   |               |
| IM108  | Checks that the author image file is not empty                       | If an author image is provided, it must be a valid image. For more info, see: https://xsoar.pan.dev/docs/packs/packs-format#author_imagepng |               |
| IM109  | Checks if the pack has an author image path.                         | Author images make it easier to identify the author.                                                                                        |               |
| IM111  | Checks that the image file dimensions are matching the requirements. | Image needs to fit its place in the UI. For more information see: https://xsoar.pan.dev/docs/integrations/integration-logo                  |               |
## `IN`: Integration
| Code   | Description                                                                                                                      | Rationale                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Autofixable   |
|--------|----------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| IN100  | Validate that the proxy & insecure params are configured correctly.                                                              | The 'proxy' and 'insecure' parameters in an integration are builtin platform parameters.                                                                                                                                                                                                                                                                                                                                                                                                     | Yes           |
| IN101  | Outputs of reputation commands must adhere to standards.                                                                         | Uniform outputs allow creating generic content. For more information, see https://xsoar.pan.dev/docs/integrations/generic-commands-reputation                                                                                                                                                                                                                                                                                                                                                |               |
| IN102  | Validate that the checkbox param is configured correctly with required argument set to false.                                    | A checkbox parameter that is required will fail (count as missing) when unchecked, thus forcing the users to always check it, practically turning it into a constant `True` value, rather than a dynamic checkbox.                                                                                                                                                                                                                                                                           | Yes           |
| IN104  | Validate that the Integrations category is valid.                                                                                | See the list of allowed categories in the platform: https://xsoar.pan.dev/docs/documentation/pack-docs#pack-keywords-tags-use-cases--categories                                                                                                                                                                                                                                                                                                                                              |               |
| IN106  | Validate that the command is valid as a reputation command.                                                                      | Reputation commands must follow standards for consistency and compatibility. For more details, see https://xsoar.pan.dev/docs/integrations/generic-commands-reputation                                                                                                                                                                                                                                                                                                                       |               |
| IN107  | Validate that the reputation commands include the list of required contextPaths.                                                 | Reputation commands must include required contextPaths for consistency and reliable use in playbooks or scripts. For more details, see https://xsoar.pan.dev/docs/integrations/context-standards-mandatory                                                                                                                                                                                                                                                                                   |               |
| IN108  | Validate wether the subtype is valid or not.                                                                                     | This field describes the major python version, `python2` or `python3`.                                                                                                                                                                                                                                                                                                                                                                                                                       |               |
| IN109  | Validate that the ID field doesn't include the substring 'beta'.                                                                 | The ID field in an integration should not contain the word 'beta'. This ensures unambiguous identification of production-ready integrations.                                                                                                                                                                                                                                                                                                                                                 | Yes           |
| IN110  | Validate that the name field doesn't include the substring 'beta'.                                                               | The name field in an integration should not contain the word 'beta'. This ensures unambiguous identification of production-ready integrations.                                                                                                                                                                                                                                                                                                                                               | Yes           |
| IN112  | Validate that the display name contain the substring 'beta'.                                                                     | Beta integrations should have 'beta' in the display name for clear identification and to manage user expectations.                                                                                                                                                                                                                                                                                                                                                                           |               |
| IN113  | Prevent duplicate arguments for integrations.                                                                                    | Duplicate arguments cause confusion and unpredictable behaviors.                                                                                                                                                                                                                                                                                                                                                                                                                             |               |
| IN114  | Validate that there're no duplicated params for the integration.                                                                 | Duplicate parameters cause confusion and unpredictable behaviors.                                                                                                                                                                                                                                                                                                                                                                                                                            |               |
| IN115  | Validate that the contextPath field of each output is in the right format.                                                       | The 'contextPath' in an integration's output must follow the correct format to ensure data can be used in subsequent playbook steps. Incorrect 'contextPath' formats can lead to errors or unexpected behavior. For more details, see https://xsoar.pan.dev/docs/integrations/context-and-outputs                                                                                                                                                                                            |               |
| IN117  | Validate that type 17 configuration params doesn't include the display field.                                                    | The display name is handle by the platform.                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Yes           |
| IN118  | Validate that integration parameters have a display field unless they are of type 17 or 23.                                              | Integration parameters should have a 'display' field for clear user understanding, except for types 17 and 23 parameters.                                                                                                                                                                                                                                                                                                                                                                            |               |
| IN121  | Validate that fetch integration has the required params in the right format.                                                     | Malformed or missing parameters can lead to errors or incomplete data. For more details, see https://xsoar.pan.dev/docs/integrations/fetching-incidents                                                                                                                                                                                                                                                                                                                                      |               |
| IN122  | Validate that all existing params are in the right format for feed params.                                                       | Malformed or missing parameters can lead to errors or incomplete data. For more details, see https://xsoar.pan.dev/docs/integrations/feeds                                                                                                                                                                                                                                                                                                                                                   |               |
| IN123  | Checks if integration display name is versioned correctly, e.g.: ends with v&lt;number&gt;.                                            | Integration display names should end with 'v&lt;number&gt;' for version clarity and consistency.                                                                                                                                                                                                                                                                                                                                                                                                   | Yes           |
| IN124  | Validate that a param is not hidden if it can not be hidden.                                                                     | Hiding these parameters can lead to confusion and may prevent the integration from working as expected. Only the following parameters may be hidden: {'feedIncremental', 'feedReputation', 'longRunning'}                                                                                                                                                                                                                                                                                    | Yes           |
| IN125  | Validate that the max_fetch param has a defaultvalue                                                                             | To maintain optimal load in the platform, the maximal number of incidents per fetch is limited. For more details, see https://xsoar.pan.dev/docs/integrations/fetching-incidents#fetch-limit                                                                                                                                                                                                                                                                                                 | Yes           |
| IN126  | Validate that a fetch integration is not missing the first_fetch & max_fetch params.                                             | 'first_fetch' and 'max_fetch' parameters in fetch integrations ensure correct incident retrieval. Their absence or incorrect format can lead to errors or inconsistencies. For more details, see https://xsoar.pan.dev/docs/integrations/fetching-incidents#first-run                                                                                                                                                                                                                        |               |
| IN127  | Validate that a deprecated integration display name ends with (Deprecated).                                                      | Deprecated integrations should end with (Deprecated) in the display name to clearly indicate their status. This prevents inadvertent use of unsupported integrations. For more details, see https://xsoar.pan.dev/docs/reference/articles/deprecation-process-and-hidden-packs#how-to-deprecate-an-integration                                                                                                                                                                               | Yes           |
| IN130  | validate that the integration is runable                                                                                         | Integrations must have a functional purpose, such as executing commands, fetching incidents, fetching indicators from a feed, or running a long-running process.                                                                                                                                                                                                                                                                                                                             |               |
| IN131  | Validate that the integration is valid as a mappable integration.                                                                | For easy debugging and troubleshooting, integrations supporting schema mapping (ismappable: true) should include the 'get-mapping-fields' command. This validator ensures the command is present in the integration YAML, enhancing maintainability and user experience.For more info, visit https://xsoar.pan.dev/docs/integrations/mirroring_integration#get-mapping-fields                                                                                                                |               |
| IN134  | Checks whether a content item has multiple default arguments.                                                                    | Multiple default arguments are not supported by the platform, and could lead to unexpected behavior. For more info about command arguments, see https://xsoar.pan.dev/docs/integrations/yaml-file#command-arguments                                                                                                                                                                                                                                                                          |               |
| IN135  | Validate that the parameter display name starts with a capital letter and doesn't contain '_'.                                   | Parameter display names should start with a capital letter and not contain underscores for consistency and readability.                                                                                                                                                                                                                                                                                                                                                                      | Yes           |
| IN139  | Validate that there's no 'incident' in any of the commands names or arguments names for core packs integrations.                 | This helps maintain the flexibility of the platform.                                                                                                                                                                                                                                                                                                                                                                                                                                         |               |
| IN141  | Validate that an endpoint command has at least one of the required fields.                                                       | Without them, the command may not function properly or may return incomplete or incorrect data. for more info see https://xsoar.pan.dev/docs/integrations/generic-endpoint-command                                                                                                                                                                                                                                                                                                           |               |
| IN142  | Validate that the integration contain the right additionalinfo fields for the list of params with predefined additionalinfo.     | Ensuring the 'additionalinfo' fields are correctly set in an integration's parameters promotes consistency and enhances user understanding of each parameter's purpose and usage.                                                                                                                                                                                                                                                                                                            | Yes           |
| IN144  | Validate that a reputation command has isArray field set to True for its default argument.                                       | Reputation commands often get multiple inputs to enrich. Without isArray=true, providing an array of inputs may impact performance.For more info about reputation commands, see https://xsoar.pan.dev/docs/integrations/generic-commands-reputation                                                                                                                                                                                                                                          |               |
| IN145  | Validate that xsoar supported integrations don't have a non-hidden type 4 params.                                                | Parameters that contain API tokens or credentials should be of type 'Credentials' (type 9) instead of 'Encrypted' (type 4) to allow fetching credentials from an external vault. This ensures secure and efficient handling of sensitive data. Using the 'Encrypted' type could prevent the integration from fetching the credentials from an external vault, which could lead to operational issues. For more info see https://xsoar.pan.dev/docs/integrations/code-conventions#credentials |               |
| IN146  | Validate that there's no fromlicense param field in non Xsoar supported integration                                              | The `fromlicense` param is intended for XSOAR-supported integrations, as they rely on values coming stored in the platform.                                                                                                                                                                                                                                                                                                                                                                  | Yes           |
| IN149  | Validate that a contextPath has a description if it belongs to a predefined list of contextPaths that should have a description. | Common outputs in integrations need descriptions for clarity and effective usage.                                                                                                                                                                                                                                                                                                                                                                                                            | Yes           |
| IN151  | Validate that all commands has at least one argument                                                                             | This prevents potential errors during execution due to missing arguments.                                                                                                                                                                                                                                                                                                                                                                                                                    | Yes           |
| IN152  | Validate that the default value of a checkbox param is valid.                                                                    | Checkbox parameters' default values should be lowercase boolean strings ('true', 'false') for correct interpretation and functionality.                                                                                                                                                                                                                                                                                                                                                      | Yes           |
| IN153  | Validate that that the url default param starts with https rather than http.                                                     | URL parameters should default to 'https' for secure communication. 'http' could expose sensitive data.                                                                                                                                                                                                                                                                                                                                                                                       | Yes           |
| IN154  | Validate that feed integration and integrations with reputation commands have a reliability param.                               | The reliability parameter is required to set indicator's reliability. For more info see, https://xsoar.pan.dev/docs/integrations/feeds#required-parameters                                                                                                                                                                                                                                                                                                                                   |               |
| IN156  | Validate that the hidden field value contain only valid values.                                                                  | Incorrect values can cause unexpected behavior or compatibility issues.                                                                                                                                                                                                                                                                                                                                                                                                                      |               |
| IN158  | Validate that the description for non-deprecated integrations is not in the deprecation format                                   | This avoids confusion and ensures that users are correctly informed about the integration's status. For more about deprecation see: https://xsoar.pan.dev/docs/reference/articles/deprecation-process-and-hidden-packs#how-to-deprecate-an-integration                                                                                                                                                                                                                                       |               |
| IN159  | Validate that the capitalization of reputation command specific keys is correct.                                                 | This ensures consistency and effective data passage between playbook tasks. For more about the standard context output for reputation commands see: https://xsoar.pan.dev/docs/integrations/context-standards-mandatory                                                                                                                                                                                                                                                                      |               |
| IN160  | Validate that the display name for non-deprecated integration doesn't end with '(Deprecated)'.                                   | This ensures accurate representation of the integration's status, avoiding confusion for users For more about deprecation see: https://xsoar.pan.dev/docs/reference/articles/deprecation-process-and-hidden-packs#how-to-deprecate-an-integration                                                                                                                                                                                                                                            |               |
| IN161  | Validate that the marketplacev2 tag appear in the marketplaces list of a siem integration.                                       | SIEM integrations must have the 'marketplacev2' tag for visibility in marketplacev2, enhancing usability. Refer to https://xsoar.pan.dev/docs/integrations/event-collectors#required-keys.                                                                                                                                                                                                                                                                                                   | Yes           |
| IN162  | Validate that the support level header for a collector integration in a Partner pack is set to Xsoar.                            | Collector integrations in Partner packs should specify {XSOAR_SUPPORT} level support to accurately inform users about the support level provided by Cortex XSOAR. For more information about 'support level header' see https://xsoar.pan.dev/docs/documentation/integration-description#support-level-header-yml-metadata-key.                                                                                                                                                              | Yes           |
| IN163  | Validate feedExpirationPolicy parameter is in the right formatfor both incremental and fully fetched feeds                       | Malformed expiration policy can lead to errors or incomplete data.For more details, see https://xsoar.pan.dev/docs/integrations/feeds                                                                                                                                                                                                                                                                                                                                                        | Yes           |
## `IT`: Incident Type
| Code   | Description                                                  | Rationale                                                                                                                                                                                                       | Autofixable   |
|--------|--------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| IT100  | Checks if the included fields have a positive integer value. | Fields that have to be included, cannot be of type integer.                                                                                                                                                     |               |
| IT101  | Checks if playbook ID is valid.                              | Playbook ID has to be a non-UUID format.                                                                                                                                                                        |               |
| IT102  | Check if extractSettings field is valid.                     | extractSettings field is supposed to be in the correct format.                                                                                                                                                  |               |
| IT103  | Check if auto extract mode valid.                            | auto extract mode is supposed to be: 'All' To extract all indicator types regardless of auto-extraction settings.'Specific' - To extract only the specific indicator types set in the auto-extraction settings. |               |
## `LO`: Layout
| Code   | Description                                                                       | Rationale                | Autofixable   |
|--------|-----------------------------------------------------------------------------------|--------------------------|---------------|
| LO107  | Ensures that only supported types are used in the layout for XSIAM compatibility. | Limited by the platform. |               |
## `MR`: Modeling Rule
| Code   | Description                                                                                                                    | Rationale                                                                                                                                                                                                                                                      | Autofixable   |
|--------|--------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| MR100  | Validate that each modeling rule has a corresponding schema file.                                                              | For each modeling rule, there has to be schema file.                                                                                                                                                                                                           |               |
| MR101  | Validate that the modeling rules keys - "rules" and "schema" exist and are empty                                               | This validation is for compatibility resaons. Without those fields the modeling rules won't work.                                                                                                                                                              |               |
| MR106  | Verifies that each specified data type in the schema files of modeling rules conforms to a predefined set of acceptable types. | Validating types in schema files is crucial for maintaining data integrity and compatibility across systems, preventing errors and ensuring reliable data processing.                                                                                          |               |
| MR107  | Validate that the dataset name of a modeling rule shows in the xif and schema files match.                                     | We want to make sure the datasets match between the schema and the XIF file to avoid discrepancy between the expected info and the info shown in the UI.                                                                                                       |               |
| MR108  | Checks that id and name in the modeling rule, end with the correct suffixes.                                                   | To prevent confusion caused by ambiguous naming of modeling and parsing rules in XSIAM UI, the validation ensures the rule ID and name end with 'ModelingRule' or 'Modeling Rule'. This will help avoid naming conflicts and improve clarity in release notes. |               |
## `PA`: Pack
| Code   | Description                                                                                                                | Rationale                                                                                                                                                                                                                                             | Autofixable   |
|--------|----------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| PA100  | Validate that all the tags in tags field have a valid prefix.                                                              | This standardization allows for efficient filtering and grouping in the marketplace. For more info about the valid tags see https://xsoar.pan.dev/docs/documentation/pack-docs#pack-keywords-tags-use-cases--categories                               | Yes           |
| PA101  | Validate that the version mentioned in the Pack metadata matches the latest RN version.                                    | Clear documentation for each version change helps users know what's new.For more information, see https://xsoar.pan.dev/docs/packs/packs-format#content-packs-versioning                                                                              |               |
| PA102  | Validate that the pack is deprecated if it needs to.                                                                       | This ensures clarity for users and prevents potential confusion of deprecated content. For more about deprecation see: https://xsoar.pan.dev/docs/reference/articles/deprecation-process-and-hidden-packs                                             | Yes           |
| PA103  | Validate that the pack categories are valid.                                                                               | See the list of allowed categories in the platform: https://xsoar.pan.dev/docs/documentation/pack-docs#pack-keywords-tags-use-cases--categories                                                                                                       |               |
| PA104  | Validate that the modules field include only labels from the list of allowed labels.                                       | See the list of allowed modules in the platform: compliance.                                                                                                                                                                                          | Yes           |
| PA105  | Validate that the pack has the marketplacev2 label if it include modules.                                                  | This field is only used in XSIAM.                                                                                                                                                                                                                     | Yes           |
| PA107  | Ensure that mandatory fields exist in the pack_metadata.                                                                   | Missing these fields may lead to unexpected behavior when uploading the packs.                                                                                                                                                                        | Yes           |
| PA108  | Validate that the pack name field exist and is different from the default one.                                             | A unique and meaningful pack name is crucial for identifying the pack and its contents.                                                                                                                                                               |               |
| PA109  | Validate that the metadata description field isn't empty and is different from the default one.                            | A meaningful description helps users understand how the pack can help them.                                                                                                                                                                           |               |
| PA111  | Validate that certain metadata fields are not empty.                                                                       | 'keywords', 'tags', 'categories', and 'useCases' fields in the pack metadata are mandatory for pack identification and searchability. For more info, see: https://xsoar.pan.dev/docs/documentation/pack-docs#pack-keywords-tags-use-cases--categories |               |
| PA113  | Validate that a partner/developer pack has at least an email or a url address fields filled.                               | Packs with Partner or developer support levels require a contact method (email or URL) for user support and information.                                                                                                                              |               |
| PA114  | Ensure that the pack metadata version is raised on relevant changes.                                                       | When updating a pack, its version needs to be raised to maintain traceability.                                                                                                                                                                        |               |
| PA115  | Validate that the pack_metadata created field is in ISO format.                                                            | The format is required by the platform.                                                                                                                                                                                                               | Yes           |
| PA117  | Validate that the pack's support type is a valid support type.                                                             | For valid support levels, see https://xsoar.pan.dev/docs/packs/packs-format#pack_metadatajson.                                                                                                                                                        |               |
| PA118  | Validate that the metadata's certification field is valid.                                                                 | See the list of allowed `certification` in the platform: https://xsoar.pan.dev/docs/packs/packs-format#pack_metadatajson.                                                                                                                             |               |
| PA119  | Validate that the metadata's usecases field include valid usecases.                                                        | See the list of allowed `useCases` in the platform: https://xsoar.pan.dev/docs/documentation/pack-docs#pack-keywords-tags-use-cases--categories                                                                                                       | Yes           |
| PA120  | Validate that metadata's tag section include only approved tags.                                                           | Using approved tags makes it easier for users to find the packs that suit their needs. For more info, see https://xsoar.pan.dev/docs/documentation/pack-docs#pack-keywords-tags-use-cases--categories                                                 | Yes           |
| PA121  | Validate that no changes were done to the pack's price.                                                                    | Changing this field affects paying customer. In the demisto/content repo, this requires a force-merge.                                                                                                                                                | Yes           |
| PA123  | Validate that the pack has at least one of PB, incidents Types or Layouts if the tags section contains the 'Use Case' tag. | Correct categorization helps users find packs that suit their needs.                                                                                                                                                                                  | Yes           |
| PA124  | Validates that core packs do not depend on non-core packs.                                                                 | Core packs should be self-contained.                                                                                                                                                                                                                  |               |
| PA125  | Validate that the pack name is valid.                                                                                      | Pack names should follow conventions for consistency and readability in the marketplace.                                                                                                                                                              |               |
| PA127  | Validate that the pack metadata contains a valid URL field.                                                                | URLs help users access support or report issues for the pack directly. For more info, see: https://xsoar.pan.dev/docs/packs/packs-format#pack_metadatajson                                                                                            | Yes           |
| PA128  | Checks for required pack files                                                                                             | These files are standard in the demisto/content repo.                                                                                                                                                                                                 | Yes           |
| PA130  | Validate that the pack_metadata version field is in valid format.                                                          | Content versions use semantic versioning to make it easy to tell how significant changes are between two versions.                                                                                                                                    |               |
| PA131  | Validate that the pack_metadata contains a default datasource, if there are more than one datasource.                      | Wizards and other tools rely on the default datasource to be set.                                                                                                                                                                                     | Yes           |
| PA132  | Validate that the pack_metadata contains a valid default datasource, when provided.                                        | Wizards and other tools rely on the default datasource to be set.                                                                                                                                                                                     | Yes           |
## `PB`: Playbook
| Code   | Description                                                                                                       | Rationale                                                                                                                                                                                                                                                                                                            | Autofixable   |
|--------|-------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| PB100  | Validate whether the playbook has a rolename. If the Playbook has a rolename it is not valid.                     | We shouldn't ship playbooks with a role set as this is customisable by the customer.                                                                                                                                                                                                                                 |               |
| PB101  | Checks whether an ask conditional has task with unreachable next task condition.                                  | Checks whether an ask conditional has task with unreachable next task condition.                                                                                                                                                                                                                                     |               |
| PB103  | Validate whether there is an unconnected task.                                                                    | Make sure there are no unconnected tasks to ensure the playbook will work as expected.                                                                                                                                                                                                                               |               |
| PB104  | Validate whether a deprecated playbook has a valid description.                                                   | Description of deprecated content should be consistent.                                                                                                                                                                                                                                                              |               |
| PB105  | Validate whether the playbook has a DeleteContext with all set to 'Yes'. If the Playbook has it, it is not valid. | Playbook can not have DeleteContext script with arg all set to yes.                                                                                                                                                                                                                                                  |               |
| PB106  | Validate whether the playbook does not use an instance. If the Playbook use an instance it is not valid.          | If the playbook uses a specific instance it can leads to errors because not all the users have the same instance.                                                                                                                                                                                                    | Yes           |
| PB108  | Validate that the task ID and the 'id' under the 'task' field are from UUID format.                               | Each task should have a unique id in UUID format to avoid unknown behavior and breaking the playbook.                                                                                                                                                                                                                |               |
| PB109  | Check that taskid field and id field under task field contains equal values.                                      | System requirements                                                                                                                                                                                                                                                                                                  |               |
| PB114  | Validates that playbooks for indicator types will be on quiet mode.                                               | Playbooks for indicators will likely be executing on thousands of indicators so they need to be on quiet mode.                                                                                                                                                                                                       | Yes           |
| PB115  | Checks if the 'quietmode' field of all tasks in playbook are not in default value.                                | Confirmation of turning off quitmode                                                                                                                                                                                                                                                                                 | Yes           |
| PB116  | The validation checks that all playbook tasks stop when encountering an error.                                    | For indicator playbooks, tasks will likely be executing on thousands of indicators. Without these validations in place, we may easily release playbooks for general availability that can crash Demisto instances if a playbook task does not stop on error, causing following tasks to rely on its output and fail. |               |
| PB118  | Validate that all inputs described in the playbooks input section are used in tasks.                              | For more info, see: https://xsoar.pan.dev/docs/playbooks/playbooks-overview#inputs-and-outputs                                                                                                                                                                                                                       |               |
| PB119  | Validates that all inputs used are defined.                                                                       | Inputs that are used but not provided to a playbook is probably an oversight.                                                                                                                                                                                                                                        |               |
| PB122  | Validate whether branches of built-in conditional tasks are handled properly.                                     | Ensures the playbook logic is complete.                                                                                                                                                                                                                                                                              |               |
| PB123  | Checks whether an ask conditional has unhandled reply options.                                                    | Checks whether an ask conditional has unhandled reply options.                                                                                                                                                                                                                                                       |               |
| PB124  | Make sure that all conditional tasks contains at least 2 next tasks.                                              | Ensure we don't miss unhandled cases in our playbook.                                                                                                                                                                                                                                                                |               |
| PB125  | Validates that a condition task doesn't has only a default next-task.                                             | Validates that a condition task doesn't has only a default next-task.                                                                                                                                                                                                                                                |               |
| PB126  | Ensure that conditional tasks have an execution path besides for the default.                                     | We want to ensure that conditional tasks have more than path which is not the default one o/w it make no sense to have such.                                                                                                                                                                                         |               |
| PB127  | Ensure that any yml keys that are marketplace only have a default non-marketplace counterpart.                    | To be able to validate the existence of required yml keys, we need to make sure that in addition to a specific marketplace key (say mykey:xsoar) there is also a basic key with no specific marketplace (for example: mykey).                                                                                        | Yes           |
## `PR`: Parsing Rule
| Code   | Description                                                                 | Rationale                                                                                                                                                                                                                                                    | Autofixable   |
|--------|-----------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| PR101  | Checks that id and name in the parsing rule, end with the correct suffixes. | To prevent confusion caused by ambiguous naming of modeling and parsing rules in XSIAM UI, the validation ensures the rule ID and name end with 'ParsingRule' or 'Parsing Rule'. This will help avoid naming conflicts and improve clarity in release notes. |               |
## `RM`: Readme
| Code   | Description                                                                                                                                                                                                                             | Rationale                                                                                                                                                                        | Autofixable   |
|--------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| RM100  | Check that there are no default leftovers such as:.     1. 'FILL IN REQUIRED PERMISSIONS HERE'..     2. unexplicit version number - such as "version xx of"..     3. Default description belonging to one of the examples integrations` | Ensure that no default section is left empty with just headings.                                                                                                                 |               |
| RM101  | Validate images absolute paths, and prints the suggested path if it's not valid.                                                                                                                                                        | In official marketplace content, ensures that the images can be used in the upload flow properly.                                                                                |               |
| RM102  | Validates that all context outputs defined in the README file are present in the YML file, and vice versa.                                                                                                                              | Ensuring consistency between the README and YML files helps maintain accurate documentation and prevents discrepancies.                                                          |               |
| RM104  | Validate that the pack contains a full README.md file with pack information.                                                                                                                                                            | Meaningful, complete documentations make it easier for users to use the content.                                                                                                 |               |
| RM105  | Checks if the README.md file is not same as the pack description.                                                                                                                                                                       | An informative README helps users know more about the product and its uses.                                                                                                      |               |
| RM106  | Validate that none of the readme lines contains the the word 'demisto'.                                                                                                                                                                 | Ensure that the current name of the product is used rather than the old one.                                                                                                     |               |
| RM107  | Checks if there are the generic sentence '%%FILL HERE%%' in the README content.                                                                                                                                                         | Ensuring our documentation looks good and professional.                                                                                                                          |               |
| RM108  | This validation verifies that images in the readme and description files are relative and stored in doc_files.                                                                                                                          | Using relative references to files in the repo folder enhances security by reducing reliance on external links, minimizing the risk of link manipulation or redirection attacks. |               |
| RM109  | Validates if there is a readme file for the content item.                                                                                                                                                                               | Ensure that the content item contains additional information about use-cases, inputs, and outputs.                                                                               |               |
| RM110  | Validates that all commands are mentioned in the README file                                                                                                                                                                            | Ensuring all commands are documented in the README helps users understand the available functionality                                                                            |               |
| RM113  | Validate that non of the readme lines contains the disallowed copyright section keywords.                                                                                                                                               | Content in the Cortex marketplace is licensed under the MIT license.                                                                                                             |               |
| RM114  | Validate that images placed under doc_files folder and used in README exist.                                                                                                                                                            | Missing images are not shown in rendered markdown                                                                                                                                |               |
| RM115  | Check that there are no default leftovers such as:.     1. 'FILL IN REQUIRED PERMISSIONS HERE'..     2. unexplicit version number - such as "version xx of"..     3. Default description belonging to one of the examples integrations  | Ensure no default auto generated sections remain empty. For better documentation standards and quality.                                                                          |               |
| RM116  | Validate that the readme file is not to short                                                                                                                                                                                           | Ensure better documentation.                                                                                                                                                     |               |
## `RN`: Release Note
| Code   | Description                                                                                                                      | Rationale                                                                                      | Autofixable   |
|--------|----------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------|---------------|
| RN103  | Validate that the pack contains a full release note file.                                                                        | Meaningful, complete documentations make it easier for users to use the content.               |               |
| RN105  | Validate there're no more than one Added rn for each pack.                                                                       | Having more than one release note for a version may cause confusion and missing information.   |               |
| RN108  | Validate that a new pack doesn't have a RN,                                                                                      | New Packs doesn't require release notes since they don't have any updates.                     |               |
| RN112  | Validate that if RN contains 'breaking change' then the breaking change release note exist and filled correctly.                 | Breaking changes should be well documented so they can pop up to users when updating versions. |               |
| RN114  | Validate the existence of content types in the first-level headers (####) and the content items in second-level headers (#####). | Providing documentation with accurate information and avoiding confusion.                      |               |
| RN116  | Validate that the release note has either a valid first level header or a valid force header.                                    | We want to enforce proper release notes structure to ensure the documentation is readable.     |               |
## `RP`: Reputation (Incident Type)
| Code   | Description                                                            | Rationale                                                   | Autofixable   |
|--------|------------------------------------------------------------------------|-------------------------------------------------------------|---------------|
| RP101  | Validate that the 'expiration' field has a non-negative integer value. | To align with the platform requirements.                    |               |
| RP102  | Validate that the id and the details fields are equal.                 | To align with the platform requirements.                    |               |
| RP103  | Validate that the 'id' field of indicator type has valid value.        | we want to make sure the id of the indicator type is valid. |               |
## `SC`: Script
| Code   | Description                                                                   | Rationale                                                                                                                                                                                                                                                                                                                                                                                                                               | Autofixable   |
|--------|-------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| SC100  | Checks if script name is versioned correctly, e.g.: ends with V&lt;number&gt;.      | This standardization ensures consistency across content items.                                                                                                                                                                                                                                                                                                                                                                          | Yes           |
| SC105  | Checks that script arguments do not container the word incident in core packs | Server has a feature where the word 'incident' in the system can be replaced by any other keyword of the user's choice. To ensure compatibility with this feature, we should make sure that command names, command arguments, and script arguments in core pack integrations and scripts do not use the word 'incident'. This helps maintain the flexibility of the system and prevents potential issues caused by keyword replacement. |               |
| SC106  | Checks that the script runas is not equal to DBotRole                         | For security reasons, the `runas` field should not be set to DBotRole.                                                                                                                                                                                                                                                                                                                                                                  |               |
| SC109  | Validate that there are no scripts with the same type and the same name.      | Duplicate names cause confusion and unpredictable behaviors.                                                                                                                                                                                                                                                                                                                                                                            |               |
## `ST`: Structure
| Code   | Description                                    | Rationale                                   | Autofixable   |
|--------|------------------------------------------------|---------------------------------------------|---------------|
| ST110  | Validate that the scheme's structure is valid. | Maintain valid structure for content items. |               |
