# Web App Examples

This folder contains example code for running and interacting with HICA agents via web interfaces and APIs. Each file demonstrates a different aspect of building, serving, or interacting with agentic workflows.

---

## File Overview

### `calculator_tools.py`
Defines a set of basic calculator tools (add, subtract, multiply, divide) and registers them with a HICA `ToolRegistry`. These tools are used by the agent in the web app and API examples.

**Objective:** Provide simple, type-safe tools for agent workflows.

---

### `server_local.py`
A FastAPI server that exposes endpoints for creating, resuming, and inspecting agent threads using only local tools (from `calculator_tools.py`).

**Objective:** Run a local agent backend for workflow automation and chat.

**How to run:**
```sh
uvicorn server_local:app --reload
```

---

### `server_mcp.py`
A FastAPI server that exposes endpoints for agent threads, but also loads remote tools from an MCP server (in addition to local tools). Demonstrates hybrid local+remote tool usage.

**Objective:** Run an agent backend that can use both local and remote (MCP) tools.

**How to run:**
```sh
uvicorn server_mcp:app --reload
```

---

### `streamlit_app.py`
A Streamlit web UI for chatting with the agent, visualizing the event log, and interacting with threads in real time. Polls the backend for new events and updates the UI automatically. It also incorporates human-in-loop workflows.

**Objective:** Provide a user-friendly, real-time chat interface for agent workflows.

**How to run:**
```sh
streamlit run streamlit_app.py
```

---

### `polling_streamlit_app.py`
A variant of the Streamlit app that demonstrates manual polling for new events (instead of auto-refresh). Useful for understanding different frontend update strategies.

**Objective:** Show how to implement manual polling for agent event updates in Streamlit.

**How to run:**
```sh
streamlit run polling_streamlit_app.py
```

---

### `context/` and `logs/`
Folders for storing thread context files and logs generated by the web apps and APIs. These are used for persistence and debugging.

---

## Need Help?
If you have questions about any example, open an issue or ask in the project discussions!
