# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['As3Args', 'As3']

@pulumi.input_type
class As3Args:
    def __init__(__self__, *,
                 application_list: Optional[pulumi.Input[builtins.str]] = None,
                 as3_json: Optional[pulumi.Input[builtins.str]] = None,
                 controls: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_apps: Optional[pulumi.Input['As3DeleteAppsArgs']] = None,
                 ignore_metadata: Optional[pulumi.Input[builtins.bool]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_list: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a As3 resource.
        :param pulumi.Input[builtins.str] application_list: List of applications currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] as3_json: Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] controls: A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        :param pulumi.Input['As3DeleteAppsArgs'] delete_apps: Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
               one of `delete_apps` or `as3_json` can be set in a resource block.
        :param pulumi.Input[builtins.bool] ignore_metadata: Set True if you want to ignore metadata changes during update. By default it is set to false
               
               * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_01": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_1": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.0.2.10"
               ],
               "pool": "web_pool"
               },
               "web_pool": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.1.100",
               "192.0.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_02": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_2": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.2.2.10"
               ],
               "pool": "web_pool2"
               },
               "web_pool2": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.2.1.100",
               "192.2.1.110"
               ]
               }
               ]
               }
               }
               },
               "Sample_03": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_3": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.1.2.10"
               ],
               "pool": "web_pool3"
               },
               "web_pool3": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.3.1.100",
               "192.3.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               
               * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)
               
               ```json
               {
               "Application1": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.2.1"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.2.10",
               "192.0.2.20"
               ]
               }
               ]
               }
               },
               "Application2": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.3.2"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.3.30",
               "192.0.3.40"
               ]
               }
               ]
               }
               }
               }
               ```
               
               # As3 delete one or more applications
               
               The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.
               
               > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        :param pulumi.Input[builtins.str] task_id: ID of AS3 post declaration async task
        :param pulumi.Input[builtins.str] tenant_filter: If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        :param pulumi.Input[builtins.str] tenant_list: List of tenants currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] tenant_name: Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        if application_list is not None:
            pulumi.set(__self__, "application_list", application_list)
        if as3_json is not None:
            pulumi.set(__self__, "as3_json", as3_json)
        if controls is not None:
            pulumi.set(__self__, "controls", controls)
        if delete_apps is not None:
            pulumi.set(__self__, "delete_apps", delete_apps)
        if ignore_metadata is not None:
            pulumi.set(__self__, "ignore_metadata", ignore_metadata)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)
        if tenant_filter is not None:
            pulumi.set(__self__, "tenant_filter", tenant_filter)
        if tenant_list is not None:
            pulumi.set(__self__, "tenant_list", tenant_list)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)

    @property
    @pulumi.getter(name="applicationList")
    def application_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        List of applications currently deployed on the Big-Ip
        """
        return pulumi.get(self, "application_list")

    @application_list.setter
    def application_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_list", value)

    @property
    @pulumi.getter(name="as3Json")
    def as3_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        """
        return pulumi.get(self, "as3_json")

    @as3_json.setter
    def as3_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as3_json", value)

    @property
    @pulumi.getter
    def controls(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        """
        return pulumi.get(self, "controls")

    @controls.setter
    def controls(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "controls", value)

    @property
    @pulumi.getter(name="deleteApps")
    def delete_apps(self) -> Optional[pulumi.Input['As3DeleteAppsArgs']]:
        """
        Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
        one of `delete_apps` or `as3_json` can be set in a resource block.
        """
        return pulumi.get(self, "delete_apps")

    @delete_apps.setter
    def delete_apps(self, value: Optional[pulumi.Input['As3DeleteAppsArgs']]):
        pulumi.set(self, "delete_apps", value)

    @property
    @pulumi.getter(name="ignoreMetadata")
    def ignore_metadata(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set True if you want to ignore metadata changes during update. By default it is set to false

        * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant

        ```json

        {
        "class": "AS3",
        "action": "deploy",
        "persist": true,
        "declaration": {
        "class": "ADC",
        "schemaVersion": "3.0.0",
        "id": "example-declaration-01",
        "label": "Sample 1",
        "remark": "Simple HTTP application with round robin pool",
        "Sample_01": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_1": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.0.2.10"
        ],
        "pool": "web_pool"
        },
        "web_pool": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.1.100",
        "192.0.1.110"
        ]
        }
        ]
        }
        }
        }
        }
        }

        ```
        * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants

        ```json

        {
        "class": "AS3",
        "action": "deploy",
        "persist": true,
        "declaration": {
        "class": "ADC",
        "schemaVersion": "3.0.0",
        "id": "example-declaration-01",
        "label": "Sample 1",
        "remark": "Simple HTTP application with round robin pool",
        "Sample_02": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_2": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.2.2.10"
        ],
        "pool": "web_pool2"
        },
        "web_pool2": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.2.1.100",
        "192.2.1.110"
        ]
        }
        ]
        }
        }
        },
        "Sample_03": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_3": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.1.2.10"
        ],
        "pool": "web_pool3"
        },
        "web_pool3": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.3.1.100",
        "192.3.1.110"
        ]
        }
        ]
        }
        }
        }
        }
        }

        ```

        * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)

        ```json
        {
        "Application1": {
        "class": "Application",
        "service": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "192.0.2.1"
        ],
        "pool": "pool"
        },
        "pool": {
        "class": "Pool",
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.2.10",
        "192.0.2.20"
        ]
        }
        ]
        }
        },
        "Application2": {
        "class": "Application",
        "service": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "192.0.3.2"
        ],
        "pool": "pool"
        },
        "pool": {
        "class": "Pool",
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.3.30",
        "192.0.3.40"
        ]
        }
        ]
        }
        }
        }
        ```

        # As3 delete one or more applications

        The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.

        > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        """
        return pulumi.get(self, "ignore_metadata")

    @ignore_metadata.setter
    def ignore_metadata(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_metadata", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of AS3 post declaration async task
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_id", value)

    @property
    @pulumi.getter(name="tenantFilter")
    def tenant_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        """
        return pulumi.get(self, "tenant_filter")

    @tenant_filter.setter
    def tenant_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_filter", value)

    @property
    @pulumi.getter(name="tenantList")
    def tenant_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        List of tenants currently deployed on the Big-Ip
        """
        return pulumi.get(self, "tenant_list")

    @tenant_list.setter
    def tenant_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_list", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_name", value)


@pulumi.input_type
class _As3State:
    def __init__(__self__, *,
                 application_list: Optional[pulumi.Input[builtins.str]] = None,
                 as3_json: Optional[pulumi.Input[builtins.str]] = None,
                 controls: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_apps: Optional[pulumi.Input['As3DeleteAppsArgs']] = None,
                 ignore_metadata: Optional[pulumi.Input[builtins.bool]] = None,
                 per_app_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_list: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering As3 resources.
        :param pulumi.Input[builtins.str] application_list: List of applications currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] as3_json: Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] controls: A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        :param pulumi.Input['As3DeleteAppsArgs'] delete_apps: Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
               one of `delete_apps` or `as3_json` can be set in a resource block.
        :param pulumi.Input[builtins.bool] ignore_metadata: Set True if you want to ignore metadata changes during update. By default it is set to false
               
               * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_01": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_1": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.0.2.10"
               ],
               "pool": "web_pool"
               },
               "web_pool": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.1.100",
               "192.0.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_02": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_2": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.2.2.10"
               ],
               "pool": "web_pool2"
               },
               "web_pool2": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.2.1.100",
               "192.2.1.110"
               ]
               }
               ]
               }
               }
               },
               "Sample_03": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_3": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.1.2.10"
               ],
               "pool": "web_pool3"
               },
               "web_pool3": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.3.1.100",
               "192.3.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               
               * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)
               
               ```json
               {
               "Application1": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.2.1"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.2.10",
               "192.0.2.20"
               ]
               }
               ]
               }
               },
               "Application2": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.3.2"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.3.30",
               "192.0.3.40"
               ]
               }
               ]
               }
               }
               }
               ```
               
               # As3 delete one or more applications
               
               The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.
               
               > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        :param pulumi.Input[builtins.bool] per_app_mode: Will specify whether is deployment is done via Per-Application Way or Traditional Way
        :param pulumi.Input[builtins.str] task_id: ID of AS3 post declaration async task
        :param pulumi.Input[builtins.str] tenant_filter: If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        :param pulumi.Input[builtins.str] tenant_list: List of tenants currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] tenant_name: Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        if application_list is not None:
            pulumi.set(__self__, "application_list", application_list)
        if as3_json is not None:
            pulumi.set(__self__, "as3_json", as3_json)
        if controls is not None:
            pulumi.set(__self__, "controls", controls)
        if delete_apps is not None:
            pulumi.set(__self__, "delete_apps", delete_apps)
        if ignore_metadata is not None:
            pulumi.set(__self__, "ignore_metadata", ignore_metadata)
        if per_app_mode is not None:
            pulumi.set(__self__, "per_app_mode", per_app_mode)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)
        if tenant_filter is not None:
            pulumi.set(__self__, "tenant_filter", tenant_filter)
        if tenant_list is not None:
            pulumi.set(__self__, "tenant_list", tenant_list)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)

    @property
    @pulumi.getter(name="applicationList")
    def application_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        List of applications currently deployed on the Big-Ip
        """
        return pulumi.get(self, "application_list")

    @application_list.setter
    def application_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_list", value)

    @property
    @pulumi.getter(name="as3Json")
    def as3_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        """
        return pulumi.get(self, "as3_json")

    @as3_json.setter
    def as3_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as3_json", value)

    @property
    @pulumi.getter
    def controls(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        """
        return pulumi.get(self, "controls")

    @controls.setter
    def controls(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "controls", value)

    @property
    @pulumi.getter(name="deleteApps")
    def delete_apps(self) -> Optional[pulumi.Input['As3DeleteAppsArgs']]:
        """
        Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
        one of `delete_apps` or `as3_json` can be set in a resource block.
        """
        return pulumi.get(self, "delete_apps")

    @delete_apps.setter
    def delete_apps(self, value: Optional[pulumi.Input['As3DeleteAppsArgs']]):
        pulumi.set(self, "delete_apps", value)

    @property
    @pulumi.getter(name="ignoreMetadata")
    def ignore_metadata(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set True if you want to ignore metadata changes during update. By default it is set to false

        * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant

        ```json

        {
        "class": "AS3",
        "action": "deploy",
        "persist": true,
        "declaration": {
        "class": "ADC",
        "schemaVersion": "3.0.0",
        "id": "example-declaration-01",
        "label": "Sample 1",
        "remark": "Simple HTTP application with round robin pool",
        "Sample_01": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_1": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.0.2.10"
        ],
        "pool": "web_pool"
        },
        "web_pool": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.1.100",
        "192.0.1.110"
        ]
        }
        ]
        }
        }
        }
        }
        }

        ```
        * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants

        ```json

        {
        "class": "AS3",
        "action": "deploy",
        "persist": true,
        "declaration": {
        "class": "ADC",
        "schemaVersion": "3.0.0",
        "id": "example-declaration-01",
        "label": "Sample 1",
        "remark": "Simple HTTP application with round robin pool",
        "Sample_02": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_2": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.2.2.10"
        ],
        "pool": "web_pool2"
        },
        "web_pool2": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.2.1.100",
        "192.2.1.110"
        ]
        }
        ]
        }
        }
        },
        "Sample_03": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_3": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.1.2.10"
        ],
        "pool": "web_pool3"
        },
        "web_pool3": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.3.1.100",
        "192.3.1.110"
        ]
        }
        ]
        }
        }
        }
        }
        }

        ```

        * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)

        ```json
        {
        "Application1": {
        "class": "Application",
        "service": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "192.0.2.1"
        ],
        "pool": "pool"
        },
        "pool": {
        "class": "Pool",
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.2.10",
        "192.0.2.20"
        ]
        }
        ]
        }
        },
        "Application2": {
        "class": "Application",
        "service": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "192.0.3.2"
        ],
        "pool": "pool"
        },
        "pool": {
        "class": "Pool",
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.3.30",
        "192.0.3.40"
        ]
        }
        ]
        }
        }
        }
        ```

        # As3 delete one or more applications

        The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.

        > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        """
        return pulumi.get(self, "ignore_metadata")

    @ignore_metadata.setter
    def ignore_metadata(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_metadata", value)

    @property
    @pulumi.getter(name="perAppMode")
    def per_app_mode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Will specify whether is deployment is done via Per-Application Way or Traditional Way
        """
        return pulumi.get(self, "per_app_mode")

    @per_app_mode.setter
    def per_app_mode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "per_app_mode", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of AS3 post declaration async task
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_id", value)

    @property
    @pulumi.getter(name="tenantFilter")
    def tenant_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        """
        return pulumi.get(self, "tenant_filter")

    @tenant_filter.setter
    def tenant_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_filter", value)

    @property
    @pulumi.getter(name="tenantList")
    def tenant_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        List of tenants currently deployed on the Big-Ip
        """
        return pulumi.get(self, "tenant_list")

    @tenant_list.setter
    def tenant_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_list", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_name", value)


@pulumi.type_token("f5bigip:index/as3:As3")
class As3(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_list: Optional[pulumi.Input[builtins.str]] = None,
                 as3_json: Optional[pulumi.Input[builtins.str]] = None,
                 controls: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_apps: Optional[pulumi.Input[Union['As3DeleteAppsArgs', 'As3DeleteAppsArgsDict']]] = None,
                 ignore_metadata: Optional[pulumi.Input[builtins.bool]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_list: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        As3 resources can be imported using the partition name, e.g., ( use comma separated partition names if there are multiple partitions in as3 deployments )

        ```sh
        $ pulumi import f5bigip:index/as3:As3  bigip_as3.test Sample_http_01
        ```

        ```sh
        $ pulumi import f5bigip:index/as3:As3  bigip_as3.test Sample_http_01,Sample_non_http_01
        ```

        #### Import examples ( single and multiple partitions )

        ```sh
        $ pulumi import f5bigip:index/as3:As3 test Sample_http_01
        ```

        bigip_as3.test: Importing from ID "Sample_http_01"...

        bigip_as3.test: Import prepared!

          Prepared bigip_as3 for import

        bigip_as3.test: Refreshing state... [id=Sample_http_01]

        Import successful!

        The resources that were imported are shown above. These resources are now in

        your Terraform state and will henceforth be managed by Terraform.

        $ terraform show

        bigip_as3.test:

        resource "bigip_as3" "test" {

            as3_json      = jsonencode(
            
                {
            
                    action      = "deploy"
            
                    class       = "AS3"
            
                    declaration = {
            
                        Sample_http_01 = {
            
                            A1    = {
            
                                class      = "Application"
            
                                jsessionid = {
            
                                    class             = "Persist"
            
                                    cookieMethod      = "hash"
            
                                    cookieName        = "JSESSIONID"
            
                                    persistenceMethod = "cookie"
            
                                }
            
                                service    = {
            
                                    class              = "Service_HTTP"
            
                                    persistenceMethods = [
            
                                        {
            
                                            use = "jsessionid"
            
                                        },
            
                                    ]
            
                                    pool               = "web_pool"
            
                                    virtualAddresses   = [
            
                                        "10.0.2.10",
            
                                    ]
            
                                }
            
                                web_pool   = {
            
                                    class    = "Pool"
            
                                    members  = [
            
                                        {
            
                                            serverAddresses = [
            
                                                "192.0.2.10",
            
                                                "192.0.2.11",
            
                                            ]
            
                                            servicePort     = 80
            
                                        },
            
                                    ]
            
                                    monitors = [
            
                                        "http",
            
                                    ]
            
                                }
            
                            }
            
                            class = "Tenant"
            
                        }
            
                        class          = "ADC"
            
                        id             = "UDP_DNS_Sample"
            
                        label          = "UDP_DNS_Sample"
            
                        remark         = "Sample of a UDP DNS Load Balancer Service"
            
                        schemaVersion  = "3.0.0"
            
                    }
            
                    persist     = true
            
                }
            
            )
            
            id            = "Sample_http_01"
            
            tenant_filter = "Sample_http_01"
            
            tenant_list   = "Sample_http_01"

        }

        ```sh
        $ pulumi import f5bigip:index/as3:As3 test Sample_http_01,Sample_non_http_01
        ```

        bigip_as3.test: Importing from ID "Sample_http_01,Sample_non_http_01"...

        bigip_as3.test: Import prepared!

          Prepared bigip_as3 for import

        bigip_as3.test: Refreshing state... [id=Sample_http_01,Sample_non_http_01]

        Import successful!

        The resources that were imported are shown above. These resources are now in

        your Terraform state and will henceforth be managed by Terraform.

        $ terraform show

        bigip_as3.test:

        resource "bigip_as3" "test" {

            as3_json      = jsonencode(
            
                {
            
                    action      = "deploy"
            
                    class       = "AS3"
            
                    declaration = {
            
                        Sample_http_01     = {
            
                            A1    = {
            
                                class      = "Application"
            
                                jsessionid = {
            
                                    class             = "Persist"
            
                                    cookieMethod      = "hash"
            
                                    cookieName        = "JSESSIONID"
            
                                    persistenceMethod = "cookie"
            
                                }
            
                                service    = {
            
                                    class              = "Service_HTTP"
            
                                    persistenceMethods = [
            
                                        {
            
                                            use = "jsessionid"
            
                                        },
            
                                    ]
            
                                    pool               = "web_pool"
            
                                    virtualAddresses   = [
            
                                        "10.0.2.10",
            
                                    ]
            
                                }
            
                                web_pool   = {
            
                                    class    = "Pool"
            
                                    members  = [
            
                                        {
            
                                            serverAddresses = [
            
                                                "192.0.2.10",
            
                                                "192.0.2.11",
            
                                            ]
            
                                            servicePort     = 80
            
                                        },
            
                                    ]
            
                                    monitors = [
            
                                        "http",
            
                                    ]
            
                                }
            
                            }
            
                            class = "Tenant"
            
                        }
            
                        Sample_non_http_01 = {
            
                            DNS_Service = {
            
                                Pool1   = {
            
                                    class    = "Pool"
            
                                    members  = [
            
                                        {
            
                                            serverAddresses = [
            
                                                "10.1.10.100",
            
                                            ]
            
                                            servicePort     = 53
            
                                        },
            
                                        {
            
                                            serverAddresses = [
            
                                                "10.1.10.101",
            
                                            ]
            
                                            servicePort     = 53
            
                                        },
            
                                    ]
            
                                    monitors = [
            
                                        "icmp",
            
                                    ]
            
                                }
            
                                class   = "Application"
            
                                service = {
            
                                    class            = "Service_UDP"
            
                                    pool             = "Pool1"
            
                                    virtualAddresses = [
            
                                        "10.1.20.121",
            
                                    ]
            
                                    virtualPort      = 53
            
                                }
            
                            }
            
                            class       = "Tenant"
            
                        }
            
                        class              = "ADC"
            
                        id                 = "UDP_DNS_Sample"
            
                        label              = "UDP_DNS_Sample"
            
                        remark             = "Sample of a UDP DNS Load Balancer Service"
            
                        schemaVersion      = "3.0.0"
            
                    }
            
                    persist     = true
            
                }
            
            )
            
            id            = "Sample_http_01,Sample_non_http_01"
            
            tenant_filter = "Sample_http_01,Sample_non_http_01"
            
            tenant_list   = "Sample_http_01,Sample_non_http_01"

        }

        * `AS3 documentation` - https://clouddocs.f5.com/products/extensions/f5-appsvcs-extension/latest/userguide/composing-a-declaration.html

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_list: List of applications currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] as3_json: Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] controls: A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        :param pulumi.Input[Union['As3DeleteAppsArgs', 'As3DeleteAppsArgsDict']] delete_apps: Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
               one of `delete_apps` or `as3_json` can be set in a resource block.
        :param pulumi.Input[builtins.bool] ignore_metadata: Set True if you want to ignore metadata changes during update. By default it is set to false
               
               * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_01": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_1": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.0.2.10"
               ],
               "pool": "web_pool"
               },
               "web_pool": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.1.100",
               "192.0.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_02": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_2": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.2.2.10"
               ],
               "pool": "web_pool2"
               },
               "web_pool2": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.2.1.100",
               "192.2.1.110"
               ]
               }
               ]
               }
               }
               },
               "Sample_03": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_3": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.1.2.10"
               ],
               "pool": "web_pool3"
               },
               "web_pool3": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.3.1.100",
               "192.3.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               
               * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)
               
               ```json
               {
               "Application1": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.2.1"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.2.10",
               "192.0.2.20"
               ]
               }
               ]
               }
               },
               "Application2": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.3.2"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.3.30",
               "192.0.3.40"
               ]
               }
               ]
               }
               }
               }
               ```
               
               # As3 delete one or more applications
               
               The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.
               
               > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        :param pulumi.Input[builtins.str] task_id: ID of AS3 post declaration async task
        :param pulumi.Input[builtins.str] tenant_filter: If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        :param pulumi.Input[builtins.str] tenant_list: List of tenants currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] tenant_name: Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[As3Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        As3 resources can be imported using the partition name, e.g., ( use comma separated partition names if there are multiple partitions in as3 deployments )

        ```sh
        $ pulumi import f5bigip:index/as3:As3  bigip_as3.test Sample_http_01
        ```

        ```sh
        $ pulumi import f5bigip:index/as3:As3  bigip_as3.test Sample_http_01,Sample_non_http_01
        ```

        #### Import examples ( single and multiple partitions )

        ```sh
        $ pulumi import f5bigip:index/as3:As3 test Sample_http_01
        ```

        bigip_as3.test: Importing from ID "Sample_http_01"...

        bigip_as3.test: Import prepared!

          Prepared bigip_as3 for import

        bigip_as3.test: Refreshing state... [id=Sample_http_01]

        Import successful!

        The resources that were imported are shown above. These resources are now in

        your Terraform state and will henceforth be managed by Terraform.

        $ terraform show

        bigip_as3.test:

        resource "bigip_as3" "test" {

            as3_json      = jsonencode(
            
                {
            
                    action      = "deploy"
            
                    class       = "AS3"
            
                    declaration = {
            
                        Sample_http_01 = {
            
                            A1    = {
            
                                class      = "Application"
            
                                jsessionid = {
            
                                    class             = "Persist"
            
                                    cookieMethod      = "hash"
            
                                    cookieName        = "JSESSIONID"
            
                                    persistenceMethod = "cookie"
            
                                }
            
                                service    = {
            
                                    class              = "Service_HTTP"
            
                                    persistenceMethods = [
            
                                        {
            
                                            use = "jsessionid"
            
                                        },
            
                                    ]
            
                                    pool               = "web_pool"
            
                                    virtualAddresses   = [
            
                                        "10.0.2.10",
            
                                    ]
            
                                }
            
                                web_pool   = {
            
                                    class    = "Pool"
            
                                    members  = [
            
                                        {
            
                                            serverAddresses = [
            
                                                "192.0.2.10",
            
                                                "192.0.2.11",
            
                                            ]
            
                                            servicePort     = 80
            
                                        },
            
                                    ]
            
                                    monitors = [
            
                                        "http",
            
                                    ]
            
                                }
            
                            }
            
                            class = "Tenant"
            
                        }
            
                        class          = "ADC"
            
                        id             = "UDP_DNS_Sample"
            
                        label          = "UDP_DNS_Sample"
            
                        remark         = "Sample of a UDP DNS Load Balancer Service"
            
                        schemaVersion  = "3.0.0"
            
                    }
            
                    persist     = true
            
                }
            
            )
            
            id            = "Sample_http_01"
            
            tenant_filter = "Sample_http_01"
            
            tenant_list   = "Sample_http_01"

        }

        ```sh
        $ pulumi import f5bigip:index/as3:As3 test Sample_http_01,Sample_non_http_01
        ```

        bigip_as3.test: Importing from ID "Sample_http_01,Sample_non_http_01"...

        bigip_as3.test: Import prepared!

          Prepared bigip_as3 for import

        bigip_as3.test: Refreshing state... [id=Sample_http_01,Sample_non_http_01]

        Import successful!

        The resources that were imported are shown above. These resources are now in

        your Terraform state and will henceforth be managed by Terraform.

        $ terraform show

        bigip_as3.test:

        resource "bigip_as3" "test" {

            as3_json      = jsonencode(
            
                {
            
                    action      = "deploy"
            
                    class       = "AS3"
            
                    declaration = {
            
                        Sample_http_01     = {
            
                            A1    = {
            
                                class      = "Application"
            
                                jsessionid = {
            
                                    class             = "Persist"
            
                                    cookieMethod      = "hash"
            
                                    cookieName        = "JSESSIONID"
            
                                    persistenceMethod = "cookie"
            
                                }
            
                                service    = {
            
                                    class              = "Service_HTTP"
            
                                    persistenceMethods = [
            
                                        {
            
                                            use = "jsessionid"
            
                                        },
            
                                    ]
            
                                    pool               = "web_pool"
            
                                    virtualAddresses   = [
            
                                        "10.0.2.10",
            
                                    ]
            
                                }
            
                                web_pool   = {
            
                                    class    = "Pool"
            
                                    members  = [
            
                                        {
            
                                            serverAddresses = [
            
                                                "192.0.2.10",
            
                                                "192.0.2.11",
            
                                            ]
            
                                            servicePort     = 80
            
                                        },
            
                                    ]
            
                                    monitors = [
            
                                        "http",
            
                                    ]
            
                                }
            
                            }
            
                            class = "Tenant"
            
                        }
            
                        Sample_non_http_01 = {
            
                            DNS_Service = {
            
                                Pool1   = {
            
                                    class    = "Pool"
            
                                    members  = [
            
                                        {
            
                                            serverAddresses = [
            
                                                "10.1.10.100",
            
                                            ]
            
                                            servicePort     = 53
            
                                        },
            
                                        {
            
                                            serverAddresses = [
            
                                                "10.1.10.101",
            
                                            ]
            
                                            servicePort     = 53
            
                                        },
            
                                    ]
            
                                    monitors = [
            
                                        "icmp",
            
                                    ]
            
                                }
            
                                class   = "Application"
            
                                service = {
            
                                    class            = "Service_UDP"
            
                                    pool             = "Pool1"
            
                                    virtualAddresses = [
            
                                        "10.1.20.121",
            
                                    ]
            
                                    virtualPort      = 53
            
                                }
            
                            }
            
                            class       = "Tenant"
            
                        }
            
                        class              = "ADC"
            
                        id                 = "UDP_DNS_Sample"
            
                        label              = "UDP_DNS_Sample"
            
                        remark             = "Sample of a UDP DNS Load Balancer Service"
            
                        schemaVersion      = "3.0.0"
            
                    }
            
                    persist     = true
            
                }
            
            )
            
            id            = "Sample_http_01,Sample_non_http_01"
            
            tenant_filter = "Sample_http_01,Sample_non_http_01"
            
            tenant_list   = "Sample_http_01,Sample_non_http_01"

        }

        * `AS3 documentation` - https://clouddocs.f5.com/products/extensions/f5-appsvcs-extension/latest/userguide/composing-a-declaration.html

        :param str resource_name: The name of the resource.
        :param As3Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(As3Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_list: Optional[pulumi.Input[builtins.str]] = None,
                 as3_json: Optional[pulumi.Input[builtins.str]] = None,
                 controls: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_apps: Optional[pulumi.Input[Union['As3DeleteAppsArgs', 'As3DeleteAppsArgsDict']]] = None,
                 ignore_metadata: Optional[pulumi.Input[builtins.bool]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_list: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = As3Args.__new__(As3Args)

            __props__.__dict__["application_list"] = application_list
            __props__.__dict__["as3_json"] = as3_json
            __props__.__dict__["controls"] = controls
            __props__.__dict__["delete_apps"] = delete_apps
            __props__.__dict__["ignore_metadata"] = ignore_metadata
            __props__.__dict__["task_id"] = task_id
            __props__.__dict__["tenant_filter"] = tenant_filter
            __props__.__dict__["tenant_list"] = tenant_list
            __props__.__dict__["tenant_name"] = tenant_name
            __props__.__dict__["per_app_mode"] = None
        super(As3, __self__).__init__(
            'f5bigip:index/as3:As3',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_list: Optional[pulumi.Input[builtins.str]] = None,
            as3_json: Optional[pulumi.Input[builtins.str]] = None,
            controls: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            delete_apps: Optional[pulumi.Input[Union['As3DeleteAppsArgs', 'As3DeleteAppsArgsDict']]] = None,
            ignore_metadata: Optional[pulumi.Input[builtins.bool]] = None,
            per_app_mode: Optional[pulumi.Input[builtins.bool]] = None,
            task_id: Optional[pulumi.Input[builtins.str]] = None,
            tenant_filter: Optional[pulumi.Input[builtins.str]] = None,
            tenant_list: Optional[pulumi.Input[builtins.str]] = None,
            tenant_name: Optional[pulumi.Input[builtins.str]] = None) -> 'As3':
        """
        Get an existing As3 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_list: List of applications currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] as3_json: Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] controls: A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        :param pulumi.Input[Union['As3DeleteAppsArgs', 'As3DeleteAppsArgsDict']] delete_apps: Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
               one of `delete_apps` or `as3_json` can be set in a resource block.
        :param pulumi.Input[builtins.bool] ignore_metadata: Set True if you want to ignore metadata changes during update. By default it is set to false
               
               * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_01": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_1": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.0.2.10"
               ],
               "pool": "web_pool"
               },
               "web_pool": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.1.100",
               "192.0.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants
               
               ```json
               
               {
               "class": "AS3",
               "action": "deploy",
               "persist": true,
               "declaration": {
               "class": "ADC",
               "schemaVersion": "3.0.0",
               "id": "example-declaration-01",
               "label": "Sample 1",
               "remark": "Simple HTTP application with round robin pool",
               "Sample_02": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_2": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.2.2.10"
               ],
               "pool": "web_pool2"
               },
               "web_pool2": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.2.1.100",
               "192.2.1.110"
               ]
               }
               ]
               }
               }
               },
               "Sample_03": {
               "class": "Tenant",
               "defaultRouteDomain": 0,
               "Application_3": {
               "class": "Application",
               "template": "http",
               "serviceMain": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "10.1.2.10"
               ],
               "pool": "web_pool3"
               },
               "web_pool3": {
               "class": "Pool",
               "monitors": [
               "http"
               ],
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.3.1.100",
               "192.3.1.110"
               ]
               }
               ]
               }
               }
               }
               }
               }
               
               ```
               
               * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)
               
               ```json
               {
               "Application1": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.2.1"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.2.10",
               "192.0.2.20"
               ]
               }
               ]
               }
               },
               "Application2": {
               "class": "Application",
               "service": {
               "class": "Service_HTTP",
               "virtualAddresses": [
               "192.0.3.2"
               ],
               "pool": "pool"
               },
               "pool": {
               "class": "Pool",
               "members": [
               {
               "servicePort": 80,
               "serverAddresses": [
               "192.0.3.30",
               "192.0.3.40"
               ]
               }
               ]
               }
               }
               }
               ```
               
               # As3 delete one or more applications
               
               The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.
               
               > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        :param pulumi.Input[builtins.bool] per_app_mode: Will specify whether is deployment is done via Per-Application Way or Traditional Way
        :param pulumi.Input[builtins.str] task_id: ID of AS3 post declaration async task
        :param pulumi.Input[builtins.str] tenant_filter: If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        :param pulumi.Input[builtins.str] tenant_list: List of tenants currently deployed on the Big-Ip
        :param pulumi.Input[builtins.str] tenant_name: Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _As3State.__new__(_As3State)

        __props__.__dict__["application_list"] = application_list
        __props__.__dict__["as3_json"] = as3_json
        __props__.__dict__["controls"] = controls
        __props__.__dict__["delete_apps"] = delete_apps
        __props__.__dict__["ignore_metadata"] = ignore_metadata
        __props__.__dict__["per_app_mode"] = per_app_mode
        __props__.__dict__["task_id"] = task_id
        __props__.__dict__["tenant_filter"] = tenant_filter
        __props__.__dict__["tenant_list"] = tenant_list
        __props__.__dict__["tenant_name"] = tenant_name
        return As3(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationList")
    def application_list(self) -> pulumi.Output[builtins.str]:
        """
        List of applications currently deployed on the Big-Ip
        """
        return pulumi.get(self, "application_list")

    @property
    @pulumi.getter(name="as3Json")
    def as3_json(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path/Filename of Declarative AS3 JSON which is a json file used with builtin ```file``` function
        """
        return pulumi.get(self, "as3_json")

    @property
    @pulumi.getter
    def controls(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map that allows you to configure specific behavior controls for the AS3 declaration. Each key represents a particular control setting, and the corresponding value defines its configuration.
        """
        return pulumi.get(self, "controls")

    @property
    @pulumi.getter(name="deleteApps")
    def delete_apps(self) -> pulumi.Output[Optional['outputs.As3DeleteApps']]:
        """
        Block for specifying tenant name and applications to delete from BIG-IP. **Mutually exclusive with `as3_json`**: only
        one of `delete_apps` or `as3_json` can be set in a resource block.
        """
        return pulumi.get(self, "delete_apps")

    @property
    @pulumi.getter(name="ignoreMetadata")
    def ignore_metadata(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set True if you want to ignore metadata changes during update. By default it is set to false

        * `as3_example1.json` - Example  AS3 Declarative JSON file with single tenant

        ```json

        {
        "class": "AS3",
        "action": "deploy",
        "persist": true,
        "declaration": {
        "class": "ADC",
        "schemaVersion": "3.0.0",
        "id": "example-declaration-01",
        "label": "Sample 1",
        "remark": "Simple HTTP application with round robin pool",
        "Sample_01": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_1": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.0.2.10"
        ],
        "pool": "web_pool"
        },
        "web_pool": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.1.100",
        "192.0.1.110"
        ]
        }
        ]
        }
        }
        }
        }
        }

        ```
        * `as3_example2.json` - Example  AS3 Declarative JSON file with multiple tenants

        ```json

        {
        "class": "AS3",
        "action": "deploy",
        "persist": true,
        "declaration": {
        "class": "ADC",
        "schemaVersion": "3.0.0",
        "id": "example-declaration-01",
        "label": "Sample 1",
        "remark": "Simple HTTP application with round robin pool",
        "Sample_02": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_2": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.2.2.10"
        ],
        "pool": "web_pool2"
        },
        "web_pool2": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.2.1.100",
        "192.2.1.110"
        ]
        }
        ]
        }
        }
        },
        "Sample_03": {
        "class": "Tenant",
        "defaultRouteDomain": 0,
        "Application_3": {
        "class": "Application",
        "template": "http",
        "serviceMain": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "10.1.2.10"
        ],
        "pool": "web_pool3"
        },
        "web_pool3": {
        "class": "Pool",
        "monitors": [
        "http"
        ],
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.3.1.100",
        "192.3.1.110"
        ]
        }
        ]
        }
        }
        }
        }
        }

        ```

        * `perApplication_example` - Per Application Example - JSON file with multiple Applications (and no Tenant Details)

        ```json
        {
        "Application1": {
        "class": "Application",
        "service": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "192.0.2.1"
        ],
        "pool": "pool"
        },
        "pool": {
        "class": "Pool",
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.2.10",
        "192.0.2.20"
        ]
        }
        ]
        }
        },
        "Application2": {
        "class": "Application",
        "service": {
        "class": "Service_HTTP",
        "virtualAddresses": [
        "192.0.3.2"
        ],
        "pool": "pool"
        },
        "pool": {
        "class": "Pool",
        "members": [
        {
        "servicePort": 80,
        "serverAddresses": [
        "192.0.3.30",
        "192.0.3.40"
        ]
        }
        ]
        }
        }
        }
        ```

        # As3 delete one or more applications

        The `As3` resource allows you to **post full AS3 declarations** or **selectively delete one or more applications** from a specific tenant in BIG-IP.

        > **Note**: `delete_apps` and `as3_json` are **mutually exclusive**. You must use only one of them in a single `As3` resource block.
        """
        return pulumi.get(self, "ignore_metadata")

    @property
    @pulumi.getter(name="perAppMode")
    def per_app_mode(self) -> pulumi.Output[builtins.bool]:
        """
        Will specify whether is deployment is done via Per-Application Way or Traditional Way
        """
        return pulumi.get(self, "per_app_mode")

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of AS3 post declaration async task
        """
        return pulumi.get(self, "task_id")

    @property
    @pulumi.getter(name="tenantFilter")
    def tenant_filter(self) -> pulumi.Output[builtins.str]:
        """
        If there are multiple tenants on a BIG-IP, this attribute helps the user to set a particular tenant to which he want to reflect the changes. Other tenants will neither be created nor be modified.
        """
        return pulumi.get(self, "tenant_filter")

    @property
    @pulumi.getter(name="tenantList")
    def tenant_list(self) -> pulumi.Output[builtins.str]:
        """
        List of tenants currently deployed on the Big-Ip
        """
        return pulumi.get(self, "tenant_list")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of Tenant. This name is used only in the case of Per-Application Deployment. If it is not provided, then a random name would be generated.
        """
        return pulumi.get(self, "tenant_name")

