# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAwsServiceDiscoveryResult',
    'AwaitableGetAwsServiceDiscoveryResult',
    'get_aws_service_discovery',
    'get_aws_service_discovery_output',
]

@pulumi.output_type
class GetAwsServiceDiscoveryResult:
    """
    A collection of values returned by getAwsServiceDiscovery.
    """
    def __init__(__self__, address_realm=None, aws_access_key=None, aws_region=None, aws_sd_json=None, aws_secret_access_key=None, credential_update=None, external_id=None, id=None, minimum_monitors=None, port=None, role_arn=None, tag_key=None, tag_value=None, type=None, undetectable_action=None, update_interval=None):
        if address_realm and not isinstance(address_realm, str):
            raise TypeError("Expected argument 'address_realm' to be a str")
        pulumi.set(__self__, "address_realm", address_realm)
        if aws_access_key and not isinstance(aws_access_key, str):
            raise TypeError("Expected argument 'aws_access_key' to be a str")
        pulumi.set(__self__, "aws_access_key", aws_access_key)
        if aws_region and not isinstance(aws_region, str):
            raise TypeError("Expected argument 'aws_region' to be a str")
        pulumi.set(__self__, "aws_region", aws_region)
        if aws_sd_json and not isinstance(aws_sd_json, str):
            raise TypeError("Expected argument 'aws_sd_json' to be a str")
        pulumi.set(__self__, "aws_sd_json", aws_sd_json)
        if aws_secret_access_key and not isinstance(aws_secret_access_key, str):
            raise TypeError("Expected argument 'aws_secret_access_key' to be a str")
        pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if credential_update and not isinstance(credential_update, bool):
            raise TypeError("Expected argument 'credential_update' to be a bool")
        pulumi.set(__self__, "credential_update", credential_update)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if minimum_monitors and not isinstance(minimum_monitors, str):
            raise TypeError("Expected argument 'minimum_monitors' to be a str")
        pulumi.set(__self__, "minimum_monitors", minimum_monitors)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if tag_key and not isinstance(tag_key, str):
            raise TypeError("Expected argument 'tag_key' to be a str")
        pulumi.set(__self__, "tag_key", tag_key)
        if tag_value and not isinstance(tag_value, str):
            raise TypeError("Expected argument 'tag_value' to be a str")
        pulumi.set(__self__, "tag_value", tag_value)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if undetectable_action and not isinstance(undetectable_action, str):
            raise TypeError("Expected argument 'undetectable_action' to be a str")
        pulumi.set(__self__, "undetectable_action", undetectable_action)
        if update_interval and not isinstance(update_interval, str):
            raise TypeError("Expected argument 'update_interval' to be a str")
        pulumi.set(__self__, "update_interval", update_interval)

    @property
    @pulumi.getter(name="addressRealm")
    def address_realm(self) -> Optional[builtins.str]:
        return pulumi.get(self, "address_realm")

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "aws_access_key")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> builtins.str:
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="awsSdJson")
    def aws_sd_json(self) -> builtins.str:
        """
        The JSON for AWS service discovery block.
        """
        return pulumi.get(self, "aws_sd_json")

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "aws_secret_access_key")

    @property
    @pulumi.getter(name="credentialUpdate")
    def credential_update(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "credential_update")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> builtins.str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="minimumMonitors")
    def minimum_monitors(self) -> Optional[builtins.str]:
        return pulumi.get(self, "minimum_monitors")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> builtins.str:
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> builtins.str:
        return pulumi.get(self, "tag_value")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="undetectableAction")
    def undetectable_action(self) -> Optional[builtins.str]:
        return pulumi.get(self, "undetectable_action")

    @property
    @pulumi.getter(name="updateInterval")
    def update_interval(self) -> Optional[builtins.str]:
        return pulumi.get(self, "update_interval")


class AwaitableGetAwsServiceDiscoveryResult(GetAwsServiceDiscoveryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsServiceDiscoveryResult(
            address_realm=self.address_realm,
            aws_access_key=self.aws_access_key,
            aws_region=self.aws_region,
            aws_sd_json=self.aws_sd_json,
            aws_secret_access_key=self.aws_secret_access_key,
            credential_update=self.credential_update,
            external_id=self.external_id,
            id=self.id,
            minimum_monitors=self.minimum_monitors,
            port=self.port,
            role_arn=self.role_arn,
            tag_key=self.tag_key,
            tag_value=self.tag_value,
            type=self.type,
            undetectable_action=self.undetectable_action,
            update_interval=self.update_interval)


def get_aws_service_discovery(address_realm: Optional[builtins.str] = None,
                              aws_access_key: Optional[builtins.str] = None,
                              aws_region: Optional[builtins.str] = None,
                              aws_secret_access_key: Optional[builtins.str] = None,
                              credential_update: Optional[builtins.bool] = None,
                              external_id: Optional[builtins.str] = None,
                              minimum_monitors: Optional[builtins.str] = None,
                              port: Optional[builtins.int] = None,
                              role_arn: Optional[builtins.str] = None,
                              tag_key: Optional[builtins.str] = None,
                              tag_value: Optional[builtins.str] = None,
                              type: Optional[builtins.str] = None,
                              undetectable_action: Optional[builtins.str] = None,
                              update_interval: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsServiceDiscoveryResult:
    """
    Use this data source (`fast_get_aws_service_discovery`) to get the AWS Service discovery config to be used for `http`/`https` app deployment in FAST.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    tc2 = f5bigip.fast.get_aws_service_discovery(tag_key="testawstagkey",
        tag_value="testawstagvalue")
    ```


    :param builtins.str address_realm: Specifies whether to look for public or private IP addresses,default `private`.
    :param builtins.str aws_access_key: Information for discovering AWS nodes that are not in the same region as your BIG-IP (also requires the `aws_secret_access_key` field)
    :param builtins.str aws_region: AWS region in which ADC is running,default Empty string.
    :param builtins.str aws_secret_access_key: Information for discovering AWS nodes that are not in the same region as your BIG-IP (also requires the `aws_secret_access_key` field)
    :param builtins.bool credential_update: Specifies whether you are updating your credentials,default `false`.
    :param builtins.str external_id: AWS externalID field.
    :param builtins.str minimum_monitors: Member is down when fewer than minimum monitors report it healthy.
    :param builtins.int port: Port to be used for AWS service discovery,default `80`.
    :param builtins.str role_arn: Assume a role (also requires the `external_id` field)
    :param builtins.str tag_key: The tag key associated with the node to add to this pool.
    :param builtins.str tag_value: The tag value associated with the node to add to this pool.
    :param builtins.str undetectable_action: Action to take when node cannot be detected,default `remove`.
    :param builtins.str update_interval: Update interval for service discovery.
    """
    __args__ = dict()
    __args__['addressRealm'] = address_realm
    __args__['awsAccessKey'] = aws_access_key
    __args__['awsRegion'] = aws_region
    __args__['awsSecretAccessKey'] = aws_secret_access_key
    __args__['credentialUpdate'] = credential_update
    __args__['externalId'] = external_id
    __args__['minimumMonitors'] = minimum_monitors
    __args__['port'] = port
    __args__['roleArn'] = role_arn
    __args__['tagKey'] = tag_key
    __args__['tagValue'] = tag_value
    __args__['type'] = type
    __args__['undetectableAction'] = undetectable_action
    __args__['updateInterval'] = update_interval
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('f5bigip:fast/getAwsServiceDiscovery:getAwsServiceDiscovery', __args__, opts=opts, typ=GetAwsServiceDiscoveryResult).value

    return AwaitableGetAwsServiceDiscoveryResult(
        address_realm=pulumi.get(__ret__, 'address_realm'),
        aws_access_key=pulumi.get(__ret__, 'aws_access_key'),
        aws_region=pulumi.get(__ret__, 'aws_region'),
        aws_sd_json=pulumi.get(__ret__, 'aws_sd_json'),
        aws_secret_access_key=pulumi.get(__ret__, 'aws_secret_access_key'),
        credential_update=pulumi.get(__ret__, 'credential_update'),
        external_id=pulumi.get(__ret__, 'external_id'),
        id=pulumi.get(__ret__, 'id'),
        minimum_monitors=pulumi.get(__ret__, 'minimum_monitors'),
        port=pulumi.get(__ret__, 'port'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        tag_key=pulumi.get(__ret__, 'tag_key'),
        tag_value=pulumi.get(__ret__, 'tag_value'),
        type=pulumi.get(__ret__, 'type'),
        undetectable_action=pulumi.get(__ret__, 'undetectable_action'),
        update_interval=pulumi.get(__ret__, 'update_interval'))
def get_aws_service_discovery_output(address_realm: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     aws_access_key: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     aws_region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     aws_secret_access_key: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     credential_update: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                     external_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     minimum_monitors: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     port: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                     role_arn: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     tag_key: Optional[pulumi.Input[builtins.str]] = None,
                                     tag_value: Optional[pulumi.Input[builtins.str]] = None,
                                     type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     undetectable_action: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     update_interval: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsServiceDiscoveryResult]:
    """
    Use this data source (`fast_get_aws_service_discovery`) to get the AWS Service discovery config to be used for `http`/`https` app deployment in FAST.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    tc2 = f5bigip.fast.get_aws_service_discovery(tag_key="testawstagkey",
        tag_value="testawstagvalue")
    ```


    :param builtins.str address_realm: Specifies whether to look for public or private IP addresses,default `private`.
    :param builtins.str aws_access_key: Information for discovering AWS nodes that are not in the same region as your BIG-IP (also requires the `aws_secret_access_key` field)
    :param builtins.str aws_region: AWS region in which ADC is running,default Empty string.
    :param builtins.str aws_secret_access_key: Information for discovering AWS nodes that are not in the same region as your BIG-IP (also requires the `aws_secret_access_key` field)
    :param builtins.bool credential_update: Specifies whether you are updating your credentials,default `false`.
    :param builtins.str external_id: AWS externalID field.
    :param builtins.str minimum_monitors: Member is down when fewer than minimum monitors report it healthy.
    :param builtins.int port: Port to be used for AWS service discovery,default `80`.
    :param builtins.str role_arn: Assume a role (also requires the `external_id` field)
    :param builtins.str tag_key: The tag key associated with the node to add to this pool.
    :param builtins.str tag_value: The tag value associated with the node to add to this pool.
    :param builtins.str undetectable_action: Action to take when node cannot be detected,default `remove`.
    :param builtins.str update_interval: Update interval for service discovery.
    """
    __args__ = dict()
    __args__['addressRealm'] = address_realm
    __args__['awsAccessKey'] = aws_access_key
    __args__['awsRegion'] = aws_region
    __args__['awsSecretAccessKey'] = aws_secret_access_key
    __args__['credentialUpdate'] = credential_update
    __args__['externalId'] = external_id
    __args__['minimumMonitors'] = minimum_monitors
    __args__['port'] = port
    __args__['roleArn'] = role_arn
    __args__['tagKey'] = tag_key
    __args__['tagValue'] = tag_value
    __args__['type'] = type
    __args__['undetectableAction'] = undetectable_action
    __args__['updateInterval'] = update_interval
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('f5bigip:fast/getAwsServiceDiscovery:getAwsServiceDiscovery', __args__, opts=opts, typ=GetAwsServiceDiscoveryResult)
    return __ret__.apply(lambda __response__: GetAwsServiceDiscoveryResult(
        address_realm=pulumi.get(__response__, 'address_realm'),
        aws_access_key=pulumi.get(__response__, 'aws_access_key'),
        aws_region=pulumi.get(__response__, 'aws_region'),
        aws_sd_json=pulumi.get(__response__, 'aws_sd_json'),
        aws_secret_access_key=pulumi.get(__response__, 'aws_secret_access_key'),
        credential_update=pulumi.get(__response__, 'credential_update'),
        external_id=pulumi.get(__response__, 'external_id'),
        id=pulumi.get(__response__, 'id'),
        minimum_monitors=pulumi.get(__response__, 'minimum_monitors'),
        port=pulumi.get(__response__, 'port'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        tag_key=pulumi.get(__response__, 'tag_key'),
        tag_value=pulumi.get(__response__, 'tag_value'),
        type=pulumi.get(__response__, 'type'),
        undetectable_action=pulumi.get(__response__, 'undetectable_action'),
        update_interval=pulumi.get(__response__, 'update_interval')))
