# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FastUdpAppArgs', 'FastUdpApp']

@pulumi.input_type
class FastUdpAppArgs:
    def __init__(__self__, *,
                 application: pulumi.Input[builtins.str],
                 tenant: pulumi.Input[builtins.str],
                 enable_fastl4: Optional[pulumi.Input[builtins.bool]] = None,
                 existing_monitor: Optional[pulumi.Input[builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[builtins.str]] = None,
                 existing_profile: Optional[pulumi.Input[builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor: Optional[pulumi.Input['FastUdpAppMonitorArgs']] = None,
                 persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 virtual_server: Optional[pulumi.Input['FastUdpAppVirtualServerArgs']] = None,
                 vlans_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_rejecteds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a FastUdpApp resource.
        :param pulumi.Input[builtins.str] application: Name of the FAST UDP application.
        :param pulumi.Input[builtins.str] tenant: Name of the FAST UDP application tenant.
        :param pulumi.Input[builtins.bool] enable_fastl4: Enables use of FastL4 profiles.
        :param pulumi.Input[builtins.str] existing_monitor: Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[builtins.str] existing_pool: Name of an existing BIG-IP pool.
        :param pulumi.Input[builtins.str] existing_profile: Name of an existing BIG-IP FastL4 or UDP profile.
        :param pulumi.Input[builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: Irules to attach to Virtual Server.
        :param pulumi.Input[builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input['FastUdpAppMonitorArgs'] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Existing security log profiles to enable.
        :param pulumi.Input[builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input['FastUdpAppVirtualServerArgs'] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_alloweds: Names of existing VLANs to allow.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_rejecteds: Names of existing VLANs to reject.
        """
        pulumi.set(__self__, "application", application)
        pulumi.set(__self__, "tenant", tenant)
        if enable_fastl4 is not None:
            pulumi.set(__self__, "enable_fastl4", enable_fastl4)
        if existing_monitor is not None:
            pulumi.set(__self__, "existing_monitor", existing_monitor)
        if existing_pool is not None:
            pulumi.set(__self__, "existing_pool", existing_pool)
        if existing_profile is not None:
            pulumi.set(__self__, "existing_profile", existing_profile)
        if existing_snat_pool is not None:
            pulumi.set(__self__, "existing_snat_pool", existing_snat_pool)
        if fallback_persistence is not None:
            pulumi.set(__self__, "fallback_persistence", fallback_persistence)
        if irules is not None:
            pulumi.set(__self__, "irules", irules)
        if load_balancing_mode is not None:
            pulumi.set(__self__, "load_balancing_mode", load_balancing_mode)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if persistence_profile is not None:
            pulumi.set(__self__, "persistence_profile", persistence_profile)
        if persistence_type is not None:
            pulumi.set(__self__, "persistence_type", persistence_type)
        if pool_members is not None:
            pulumi.set(__self__, "pool_members", pool_members)
        if security_log_profiles is not None:
            pulumi.set(__self__, "security_log_profiles", security_log_profiles)
        if slow_ramp_time is not None:
            pulumi.set(__self__, "slow_ramp_time", slow_ramp_time)
        if snat_pool_addresses is not None:
            pulumi.set(__self__, "snat_pool_addresses", snat_pool_addresses)
        if virtual_server is not None:
            pulumi.set(__self__, "virtual_server", virtual_server)
        if vlans_alloweds is not None:
            pulumi.set(__self__, "vlans_alloweds", vlans_alloweds)
        if vlans_rejecteds is not None:
            pulumi.set(__self__, "vlans_rejecteds", vlans_rejecteds)

    @property
    @pulumi.getter
    def application(self) -> pulumi.Input[builtins.str]:
        """
        Name of the FAST UDP application.
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter
    def tenant(self) -> pulumi.Input[builtins.str]:
        """
        Name of the FAST UDP application tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenant", value)

    @property
    @pulumi.getter(name="enableFastl4")
    def enable_fastl4(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables use of FastL4 profiles.
        """
        return pulumi.get(self, "enable_fastl4")

    @enable_fastl4.setter
    def enable_fastl4(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_fastl4", value)

    @property
    @pulumi.getter(name="existingMonitor")
    def existing_monitor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        """
        return pulumi.get(self, "existing_monitor")

    @existing_monitor.setter
    def existing_monitor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_monitor", value)

    @property
    @pulumi.getter(name="existingPool")
    def existing_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP pool.
        """
        return pulumi.get(self, "existing_pool")

    @existing_pool.setter
    def existing_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_pool", value)

    @property
    @pulumi.getter(name="existingProfile")
    def existing_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP FastL4 or UDP profile.
        """
        return pulumi.get(self, "existing_profile")

    @existing_profile.setter
    def existing_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_profile", value)

    @property
    @pulumi.getter(name="existingSnatPool")
    def existing_snat_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP SNAT pool.
        """
        return pulumi.get(self, "existing_snat_pool")

    @existing_snat_pool.setter
    def existing_snat_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_snat_pool", value)

    @property
    @pulumi.getter(name="fallbackPersistence")
    def fallback_persistence(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of fallback persistence record to be created for each new client connection.
        """
        return pulumi.get(self, "fallback_persistence")

    @fallback_persistence.setter
    def fallback_persistence(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_persistence", value)

    @property
    @pulumi.getter
    def irules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Irules to attach to Virtual Server.
        """
        return pulumi.get(self, "irules")

    @irules.setter
    def irules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "irules", value)

    @property
    @pulumi.getter(name="loadBalancingMode")
    def load_balancing_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        """
        return pulumi.get(self, "load_balancing_mode")

    @load_balancing_mode.setter
    def load_balancing_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancing_mode", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['FastUdpAppMonitorArgs']]:
        """
        `monitor` block takes input for FAST-Generated Pool Monitor.
        See Pool Monitor below for more details.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['FastUdpAppMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter(name="persistenceProfile")
    def persistence_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP persistence profile to be used.
        """
        return pulumi.get(self, "persistence_profile")

    @persistence_profile.setter
    def persistence_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persistence_profile", value)

    @property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        """
        return pulumi.get(self, "persistence_type")

    @persistence_type.setter
    def persistence_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persistence_type", value)

    @property
    @pulumi.getter(name="poolMembers")
    def pool_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]]]:
        """
        `pool_members` block takes input for FAST-Generated Pool.
        See Pool Members below for more details.
        """
        return pulumi.get(self, "pool_members")

    @pool_members.setter
    def pool_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]]]):
        pulumi.set(self, "pool_members", value)

    @property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Existing security log profiles to enable.
        """
        return pulumi.get(self, "security_log_profiles")

    @security_log_profiles.setter
    def security_log_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_log_profiles", value)

    @property
    @pulumi.getter(name="slowRampTime")
    def slow_ramp_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        """
        return pulumi.get(self, "slow_ramp_time")

    @slow_ramp_time.setter
    def slow_ramp_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "slow_ramp_time", value)

    @property
    @pulumi.getter(name="snatPoolAddresses")
    def snat_pool_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of address to be used for FAST-Generated SNAT Pool.
        """
        return pulumi.get(self, "snat_pool_addresses")

    @snat_pool_addresses.setter
    def snat_pool_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snat_pool_addresses", value)

    @property
    @pulumi.getter(name="virtualServer")
    def virtual_server(self) -> Optional[pulumi.Input['FastUdpAppVirtualServerArgs']]:
        """
        `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
        See virtual server below for more details.
        """
        return pulumi.get(self, "virtual_server")

    @virtual_server.setter
    def virtual_server(self, value: Optional[pulumi.Input['FastUdpAppVirtualServerArgs']]):
        pulumi.set(self, "virtual_server", value)

    @property
    @pulumi.getter(name="vlansAlloweds")
    def vlans_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of existing VLANs to allow.
        """
        return pulumi.get(self, "vlans_alloweds")

    @vlans_alloweds.setter
    def vlans_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans_alloweds", value)

    @property
    @pulumi.getter(name="vlansRejecteds")
    def vlans_rejecteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of existing VLANs to reject.
        """
        return pulumi.get(self, "vlans_rejecteds")

    @vlans_rejecteds.setter
    def vlans_rejecteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans_rejecteds", value)


@pulumi.input_type
class _FastUdpAppState:
    def __init__(__self__, *,
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 enable_fastl4: Optional[pulumi.Input[builtins.bool]] = None,
                 existing_monitor: Optional[pulumi.Input[builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[builtins.str]] = None,
                 existing_profile: Optional[pulumi.Input[builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[builtins.str]] = None,
                 fast_udp_json: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor: Optional[pulumi.Input['FastUdpAppMonitorArgs']] = None,
                 persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_server: Optional[pulumi.Input['FastUdpAppVirtualServerArgs']] = None,
                 vlans_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_rejecteds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FastUdpApp resources.
        :param pulumi.Input[builtins.str] application: Name of the FAST UDP application.
        :param pulumi.Input[builtins.bool] enable_fastl4: Enables use of FastL4 profiles.
        :param pulumi.Input[builtins.str] existing_monitor: Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[builtins.str] existing_pool: Name of an existing BIG-IP pool.
        :param pulumi.Input[builtins.str] existing_profile: Name of an existing BIG-IP FastL4 or UDP profile.
        :param pulumi.Input[builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[builtins.str] fast_udp_json: Json payload for FAST UDP application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: Irules to attach to Virtual Server.
        :param pulumi.Input[builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input['FastUdpAppMonitorArgs'] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Existing security log profiles to enable.
        :param pulumi.Input[builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input[builtins.str] tenant: Name of the FAST UDP application tenant.
        :param pulumi.Input['FastUdpAppVirtualServerArgs'] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_alloweds: Names of existing VLANs to allow.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_rejecteds: Names of existing VLANs to reject.
        """
        if application is not None:
            pulumi.set(__self__, "application", application)
        if enable_fastl4 is not None:
            pulumi.set(__self__, "enable_fastl4", enable_fastl4)
        if existing_monitor is not None:
            pulumi.set(__self__, "existing_monitor", existing_monitor)
        if existing_pool is not None:
            pulumi.set(__self__, "existing_pool", existing_pool)
        if existing_profile is not None:
            pulumi.set(__self__, "existing_profile", existing_profile)
        if existing_snat_pool is not None:
            pulumi.set(__self__, "existing_snat_pool", existing_snat_pool)
        if fallback_persistence is not None:
            pulumi.set(__self__, "fallback_persistence", fallback_persistence)
        if fast_udp_json is not None:
            pulumi.set(__self__, "fast_udp_json", fast_udp_json)
        if irules is not None:
            pulumi.set(__self__, "irules", irules)
        if load_balancing_mode is not None:
            pulumi.set(__self__, "load_balancing_mode", load_balancing_mode)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if persistence_profile is not None:
            pulumi.set(__self__, "persistence_profile", persistence_profile)
        if persistence_type is not None:
            pulumi.set(__self__, "persistence_type", persistence_type)
        if pool_members is not None:
            pulumi.set(__self__, "pool_members", pool_members)
        if security_log_profiles is not None:
            pulumi.set(__self__, "security_log_profiles", security_log_profiles)
        if slow_ramp_time is not None:
            pulumi.set(__self__, "slow_ramp_time", slow_ramp_time)
        if snat_pool_addresses is not None:
            pulumi.set(__self__, "snat_pool_addresses", snat_pool_addresses)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if virtual_server is not None:
            pulumi.set(__self__, "virtual_server", virtual_server)
        if vlans_alloweds is not None:
            pulumi.set(__self__, "vlans_alloweds", vlans_alloweds)
        if vlans_rejecteds is not None:
            pulumi.set(__self__, "vlans_rejecteds", vlans_rejecteds)

    @property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the FAST UDP application.
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter(name="enableFastl4")
    def enable_fastl4(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables use of FastL4 profiles.
        """
        return pulumi.get(self, "enable_fastl4")

    @enable_fastl4.setter
    def enable_fastl4(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_fastl4", value)

    @property
    @pulumi.getter(name="existingMonitor")
    def existing_monitor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        """
        return pulumi.get(self, "existing_monitor")

    @existing_monitor.setter
    def existing_monitor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_monitor", value)

    @property
    @pulumi.getter(name="existingPool")
    def existing_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP pool.
        """
        return pulumi.get(self, "existing_pool")

    @existing_pool.setter
    def existing_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_pool", value)

    @property
    @pulumi.getter(name="existingProfile")
    def existing_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP FastL4 or UDP profile.
        """
        return pulumi.get(self, "existing_profile")

    @existing_profile.setter
    def existing_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_profile", value)

    @property
    @pulumi.getter(name="existingSnatPool")
    def existing_snat_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP SNAT pool.
        """
        return pulumi.get(self, "existing_snat_pool")

    @existing_snat_pool.setter
    def existing_snat_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "existing_snat_pool", value)

    @property
    @pulumi.getter(name="fallbackPersistence")
    def fallback_persistence(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of fallback persistence record to be created for each new client connection.
        """
        return pulumi.get(self, "fallback_persistence")

    @fallback_persistence.setter
    def fallback_persistence(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_persistence", value)

    @property
    @pulumi.getter(name="fastUdpJson")
    def fast_udp_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Json payload for FAST UDP application.
        """
        return pulumi.get(self, "fast_udp_json")

    @fast_udp_json.setter
    def fast_udp_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fast_udp_json", value)

    @property
    @pulumi.getter
    def irules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Irules to attach to Virtual Server.
        """
        return pulumi.get(self, "irules")

    @irules.setter
    def irules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "irules", value)

    @property
    @pulumi.getter(name="loadBalancingMode")
    def load_balancing_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        """
        return pulumi.get(self, "load_balancing_mode")

    @load_balancing_mode.setter
    def load_balancing_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancing_mode", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['FastUdpAppMonitorArgs']]:
        """
        `monitor` block takes input for FAST-Generated Pool Monitor.
        See Pool Monitor below for more details.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['FastUdpAppMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter(name="persistenceProfile")
    def persistence_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing BIG-IP persistence profile to be used.
        """
        return pulumi.get(self, "persistence_profile")

    @persistence_profile.setter
    def persistence_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persistence_profile", value)

    @property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        """
        return pulumi.get(self, "persistence_type")

    @persistence_type.setter
    def persistence_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persistence_type", value)

    @property
    @pulumi.getter(name="poolMembers")
    def pool_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]]]:
        """
        `pool_members` block takes input for FAST-Generated Pool.
        See Pool Members below for more details.
        """
        return pulumi.get(self, "pool_members")

    @pool_members.setter
    def pool_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FastUdpAppPoolMemberArgs']]]]):
        pulumi.set(self, "pool_members", value)

    @property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Existing security log profiles to enable.
        """
        return pulumi.get(self, "security_log_profiles")

    @security_log_profiles.setter
    def security_log_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_log_profiles", value)

    @property
    @pulumi.getter(name="slowRampTime")
    def slow_ramp_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        """
        return pulumi.get(self, "slow_ramp_time")

    @slow_ramp_time.setter
    def slow_ramp_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "slow_ramp_time", value)

    @property
    @pulumi.getter(name="snatPoolAddresses")
    def snat_pool_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of address to be used for FAST-Generated SNAT Pool.
        """
        return pulumi.get(self, "snat_pool_addresses")

    @snat_pool_addresses.setter
    def snat_pool_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snat_pool_addresses", value)

    @property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the FAST UDP application tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant", value)

    @property
    @pulumi.getter(name="virtualServer")
    def virtual_server(self) -> Optional[pulumi.Input['FastUdpAppVirtualServerArgs']]:
        """
        `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
        See virtual server below for more details.
        """
        return pulumi.get(self, "virtual_server")

    @virtual_server.setter
    def virtual_server(self, value: Optional[pulumi.Input['FastUdpAppVirtualServerArgs']]):
        pulumi.set(self, "virtual_server", value)

    @property
    @pulumi.getter(name="vlansAlloweds")
    def vlans_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of existing VLANs to allow.
        """
        return pulumi.get(self, "vlans_alloweds")

    @vlans_alloweds.setter
    def vlans_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans_alloweds", value)

    @property
    @pulumi.getter(name="vlansRejecteds")
    def vlans_rejecteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of existing VLANs to reject.
        """
        return pulumi.get(self, "vlans_rejecteds")

    @vlans_rejecteds.setter
    def vlans_rejecteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans_rejecteds", value)


@pulumi.type_token("f5bigip:index/fastUdpApp:FastUdpApp")
class FastUdpApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 enable_fastl4: Optional[pulumi.Input[builtins.bool]] = None,
                 existing_monitor: Optional[pulumi.Input[builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[builtins.str]] = None,
                 existing_profile: Optional[pulumi.Input[builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor: Optional[pulumi.Input[Union['FastUdpAppMonitorArgs', 'FastUdpAppMonitorArgsDict']]] = None,
                 persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FastUdpAppPoolMemberArgs', 'FastUdpAppPoolMemberArgsDict']]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_server: Optional[pulumi.Input[Union['FastUdpAppVirtualServerArgs', 'FastUdpAppVirtualServerArgsDict']]] = None,
                 vlans_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_rejecteds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        `FastUdpApp` This resource will create and manage FAST UDP applications on BIG-IP from provided JSON declaration.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application: Name of the FAST UDP application.
        :param pulumi.Input[builtins.bool] enable_fastl4: Enables use of FastL4 profiles.
        :param pulumi.Input[builtins.str] existing_monitor: Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[builtins.str] existing_pool: Name of an existing BIG-IP pool.
        :param pulumi.Input[builtins.str] existing_profile: Name of an existing BIG-IP FastL4 or UDP profile.
        :param pulumi.Input[builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: Irules to attach to Virtual Server.
        :param pulumi.Input[builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input[Union['FastUdpAppMonitorArgs', 'FastUdpAppMonitorArgsDict']] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FastUdpAppPoolMemberArgs', 'FastUdpAppPoolMemberArgsDict']]]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Existing security log profiles to enable.
        :param pulumi.Input[builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input[builtins.str] tenant: Name of the FAST UDP application tenant.
        :param pulumi.Input[Union['FastUdpAppVirtualServerArgs', 'FastUdpAppVirtualServerArgsDict']] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_alloweds: Names of existing VLANs to allow.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_rejecteds: Names of existing VLANs to reject.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FastUdpAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `FastUdpApp` This resource will create and manage FAST UDP applications on BIG-IP from provided JSON declaration.

        :param str resource_name: The name of the resource.
        :param FastUdpAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FastUdpAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[builtins.str]] = None,
                 enable_fastl4: Optional[pulumi.Input[builtins.bool]] = None,
                 existing_monitor: Optional[pulumi.Input[builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[builtins.str]] = None,
                 existing_profile: Optional[pulumi.Input[builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor: Optional[pulumi.Input[Union['FastUdpAppMonitorArgs', 'FastUdpAppMonitorArgsDict']]] = None,
                 persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FastUdpAppPoolMemberArgs', 'FastUdpAppPoolMemberArgsDict']]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_server: Optional[pulumi.Input[Union['FastUdpAppVirtualServerArgs', 'FastUdpAppVirtualServerArgsDict']]] = None,
                 vlans_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_rejecteds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FastUdpAppArgs.__new__(FastUdpAppArgs)

            if application is None and not opts.urn:
                raise TypeError("Missing required property 'application'")
            __props__.__dict__["application"] = application
            __props__.__dict__["enable_fastl4"] = enable_fastl4
            __props__.__dict__["existing_monitor"] = existing_monitor
            __props__.__dict__["existing_pool"] = existing_pool
            __props__.__dict__["existing_profile"] = existing_profile
            __props__.__dict__["existing_snat_pool"] = existing_snat_pool
            __props__.__dict__["fallback_persistence"] = fallback_persistence
            __props__.__dict__["irules"] = irules
            __props__.__dict__["load_balancing_mode"] = load_balancing_mode
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["persistence_profile"] = persistence_profile
            __props__.__dict__["persistence_type"] = persistence_type
            __props__.__dict__["pool_members"] = pool_members
            __props__.__dict__["security_log_profiles"] = security_log_profiles
            __props__.__dict__["slow_ramp_time"] = slow_ramp_time
            __props__.__dict__["snat_pool_addresses"] = snat_pool_addresses
            if tenant is None and not opts.urn:
                raise TypeError("Missing required property 'tenant'")
            __props__.__dict__["tenant"] = tenant
            __props__.__dict__["virtual_server"] = virtual_server
            __props__.__dict__["vlans_alloweds"] = vlans_alloweds
            __props__.__dict__["vlans_rejecteds"] = vlans_rejecteds
            __props__.__dict__["fast_udp_json"] = None
        super(FastUdpApp, __self__).__init__(
            'f5bigip:index/fastUdpApp:FastUdpApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application: Optional[pulumi.Input[builtins.str]] = None,
            enable_fastl4: Optional[pulumi.Input[builtins.bool]] = None,
            existing_monitor: Optional[pulumi.Input[builtins.str]] = None,
            existing_pool: Optional[pulumi.Input[builtins.str]] = None,
            existing_profile: Optional[pulumi.Input[builtins.str]] = None,
            existing_snat_pool: Optional[pulumi.Input[builtins.str]] = None,
            fallback_persistence: Optional[pulumi.Input[builtins.str]] = None,
            fast_udp_json: Optional[pulumi.Input[builtins.str]] = None,
            irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            load_balancing_mode: Optional[pulumi.Input[builtins.str]] = None,
            monitor: Optional[pulumi.Input[Union['FastUdpAppMonitorArgs', 'FastUdpAppMonitorArgsDict']]] = None,
            persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
            persistence_type: Optional[pulumi.Input[builtins.str]] = None,
            pool_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FastUdpAppPoolMemberArgs', 'FastUdpAppPoolMemberArgsDict']]]]] = None,
            security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            slow_ramp_time: Optional[pulumi.Input[builtins.int]] = None,
            snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tenant: Optional[pulumi.Input[builtins.str]] = None,
            virtual_server: Optional[pulumi.Input[Union['FastUdpAppVirtualServerArgs', 'FastUdpAppVirtualServerArgsDict']]] = None,
            vlans_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            vlans_rejecteds: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'FastUdpApp':
        """
        Get an existing FastUdpApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application: Name of the FAST UDP application.
        :param pulumi.Input[builtins.bool] enable_fastl4: Enables use of FastL4 profiles.
        :param pulumi.Input[builtins.str] existing_monitor: Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[builtins.str] existing_pool: Name of an existing BIG-IP pool.
        :param pulumi.Input[builtins.str] existing_profile: Name of an existing BIG-IP FastL4 or UDP profile.
        :param pulumi.Input[builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[builtins.str] fast_udp_json: Json payload for FAST UDP application.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: Irules to attach to Virtual Server.
        :param pulumi.Input[builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input[Union['FastUdpAppMonitorArgs', 'FastUdpAppMonitorArgsDict']] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FastUdpAppPoolMemberArgs', 'FastUdpAppPoolMemberArgsDict']]]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Existing security log profiles to enable.
        :param pulumi.Input[builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input[builtins.str] tenant: Name of the FAST UDP application tenant.
        :param pulumi.Input[Union['FastUdpAppVirtualServerArgs', 'FastUdpAppVirtualServerArgsDict']] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_alloweds: Names of existing VLANs to allow.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans_rejecteds: Names of existing VLANs to reject.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FastUdpAppState.__new__(_FastUdpAppState)

        __props__.__dict__["application"] = application
        __props__.__dict__["enable_fastl4"] = enable_fastl4
        __props__.__dict__["existing_monitor"] = existing_monitor
        __props__.__dict__["existing_pool"] = existing_pool
        __props__.__dict__["existing_profile"] = existing_profile
        __props__.__dict__["existing_snat_pool"] = existing_snat_pool
        __props__.__dict__["fallback_persistence"] = fallback_persistence
        __props__.__dict__["fast_udp_json"] = fast_udp_json
        __props__.__dict__["irules"] = irules
        __props__.__dict__["load_balancing_mode"] = load_balancing_mode
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["persistence_profile"] = persistence_profile
        __props__.__dict__["persistence_type"] = persistence_type
        __props__.__dict__["pool_members"] = pool_members
        __props__.__dict__["security_log_profiles"] = security_log_profiles
        __props__.__dict__["slow_ramp_time"] = slow_ramp_time
        __props__.__dict__["snat_pool_addresses"] = snat_pool_addresses
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["virtual_server"] = virtual_server
        __props__.__dict__["vlans_alloweds"] = vlans_alloweds
        __props__.__dict__["vlans_rejecteds"] = vlans_rejecteds
        return FastUdpApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def application(self) -> pulumi.Output[builtins.str]:
        """
        Name of the FAST UDP application.
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter(name="enableFastl4")
    def enable_fastl4(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables use of FastL4 profiles.
        """
        return pulumi.get(self, "enable_fastl4")

    @property
    @pulumi.getter(name="existingMonitor")
    def existing_monitor(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing BIG-IP UDP pool monitor. Monitors are used to determine the health of the application on each server.
        """
        return pulumi.get(self, "existing_monitor")

    @property
    @pulumi.getter(name="existingPool")
    def existing_pool(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing BIG-IP pool.
        """
        return pulumi.get(self, "existing_pool")

    @property
    @pulumi.getter(name="existingProfile")
    def existing_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing BIG-IP FastL4 or UDP profile.
        """
        return pulumi.get(self, "existing_profile")

    @property
    @pulumi.getter(name="existingSnatPool")
    def existing_snat_pool(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing BIG-IP SNAT pool.
        """
        return pulumi.get(self, "existing_snat_pool")

    @property
    @pulumi.getter(name="fallbackPersistence")
    def fallback_persistence(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of fallback persistence record to be created for each new client connection.
        """
        return pulumi.get(self, "fallback_persistence")

    @property
    @pulumi.getter(name="fastUdpJson")
    def fast_udp_json(self) -> pulumi.Output[builtins.str]:
        """
        Json payload for FAST UDP application.
        """
        return pulumi.get(self, "fast_udp_json")

    @property
    @pulumi.getter
    def irules(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Irules to attach to Virtual Server.
        """
        return pulumi.get(self, "irules")

    @property
    @pulumi.getter(name="loadBalancingMode")
    def load_balancing_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        """
        return pulumi.get(self, "load_balancing_mode")

    @property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.FastUdpAppMonitor']]:
        """
        `monitor` block takes input for FAST-Generated Pool Monitor.
        See Pool Monitor below for more details.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter(name="persistenceProfile")
    def persistence_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing BIG-IP persistence profile to be used.
        """
        return pulumi.get(self, "persistence_profile")

    @property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        """
        return pulumi.get(self, "persistence_type")

    @property
    @pulumi.getter(name="poolMembers")
    def pool_members(self) -> pulumi.Output[Optional[Sequence['outputs.FastUdpAppPoolMember']]]:
        """
        `pool_members` block takes input for FAST-Generated Pool.
        See Pool Members below for more details.
        """
        return pulumi.get(self, "pool_members")

    @property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Existing security log profiles to enable.
        """
        return pulumi.get(self, "security_log_profiles")

    @property
    @pulumi.getter(name="slowRampTime")
    def slow_ramp_time(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        """
        return pulumi.get(self, "slow_ramp_time")

    @property
    @pulumi.getter(name="snatPoolAddresses")
    def snat_pool_addresses(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of address to be used for FAST-Generated SNAT Pool.
        """
        return pulumi.get(self, "snat_pool_addresses")

    @property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[builtins.str]:
        """
        Name of the FAST UDP application tenant.
        """
        return pulumi.get(self, "tenant")

    @property
    @pulumi.getter(name="virtualServer")
    def virtual_server(self) -> pulumi.Output[Optional['outputs.FastUdpAppVirtualServer']]:
        """
        `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
        See virtual server below for more details.
        """
        return pulumi.get(self, "virtual_server")

    @property
    @pulumi.getter(name="vlansAlloweds")
    def vlans_alloweds(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Names of existing VLANs to allow.
        """
        return pulumi.get(self, "vlans_alloweds")

    @property
    @pulumi.getter(name="vlansRejecteds")
    def vlans_rejecteds(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Names of existing VLANs to reject.
        """
        return pulumi.get(self, "vlans_rejecteds")

