# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IpsecPolicyArgs', 'IpsecPolicy']

@pulumi.input_type
class IpsecPolicyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 auth_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 ipcomp: Optional[pulumi.Input[builtins.str]] = None,
                 kb_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_local_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_remote_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IpsecPolicy resource.
        :param pulumi.Input[builtins.str] name: Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        :param pulumi.Input[builtins.str] auth_algorithm: Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
               aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        :param pulumi.Input[builtins.str] description: Description of the IPSec policy.
        :param pulumi.Input[builtins.str] encrypt_algorithm: Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
               aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        :param pulumi.Input[builtins.str] ipcomp: Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        :param pulumi.Input[builtins.int] kb_lifetime: Specifies the length of time before the IKE security association expires, in kilobytes.
        :param pulumi.Input[builtins.int] lifetime: Specifies the length of time before the IKE security association expires, in minutes.
        :param pulumi.Input[builtins.str] mode: Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        :param pulumi.Input[builtins.str] perfect_forward_secrecy: Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
               modp4096, modp6144, modp8192`
        :param pulumi.Input[builtins.str] protocol: Specifies the IPsec protocol. Valid choices are: `ah, esp`
        :param pulumi.Input[builtins.str] tunnel_local_address: Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        :param pulumi.Input[builtins.str] tunnel_remote_address: Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        pulumi.set(__self__, "name", name)
        if auth_algorithm is not None:
            pulumi.set(__self__, "auth_algorithm", auth_algorithm)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_algorithm is not None:
            pulumi.set(__self__, "encrypt_algorithm", encrypt_algorithm)
        if ipcomp is not None:
            pulumi.set(__self__, "ipcomp", ipcomp)
        if kb_lifetime is not None:
            pulumi.set(__self__, "kb_lifetime", kb_lifetime)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if perfect_forward_secrecy is not None:
            pulumi.set(__self__, "perfect_forward_secrecy", perfect_forward_secrecy)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if tunnel_local_address is not None:
            pulumi.set(__self__, "tunnel_local_address", tunnel_local_address)
        if tunnel_remote_address is not None:
            pulumi.set(__self__, "tunnel_remote_address", tunnel_remote_address)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="authAlgorithm")
    def auth_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
        aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        """
        return pulumi.get(self, "auth_algorithm")

    @auth_algorithm.setter
    def auth_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_algorithm", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the IPSec policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptAlgorithm")
    def encrypt_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
        aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        """
        return pulumi.get(self, "encrypt_algorithm")

    @encrypt_algorithm.setter
    def encrypt_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encrypt_algorithm", value)

    @property
    @pulumi.getter
    def ipcomp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        """
        return pulumi.get(self, "ipcomp")

    @ipcomp.setter
    def ipcomp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipcomp", value)

    @property
    @pulumi.getter(name="kbLifetime")
    def kb_lifetime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the length of time before the IKE security association expires, in kilobytes.
        """
        return pulumi.get(self, "kb_lifetime")

    @kb_lifetime.setter
    def kb_lifetime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "kb_lifetime", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the length of time before the IKE security association expires, in minutes.
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="perfectForwardSecrecy")
    def perfect_forward_secrecy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
        modp4096, modp6144, modp8192`
        """
        return pulumi.get(self, "perfect_forward_secrecy")

    @perfect_forward_secrecy.setter
    def perfect_forward_secrecy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "perfect_forward_secrecy", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the IPsec protocol. Valid choices are: `ah, esp`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="tunnelLocalAddress")
    def tunnel_local_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        return pulumi.get(self, "tunnel_local_address")

    @tunnel_local_address.setter
    def tunnel_local_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_local_address", value)

    @property
    @pulumi.getter(name="tunnelRemoteAddress")
    def tunnel_remote_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        return pulumi.get(self, "tunnel_remote_address")

    @tunnel_remote_address.setter
    def tunnel_remote_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_remote_address", value)


@pulumi.input_type
class _IpsecPolicyState:
    def __init__(__self__, *,
                 auth_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 ipcomp: Optional[pulumi.Input[builtins.str]] = None,
                 kb_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_local_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_remote_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpsecPolicy resources.
        :param pulumi.Input[builtins.str] auth_algorithm: Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
               aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        :param pulumi.Input[builtins.str] description: Description of the IPSec policy.
        :param pulumi.Input[builtins.str] encrypt_algorithm: Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
               aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        :param pulumi.Input[builtins.str] ipcomp: Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        :param pulumi.Input[builtins.int] kb_lifetime: Specifies the length of time before the IKE security association expires, in kilobytes.
        :param pulumi.Input[builtins.int] lifetime: Specifies the length of time before the IKE security association expires, in minutes.
        :param pulumi.Input[builtins.str] mode: Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        :param pulumi.Input[builtins.str] name: Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        :param pulumi.Input[builtins.str] perfect_forward_secrecy: Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
               modp4096, modp6144, modp8192`
        :param pulumi.Input[builtins.str] protocol: Specifies the IPsec protocol. Valid choices are: `ah, esp`
        :param pulumi.Input[builtins.str] tunnel_local_address: Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        :param pulumi.Input[builtins.str] tunnel_remote_address: Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        if auth_algorithm is not None:
            pulumi.set(__self__, "auth_algorithm", auth_algorithm)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_algorithm is not None:
            pulumi.set(__self__, "encrypt_algorithm", encrypt_algorithm)
        if ipcomp is not None:
            pulumi.set(__self__, "ipcomp", ipcomp)
        if kb_lifetime is not None:
            pulumi.set(__self__, "kb_lifetime", kb_lifetime)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if perfect_forward_secrecy is not None:
            pulumi.set(__self__, "perfect_forward_secrecy", perfect_forward_secrecy)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if tunnel_local_address is not None:
            pulumi.set(__self__, "tunnel_local_address", tunnel_local_address)
        if tunnel_remote_address is not None:
            pulumi.set(__self__, "tunnel_remote_address", tunnel_remote_address)

    @property
    @pulumi.getter(name="authAlgorithm")
    def auth_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
        aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        """
        return pulumi.get(self, "auth_algorithm")

    @auth_algorithm.setter
    def auth_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_algorithm", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the IPSec policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptAlgorithm")
    def encrypt_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
        aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        """
        return pulumi.get(self, "encrypt_algorithm")

    @encrypt_algorithm.setter
    def encrypt_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encrypt_algorithm", value)

    @property
    @pulumi.getter
    def ipcomp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        """
        return pulumi.get(self, "ipcomp")

    @ipcomp.setter
    def ipcomp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipcomp", value)

    @property
    @pulumi.getter(name="kbLifetime")
    def kb_lifetime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the length of time before the IKE security association expires, in kilobytes.
        """
        return pulumi.get(self, "kb_lifetime")

    @kb_lifetime.setter
    def kb_lifetime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "kb_lifetime", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the length of time before the IKE security association expires, in minutes.
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="perfectForwardSecrecy")
    def perfect_forward_secrecy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
        modp4096, modp6144, modp8192`
        """
        return pulumi.get(self, "perfect_forward_secrecy")

    @perfect_forward_secrecy.setter
    def perfect_forward_secrecy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "perfect_forward_secrecy", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the IPsec protocol. Valid choices are: `ah, esp`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="tunnelLocalAddress")
    def tunnel_local_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        return pulumi.get(self, "tunnel_local_address")

    @tunnel_local_address.setter
    def tunnel_local_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_local_address", value)

    @property
    @pulumi.getter(name="tunnelRemoteAddress")
    def tunnel_remote_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        return pulumi.get(self, "tunnel_remote_address")

    @tunnel_remote_address.setter
    def tunnel_remote_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_remote_address", value)


@pulumi.type_token("f5bigip:index/ipsecPolicy:IpsecPolicy")
class IpsecPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 ipcomp: Optional[pulumi.Input[builtins.str]] = None,
                 kb_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_local_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_remote_address: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `IpsecPolicy` Manage IPSec policies on a BIG-IP

        Resources should be named with their "full path". The full path is the combination of the partition + name (example: /Common/test-policy)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_policy = f5bigip.IpsecPolicy("test-policy",
            name="/Common/test-policy",
            description="created by terraform provider",
            protocol="esp",
            mode="tunnel",
            tunnel_local_address="192.168.1.1",
            tunnel_remote_address="10.10.1.1",
            auth_algorithm="sha1",
            encrypt_algorithm="3des",
            lifetime=3,
            ipcomp="deflate")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth_algorithm: Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
               aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        :param pulumi.Input[builtins.str] description: Description of the IPSec policy.
        :param pulumi.Input[builtins.str] encrypt_algorithm: Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
               aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        :param pulumi.Input[builtins.str] ipcomp: Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        :param pulumi.Input[builtins.int] kb_lifetime: Specifies the length of time before the IKE security association expires, in kilobytes.
        :param pulumi.Input[builtins.int] lifetime: Specifies the length of time before the IKE security association expires, in minutes.
        :param pulumi.Input[builtins.str] mode: Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        :param pulumi.Input[builtins.str] name: Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        :param pulumi.Input[builtins.str] perfect_forward_secrecy: Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
               modp4096, modp6144, modp8192`
        :param pulumi.Input[builtins.str] protocol: Specifies the IPsec protocol. Valid choices are: `ah, esp`
        :param pulumi.Input[builtins.str] tunnel_local_address: Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        :param pulumi.Input[builtins.str] tunnel_remote_address: Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpsecPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `IpsecPolicy` Manage IPSec policies on a BIG-IP

        Resources should be named with their "full path". The full path is the combination of the partition + name (example: /Common/test-policy)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_policy = f5bigip.IpsecPolicy("test-policy",
            name="/Common/test-policy",
            description="created by terraform provider",
            protocol="esp",
            mode="tunnel",
            tunnel_local_address="192.168.1.1",
            tunnel_remote_address="10.10.1.1",
            auth_algorithm="sha1",
            encrypt_algorithm="3des",
            lifetime=3,
            ipcomp="deflate")
        ```

        :param str resource_name: The name of the resource.
        :param IpsecPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsecPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 ipcomp: Optional[pulumi.Input[builtins.str]] = None,
                 kb_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_local_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_remote_address: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsecPolicyArgs.__new__(IpsecPolicyArgs)

            __props__.__dict__["auth_algorithm"] = auth_algorithm
            __props__.__dict__["description"] = description
            __props__.__dict__["encrypt_algorithm"] = encrypt_algorithm
            __props__.__dict__["ipcomp"] = ipcomp
            __props__.__dict__["kb_lifetime"] = kb_lifetime
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["mode"] = mode
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["perfect_forward_secrecy"] = perfect_forward_secrecy
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["tunnel_local_address"] = tunnel_local_address
            __props__.__dict__["tunnel_remote_address"] = tunnel_remote_address
        super(IpsecPolicy, __self__).__init__(
            'f5bigip:index/ipsecPolicy:IpsecPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_algorithm: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            encrypt_algorithm: Optional[pulumi.Input[builtins.str]] = None,
            ipcomp: Optional[pulumi.Input[builtins.str]] = None,
            kb_lifetime: Optional[pulumi.Input[builtins.int]] = None,
            lifetime: Optional[pulumi.Input[builtins.int]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            perfect_forward_secrecy: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_local_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_remote_address: Optional[pulumi.Input[builtins.str]] = None) -> 'IpsecPolicy':
        """
        Get an existing IpsecPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth_algorithm: Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
               aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        :param pulumi.Input[builtins.str] description: Description of the IPSec policy.
        :param pulumi.Input[builtins.str] encrypt_algorithm: Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
               aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        :param pulumi.Input[builtins.str] ipcomp: Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        :param pulumi.Input[builtins.int] kb_lifetime: Specifies the length of time before the IKE security association expires, in kilobytes.
        :param pulumi.Input[builtins.int] lifetime: Specifies the length of time before the IKE security association expires, in minutes.
        :param pulumi.Input[builtins.str] mode: Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        :param pulumi.Input[builtins.str] name: Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        :param pulumi.Input[builtins.str] perfect_forward_secrecy: Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
               modp4096, modp6144, modp8192`
        :param pulumi.Input[builtins.str] protocol: Specifies the IPsec protocol. Valid choices are: `ah, esp`
        :param pulumi.Input[builtins.str] tunnel_local_address: Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        :param pulumi.Input[builtins.str] tunnel_remote_address: Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsecPolicyState.__new__(_IpsecPolicyState)

        __props__.__dict__["auth_algorithm"] = auth_algorithm
        __props__.__dict__["description"] = description
        __props__.__dict__["encrypt_algorithm"] = encrypt_algorithm
        __props__.__dict__["ipcomp"] = ipcomp
        __props__.__dict__["kb_lifetime"] = kb_lifetime
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["perfect_forward_secrecy"] = perfect_forward_secrecy
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["tunnel_local_address"] = tunnel_local_address
        __props__.__dict__["tunnel_remote_address"] = tunnel_remote_address
        return IpsecPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authAlgorithm")
    def auth_algorithm(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the algorithm to use for IKE authentication. Valid choices are: `sha1, sha256, sha384, sha512, aes-gcm128,
        aes-gcm192, aes-gcm256, aes-gmac128, aes-gmac192, aes-gmac256`
        """
        return pulumi.get(self, "auth_algorithm")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the IPSec policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptAlgorithm")
    def encrypt_algorithm(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the algorithm to use for IKE encryption. Valid choices are: `null, 3des, aes128, aes192, aes256, aes-gmac256,
        aes-gmac192, aes-gmac128, aes-gcm256, aes-gcm192, aes-gcm256, aes-gcm128`
        """
        return pulumi.get(self, "encrypt_algorithm")

    @property
    @pulumi.getter
    def ipcomp(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether to use IPComp encapsulation. Valid choices are: `none", null", deflate`
        """
        return pulumi.get(self, "ipcomp")

    @property
    @pulumi.getter(name="kbLifetime")
    def kb_lifetime(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the length of time before the IKE security association expires, in kilobytes.
        """
        return pulumi.get(self, "kb_lifetime")

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the length of time before the IKE security association expires, in minutes.
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the processing mode. Valid choices are: `transport, interface, isession, tunnel`
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the IPSec policy,it should be "full path".The full path is the combination of the partition + name of the IPSec policy.(For example `/Common/test-policy`)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perfectForwardSecrecy")
    def perfect_forward_secrecy(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Diffie-Hellman group to use for IKE Phase 2 negotiation. Valid choices are: `none, modp768, modp1024, modp1536, modp2048, modp3072,
        modp4096, modp6144, modp8192`
        """
        return pulumi.get(self, "perfect_forward_secrecy")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the IPsec protocol. Valid choices are: `ah, esp`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="tunnelLocalAddress")
    def tunnel_local_address(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the local endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        return pulumi.get(self, "tunnel_local_address")

    @property
    @pulumi.getter(name="tunnelRemoteAddress")
    def tunnel_remote_address(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the remote endpoint IP address of the IPsec tunnel. This parameter is only valid when mode is tunnel.
        """
        return pulumi.get(self, "tunnel_remote_address")

